/*
 * Decompiled with CFR 0.152.
 */
package com.samxel.reducedloot;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.samxel.reducedloot.Config;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class ChanceLootModifier
extends LootModifier {
    public static final MapCodec<ChanceLootModifier> CODEC = RecordCodecBuilder.mapCodec(inst -> LootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, ChanceLootModifier::new));

    public ChanceLootModifier(LootItemCondition[] conditions) {
        super(conditions);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        ResourceLocation tableId = context.getQueriedLootTableId();
        String path = tableId.getPath();
        if (path.startsWith("chests/")) {
            ObjectArrayList filtered = new ObjectArrayList();
            double chance = Config.chance;
            RandomSource rand = context.getRandom();
            for (ItemStack stack : generatedLoot) {
                if (!(rand.nextDouble() < chance)) continue;
                filtered.add((Object)stack);
            }
            return filtered;
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

