/*
 * Decompiled with CFR 0.152.
 */
package com.samxel.reducedloot;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.samxel.reducedloot.Config;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class ChanceLootModifier
extends LootModifier {
    public static final Codec<ChanceLootModifier> CODEC = RecordCodecBuilder.create(inst -> LootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, ChanceLootModifier::new));

    public ChanceLootModifier(LootItemCondition[] conditions) {
        super(conditions);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        ResourceLocation tableId = context.getQueriedLootTableId();
        String path = tableId.m_135815_();
        if (path.startsWith("chests/")) {
            ObjectArrayList filtered = new ObjectArrayList();
            double chance = Config.chance;
            RandomSource rand = context.m_230907_();
            for (ItemStack stack : generatedLoot) {
                if (!(rand.m_188500_() < chance)) continue;
                filtered.add((Object)stack);
            }
            return filtered;
        }
        return generatedLoot;
    }

    public Codec<? extends LootModifier> codec() {
        return CODEC;
    }
}

