/*
 * Decompiled with CFR 0.152.
 */
package com.Pink_Cats.createentitycontroller.addition;

import com.Pink_Cats.createentitycontroller.addition.StructureBlockStorage;
import com.simibubi.create.content.contraptions.StructureTransform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class StructureFunc {
    public static Map<Block, List<int[]>> change_Template_to_Axis(Map<BlockPos, StructureTemplate.StructureBlockInfo> blocks) {
        HashMap<Block, List<int[]>> axis_result = new HashMap<Block, List<int[]>>();
        for (StructureTemplate.StructureBlockInfo block : blocks.values()) {
            Block blockType = block.state().getBlock();
            BlockPos pos = block.pos();
            int[] coordinates = new int[]{pos.getX(), pos.getY(), pos.getZ()};
            axis_result.computeIfAbsent(blockType, k -> new ArrayList()).add(coordinates);
        }
        return axis_result;
    }

    public static Map<Block, List<int[]>> reverseCoordinates(Map<Block, List<int[]>> original) {
        HashMap<Block, List<int[]>> reversed = new HashMap<Block, List<int[]>>();
        for (Map.Entry<Block, List<int[]>> entry : original.entrySet()) {
            Block block = entry.getKey();
            List<int[]> originalCoords = entry.getValue();
            ArrayList<int[]> reversedCoords = new ArrayList<int[]>();
            for (int[] coord : originalCoords) {
                int[] newCoord = new int[coord.length];
                newCoord[2] = coord[0];
                newCoord[0] = coord[2];
                newCoord[1] = coord[1];
                if (newCoord[0] > 0 && newCoord[2] > 0) {
                    newCoord[0] = -newCoord[0];
                } else if (newCoord[0] < 0 && newCoord[2] > 0) {
                    newCoord[0] = -newCoord[0];
                } else if (newCoord[0] < 0 && newCoord[2] < 0) {
                    newCoord[0] = -newCoord[0];
                } else if (newCoord[0] > 0 && newCoord[2] < 0) {
                    newCoord[0] = -newCoord[0];
                } else if (newCoord[0] > 0 && newCoord[2] == 0) {
                    newCoord[0] = -newCoord[0];
                } else if (newCoord[0] < 0 && newCoord[2] == 0) {
                    newCoord[0] = -newCoord[0];
                }
                reversedCoords.add(newCoord);
            }
            reversed.put(block, reversedCoords);
        }
        return reversed;
    }

    public static boolean StructureMatch(Map<BlockPos, StructureTemplate.StructureBlockInfo> blocks, StructureTransform transform) {
        List<StructureBlockStorage.BlockInfoEntry> entries = StructureBlockStorage.getAllBlockEntries();
        for (StructureBlockStorage.BlockInfoEntry entry : entries) {
            Map<Block, List<int[]>> newer_structure;
            Block blockType;
            if (blocks.size() != entry.getData().size()) continue;
            HashMap<Block, Integer> entryBlockCount = new HashMap<Block, Integer>();
            HashMap<Block, Integer> blockCount = new HashMap<Block, Integer>();
            for (StructureTemplate.StructureBlockInfo block : entry.getData().values()) {
                blockType = block.state().getBlock();
                entryBlockCount.put(blockType, entryBlockCount.getOrDefault(blockType, 0) + 1);
            }
            for (StructureTemplate.StructureBlockInfo block : blocks.values()) {
                blockType = block.state().getBlock();
                blockCount.put(blockType, blockCount.getOrDefault(blockType, 0) + 1);
                BlockPos pos = block.pos();
                pos.rotate(Rotation.CLOCKWISE_90);
            }
            boolean areBlocksEqual = entryBlockCount.equals(blockCount);
            if (!areBlocksEqual) continue;
            Map<Block, List<int[]>> exist_structure = StructureFunc.change_Template_to_Axis(entry.getData());
            if (StructureFunc.compareBlockCoordinates(exist_structure, newer_structure = StructureFunc.change_Template_to_Axis(blocks))) {
                return true;
            }
            for (int i = 0; i < 3; ++i) {
                if (!StructureFunc.compareBlockCoordinates(exist_structure, newer_structure = StructureFunc.reverseCoordinates(newer_structure))) continue;
                return true;
            }
        }
        return false;
    }

    private static String exist_structureToString(Map<Block, List<int[]>> structure) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (Map.Entry<Block, List<int[]>> entry : structure.entrySet()) {
            sb.append(entry.getKey()).append("=").append(StructureFunc.formatCoordinates(entry.getValue())).append(", ");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        sb.append("}");
        return sb.toString();
    }

    public static String formatCoordinates(List<int[]> coords) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int[] coord : coords) {
            sb.append(Arrays.toString(coord)).append(", ");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        sb.append("]");
        return sb.toString();
    }

    public static boolean compareBlockCoordinates(Map<Block, List<int[]>> map1, Map<Block, List<int[]>> map2) {
        for (Map.Entry<Block, List<int[]>> entry : map1.entrySet()) {
            Block block = entry.getKey();
            List<int[]> coords1 = entry.getValue();
            if (!map2.containsKey(block)) continue;
            List<int[]> coords2 = map2.get(block);
            HashSet<String> coordSet2 = new HashSet<String>();
            for (int[] coord : coords2) {
                coordSet2.add(Arrays.toString(coord));
            }
            for (int[] coord : coords1) {
                if (coordSet2.contains(Arrays.toString(coord))) continue;
                return false;
            }
        }
        return true;
    }
}

