/*
 * Decompiled with CFR 0.152.
 */
package com.Pink_Cats.createentitycontroller.mixin;

import com.Pink_Cats.createentitycontroller.Config;
import com.Pink_Cats.createentitycontroller.addition.EntityEnrollment;
import com.Pink_Cats.createentitycontroller.addition.StructureBlockStorage;
import com.Pink_Cats.createentitycontroller.addition.StructureFunc;
import com.google.common.collect.Multimap;
import com.mojang.logging.LogUtils;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.api.contraption.BlockMovementChecks;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.MountedStorageManager;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.contraptions.actors.seat.SeatBlock;
import com.simibubi.create.content.contraptions.bearing.WindmillBearingBlockEntity;
import com.simibubi.create.content.contraptions.chassis.AbstractChassisBlock;
import com.simibubi.create.content.contraptions.chassis.StickerBlock;
import com.simibubi.create.content.contraptions.glue.SuperGlueEntity;
import com.simibubi.create.content.contraptions.piston.MechanicalPistonBlock;
import com.simibubi.create.content.contraptions.pulley.PulleyBlock;
import com.simibubi.create.content.contraptions.pulley.PulleyBlockEntity;
import com.simibubi.create.content.decoration.slidingDoor.SlidingDoorBlock;
import com.simibubi.create.content.kinetics.chainConveyor.ChainConveyorBlockEntity;
import com.simibubi.create.content.kinetics.simpleRelays.ShaftBlock;
import com.simibubi.create.content.trains.bogey.AbstractBogeyBlock;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.data.UniqueLinkedList;
import net.createmod.catnip.nbt.NBTProcessors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Contraption.class}, remap=false)
public class ContraptionMixin {
    @Shadow
    public AABB bounds;
    @Shadow
    protected Map<BlockPos, StructureTemplate.StructureBlockInfo> blocks;
    @Shadow
    public BlockPos anchor;
    @Shadow
    private Map<BlockPos, Entity> initialPassengers;
    @Shadow
    private Set<SuperGlueEntity> glueToRemove;
    @Shadow
    protected List<AABB> superglue;
    @Shadow
    public boolean disassembled;
    @Shadow
    protected Multimap<BlockPos, StructureTemplate.StructureBlockInfo> capturedMultiblocks;
    @Shadow
    protected MountedStorageManager storage;
    @Unique
    Map<String, Integer> blockCountMap_r = new HashMap<String, Integer>();
    @Unique
    BlockPos createentitycontroller$minPos = new BlockPos(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    @Unique
    BlockPos createentitycontroller$maxPos = new BlockPos(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
    @Unique
    private static final Logger createentitycontroller$LOGGER = LogUtils.getLogger();

    @Shadow
    protected boolean addToInitialFrontier(Level world, BlockPos pos, Direction forcedDirection, Queue<BlockPos> frontier) {
        return true;
    }

    @Shadow
    protected boolean movementAllowed(BlockState state, Level world, BlockPos pos) {
        return false;
    }

    @Shadow
    protected boolean isAnchoringBlockAt(BlockPos pos) {
        return pos.equals((Object)this.anchor);
    }

    @Shadow
    private boolean moveChassis(Level world, BlockPos pos, Direction movementDirection, Queue<BlockPos> frontier, Set<BlockPos> visited) {
        return false;
    }

    @Shadow
    protected void addBlock(Level level, BlockPos pos, Pair<StructureTemplate.StructureBlockInfo, BlockEntity> pair) {
    }

    @Shadow
    private void moveBelt(BlockPos pos, Queue<BlockPos> frontier, Set<BlockPos> visited, BlockState state) {
    }

    @Shadow
    protected boolean shouldUpdateAfterMovement(StructureTemplate.StructureBlockInfo info) {
        return false;
    }

    @Shadow
    protected boolean customBlockPlacement(LevelAccessor world, BlockPos pos, BlockState state) {
        return false;
    }

    @Shadow
    protected void translateMultiblockControllers(StructureTransform transform) {
    }

    @Shadow
    protected Pair<StructureTemplate.StructureBlockInfo, BlockEntity> capture(Level world, BlockPos pos) {
        return null;
    }

    @Shadow
    protected void moveGantryPinion(Level world, BlockPos pos, Queue<BlockPos> frontier, Set<BlockPos> visited, BlockState state) {
    }

    @Shadow
    protected void moveGantryShaft(Level world, BlockPos pos, Queue<BlockPos> frontier, Set<BlockPos> visited, BlockState state) {
    }

    @Shadow
    private void moveBearing(BlockPos pos, Queue<BlockPos> frontier, Set<BlockPos> visited, BlockState state) {
    }

    @Shadow
    private void moveWindmillBearing(BlockPos pos, Queue<BlockPos> frontier, Set<BlockPos> visited, BlockState state) {
    }

    @Shadow
    private void moveSeat(Level world, BlockPos pos) {
    }

    @Shadow
    private void movePulley(Level world, BlockPos pos, Queue<BlockPos> frontier, Set<BlockPos> visited) {
    }

    @Shadow
    private boolean moveMechanicalPiston(Level world, BlockPos pos, Queue<BlockPos> frontier, Set<BlockPos> visited, BlockState state) {
        return true;
    }

    @Shadow
    protected void movePistonPole(Level world, BlockPos pos, Queue<BlockPos> frontier, Set<BlockPos> visited, BlockState state) {
    }

    @Shadow
    protected void movePistonHead(Level world, BlockPos pos, Queue<BlockPos> frontier, Set<BlockPos> visited, BlockState state) {
    }

    @Shadow
    protected boolean customBlockRemoval(LevelAccessor world, BlockPos pos, BlockState state) {
        return false;
    }

    @Shadow
    protected boolean moveBlock(Level world, Direction forcedDirection, Queue<BlockPos> frontier, Set<BlockPos> visited) {
        return false;
    }

    @Inject(method={"searchMovedStructure"}, at={@At(value="HEAD")}, cancellable=true)
    public void injectSearchMovedStructure(Level world, BlockPos pos, Direction forcedDirection, CallbackInfoReturnable<Boolean> cir) throws AssemblyException {
        this.initialPassengers.clear();
        UniqueLinkedList frontier = new UniqueLinkedList();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        this.anchor = pos;
        if (this.bounds == null) {
            this.bounds = new AABB(BlockPos.ZERO);
        }
        if (!BlockMovementChecks.isBrittle((BlockState)world.getBlockState(pos))) {
            frontier.add(pos);
        }
        if (!this.addToInitialFrontier(world, pos, forcedDirection, (Queue<BlockPos>)frontier)) {
            cir.setReturnValue((Object)false);
            return;
        }
        for (int limit = 100000; limit > 0; --limit) {
            if (frontier.isEmpty()) {
                if (Config.enableBlockEntityExperimentPara) {
                    int totalValue = this.createentitycontroller$getTotalStabilizeValue();
                    int globalCount = 0;
                    for (Integer count : this.blockCountMap_r.values()) {
                        globalCount += count.intValue();
                    }
                    System.setProperty("globalValue", Integer.toString(totalValue));
                    System.setProperty("globalCount", Integer.toString(globalCount));
                    if (totalValue > Config.block_entity_max_stabilize_count) {
                        throw AssemblyException.structureTooLarge();
                    }
                }
                cir.setReturnValue((Object)true);
                return;
            }
            if (this.moveBlock(world, forcedDirection, (Queue<BlockPos>)frontier, visited)) continue;
            cir.setReturnValue((Object)false);
            return;
        }
        throw AssemblyException.structureTooLarge();
    }

    @Unique
    private int createentitycontroller$getTotalStabilizeValue() {
        int totalValue = 0;
        int defaultValue = 100;
        for (Map.Entry<String, Integer> entry : this.blockCountMap_r.entrySet()) {
            String blockType = entry.getKey();
            Integer blockCount = entry.getValue();
            boolean found = false;
            for (List<Object> limitValue : Config.blocksLimitValues) {
                if (limitValue.size() <= 1 || !limitValue.get(0).equals(blockType)) continue;
                totalValue += blockCount * (Integer)limitValue.get(2);
                found = true;
                break;
            }
            if (found) continue;
            totalValue += blockCount * defaultValue;
        }
        return totalValue;
    }

    @Inject(method={"moveBlock"}, at={@At(value="HEAD")}, cancellable=true)
    protected void injectMoveBlock(Level world, Direction forcedDirection, Queue<BlockPos> frontier, Set<BlockPos> visited, CallbackInfoReturnable<Boolean> cir) throws AssemblyException {
        Direction offset;
        Object attached;
        BlockEntity blockEntity;
        BlockPos pos = frontier.poll();
        if (pos == null) {
            cir.setReturnValue((Object)false);
            return;
        }
        visited.add(pos);
        if (world.isOutsideBuildHeight(pos)) {
            cir.setReturnValue((Object)true);
            return;
        }
        if (!world.isLoaded(pos)) {
            throw AssemblyException.unloadedChunk((BlockPos)pos);
        }
        if (this.isAnchoringBlockAt(pos)) {
            cir.setReturnValue((Object)true);
            return;
        }
        BlockState state = world.getBlockState(pos);
        if (!BlockMovementChecks.isMovementNecessary((BlockState)state, (Level)world, (BlockPos)pos)) {
            cir.setReturnValue((Object)true);
            return;
        }
        if (!this.movementAllowed(state, world, pos)) {
            throw AssemblyException.unmovableBlock((BlockPos)pos, (BlockState)state);
        }
        if (state.getBlock() instanceof AbstractChassisBlock && !this.moveChassis(world, pos, forcedDirection, frontier, visited)) {
            cir.setReturnValue((Object)false);
            return;
        }
        if (AllBlocks.BELT.has(state)) {
            this.moveBelt(pos, frontier, visited, state);
        }
        if (AllBlocks.WINDMILL_BEARING.has(state) && (blockEntity = world.getBlockEntity(pos)) instanceof WindmillBearingBlockEntity) {
            WindmillBearingBlockEntity wbbe = (WindmillBearingBlockEntity)blockEntity;
            wbbe.disassembleForMovement();
        }
        if (AllBlocks.GANTRY_CARRIAGE.has(state)) {
            this.moveGantryPinion(world, pos, frontier, visited, state);
        }
        if (AllBlocks.GANTRY_SHAFT.has(state)) {
            this.moveGantryShaft(world, pos, frontier, visited, state);
        }
        if (AllBlocks.STICKER.has(state) && ((Boolean)state.getValue((Property)StickerBlock.EXTENDED)).booleanValue() && !visited.contains(attached = pos.relative(offset = (Direction)state.getValue((Property)StickerBlock.FACING))) && !BlockMovementChecks.isNotSupportive((BlockState)world.getBlockState((BlockPos)attached), (Direction)offset.getOpposite())) {
            frontier.add((BlockPos)attached);
        }
        if ((attached = world.getBlockEntity(pos)) instanceof ChainConveyorBlockEntity) {
            ChainConveyorBlockEntity ccbe = (ChainConveyorBlockEntity)attached;
            ccbe.notifyConnectedToValidate();
        }
        if (state.hasProperty((Property)ChestBlock.TYPE) && state.hasProperty((Property)ChestBlock.FACING) && state.getValue((Property)ChestBlock.TYPE) != ChestType.SINGLE && !visited.contains(attached = pos.relative(offset = ChestBlock.getConnectedDirection((BlockState)state)))) {
            frontier.add((BlockPos)attached);
        }
        if ((attached = state.getBlock()) instanceof AbstractBogeyBlock) {
            AbstractBogeyBlock bogey = (AbstractBogeyBlock)attached;
            for (Direction[] d : bogey.getStickySurfaces((BlockGetter)world, pos, state)) {
                if (visited.contains(pos.relative((Direction)d))) continue;
                frontier.add(pos.relative((Direction)d));
            }
        }
        if (AllBlocks.MECHANICAL_BEARING.has(state)) {
            this.moveBearing(pos, frontier, visited, state);
        }
        if (AllBlocks.WINDMILL_BEARING.has(state)) {
            this.moveWindmillBearing(pos, frontier, visited, state);
        }
        if (state.getBlock() instanceof SeatBlock) {
            this.moveSeat(world, pos);
        }
        if (state.getBlock() instanceof PulleyBlock) {
            this.movePulley(world, pos, frontier, visited);
        }
        if (state.getBlock() instanceof MechanicalPistonBlock && !this.moveMechanicalPiston(world, pos, frontier, visited, state)) {
            cir.setReturnValue((Object)false);
            return;
        }
        if (MechanicalPistonBlock.isExtensionPole((BlockState)state)) {
            this.movePistonPole(world, pos, frontier, visited, state);
        }
        if (MechanicalPistonBlock.isPistonHead((BlockState)state)) {
            this.movePistonHead(world, pos, frontier, visited, state);
        }
        BlockPos posDown = pos.below();
        BlockState stateBelow = world.getBlockState(posDown);
        if (!visited.contains(posDown) && AllBlocks.CART_ASSEMBLER.has(stateBelow)) {
            frontier.add(posDown);
        }
        for (Direction offset2 : Iterate.directions) {
            boolean canStick;
            BlockPos offsetPos = pos.relative(offset2);
            BlockState blockState = world.getBlockState(offsetPos);
            if (this.isAnchoringBlockAt(offsetPos)) continue;
            if (!this.movementAllowed(blockState, world, offsetPos)) {
                if (offset2 != forcedDirection) continue;
                throw AssemblyException.unmovableBlock((BlockPos)pos, (BlockState)state);
            }
            boolean wasVisited = visited.contains(offsetPos);
            boolean faceHasGlue = SuperGlueEntity.isGlued((LevelAccessor)world, (BlockPos)pos, (Direction)offset2, this.glueToRemove);
            boolean blockAttachedTowardsFace = BlockMovementChecks.isBlockAttachedTowards((BlockState)blockState, (Level)world, (BlockPos)offsetPos, (Direction)offset2.getOpposite());
            boolean brittle = BlockMovementChecks.isBrittle((BlockState)blockState);
            boolean bl = canStick = !brittle && state.canStickTo(blockState) && blockState.canStickTo(state);
            if (canStick) {
                if (state.getPistonPushReaction() == PushReaction.PUSH_ONLY || blockState.getPistonPushReaction() == PushReaction.PUSH_ONLY) {
                    canStick = false;
                }
                if (BlockMovementChecks.isNotSupportive((BlockState)state, (Direction)offset2)) {
                    canStick = false;
                }
                if (BlockMovementChecks.isNotSupportive((BlockState)blockState, (Direction)offset2.getOpposite())) {
                    canStick = false;
                }
            }
            if (wasVisited || !canStick && !blockAttachedTowardsFace && !faceHasGlue && (offset2 != forcedDirection || BlockMovementChecks.isNotSupportive((BlockState)state, (Direction)forcedDirection))) continue;
            frontier.add(offsetPos);
        }
        this.addBlock(world, pos, this.capture(world, pos));
        if (this.blocks.size() <= (Integer)AllConfigs.server().kinetics.maxBlocksMoved.get()) {
            BlockState blockState = world.getBlockState(pos);
            String blockStateString = blockState.getBlock().toString().replaceAll("Block\\{(.*?)\\}", "$1");
            if (Config.blocks_unmoved.stream().anyMatch(blockStateString::equals)) {
                EntityEnrollment.setControlStatus(8);
                throw AssemblyException.unmovableBlock((BlockPos)pos, (BlockState)state);
            }
            String blockString = blockState.toString();
            Pattern pattern = Pattern.compile("Block\\{(.*?)}");
            Matcher matcher = pattern.matcher(blockString);
            if (matcher.find()) {
                String blockName = matcher.group(1);
                this.blockCountMap_r.put(blockName, this.blockCountMap_r.getOrDefault(blockName, 0) + 1);
            }
            for (List<Object> entry : Config.blocksLimitValues) {
                String blockName = (String)entry.get(0);
                int allowedCount = (Integer)entry.get(1);
                int currentCount = this.blockCountMap_r.getOrDefault(blockName, 0);
                if (currentCount <= allowedCount) continue;
                if (Config.debug_block_entity_problem) {
                    createentitycontroller$LOGGER.info("{} count: {} allowed: {}", new Object[]{blockName, currentCount, allowedCount});
                }
                EntityEnrollment.setControlStatus(16);
                throw AssemblyException.unmovableBlock((BlockPos)pos, (BlockState)state);
            }
            if (pos.getX() < this.createentitycontroller$minPos.getX()) {
                this.createentitycontroller$minPos = new BlockPos(pos.getX(), this.createentitycontroller$minPos.getY(), this.createentitycontroller$minPos.getZ());
            }
            if (pos.getY() < this.createentitycontroller$minPos.getY()) {
                this.createentitycontroller$minPos = new BlockPos(this.createentitycontroller$minPos.getX(), pos.getY(), this.createentitycontroller$minPos.getZ());
            }
            if (pos.getZ() < this.createentitycontroller$minPos.getZ()) {
                this.createentitycontroller$minPos = new BlockPos(this.createentitycontroller$minPos.getX(), this.createentitycontroller$minPos.getY(), pos.getZ());
            }
            if (pos.getX() > this.createentitycontroller$maxPos.getX()) {
                this.createentitycontroller$maxPos = new BlockPos(pos.getX(), this.createentitycontroller$maxPos.getY(), this.createentitycontroller$maxPos.getZ());
            }
            if (pos.getY() > this.createentitycontroller$maxPos.getY()) {
                this.createentitycontroller$maxPos = new BlockPos(this.createentitycontroller$maxPos.getX(), pos.getY(), this.createentitycontroller$maxPos.getZ());
            }
            if (pos.getZ() > this.createentitycontroller$maxPos.getZ()) {
                this.createentitycontroller$maxPos = new BlockPos(this.createentitycontroller$maxPos.getX(), this.createentitycontroller$maxPos.getY(), pos.getZ());
            }
            if (this.createentitycontroller$maxPos.getX() - this.createentitycontroller$minPos.getX() > Config.blockEntityXZMaxLength) {
                EntityEnrollment.setControlStatus(32);
                throw AssemblyException.unmovableBlock((BlockPos)pos, (BlockState)state);
            }
            if (this.createentitycontroller$maxPos.getY() - this.createentitycontroller$minPos.getY() > Config.blockEntityYMaxLength) {
                EntityEnrollment.setControlStatus(32);
                throw AssemblyException.unmovableBlock((BlockPos)pos, (BlockState)state);
            }
            if (this.createentitycontroller$maxPos.getZ() - this.createentitycontroller$minPos.getZ() > Config.blockEntityXZMaxLength) {
                EntityEnrollment.setControlStatus(32);
                throw AssemblyException.unmovableBlock((BlockPos)pos, (BlockState)state);
            }
        } else {
            throw AssemblyException.structureTooLarge();
        }
        cir.cancel();
        cir.setReturnValue((Object)true);
    }

    @Inject(method={"addBlocksToWorld"}, at={@At(value="HEAD")}, cancellable=true)
    public void injectAddBlocksToWorld(Level world, StructureTransform transform, CallbackInfo ci) {
        if (Config.keep_structure_at_first) {
            StructureBlockStorage.removeOldEntries(1000L * (long)Config.keep_structure_refresh_time);
            if (StructureFunc.StructureMatch(this.blocks, transform)) {
                if (Config.debug_block_entity_problem) {
                    createentitycontroller$LOGGER.warn("same structure jump control");
                }
            } else {
                StructureBlockStorage.storeData(StructureBlockStorage.generateRandomUUID(), this.blocks);
                return;
            }
        }
        int calculate = 0;
        for (StructureTemplate.StructureBlockInfo block : this.blocks.values()) {
            String blockString = block.state().getBlock().toString();
            if (Config.blocks_ignore.stream().anyMatch(blockString::contains)) {
                ++calculate;
                continue;
            }
            if (!Config.debug_block_entity_problem) continue;
            createentitycontroller$LOGGER.warn("entity has not ignore block\uff1a{}", (Object)blockString);
        }
        if (calculate == this.blocks.size()) {
            return;
        }
        if (this.disassembled) {
            ci.cancel();
            return;
        }
        this.disassembled = true;
        this.translateMultiblockControllers(transform);
        for (Object nonBrittles : (Iterator<StructureTemplate.StructureBlockInfo>)Iterate.trueAndFalse) {
            for (StructureTemplate.StructureBlockInfo block : this.blocks.values()) {
                boolean squeezeBlock;
                BlockPos targetPos = transform.apply(block.pos());
                BlockState state = transform.apply(block.state());
                BlockState blockState = world.getBlockState(targetPos);
                String blockStateString = blockState.getBlock().toString().replaceAll("Block\\{(.*?)\\}", "$1");
                boolean isInWhitelist = Config.blocks_uncrushable.stream().anyMatch(blockStateString::equals);
                boolean isInDropList = Config.blocks_uncrushableIgnore.stream().anyMatch(blockStateString::equals);
                if (nonBrittles == BlockMovementChecks.isBrittle((BlockState)block.state()) || this.customBlockPlacement((LevelAccessor)world, targetPos, state)) continue;
                if (nonBrittles != false) {
                    for (Direction face : Iterate.directions) {
                        state = state.updateShape(face, world.getBlockState(targetPos.relative(face)), (LevelAccessor)world, targetPos, targetPos.relative(face));
                    }
                }
                if (isInWhitelist) {
                    squeezeBlock = true;
                } else if (isInDropList) {
                    squeezeBlock = false;
                } else {
                    boolean bl = squeezeBlock = blockState.getDestroySpeed((BlockGetter)world, targetPos) > Config.squeeze_destroy_speed;
                }
                if (blockState.getDestroySpeed((BlockGetter)world, targetPos) == -1.0f || squeezeBlock || state.getCollisionShape((BlockGetter)world, targetPos).isEmpty() && !blockState.getCollisionShape((BlockGetter)world, targetPos).isEmpty()) {
                    if (targetPos.getY() == world.getMinBuildHeight()) {
                        targetPos = targetPos.above();
                    }
                    world.levelEvent(2001, targetPos, Block.getId((BlockState)state));
                    Block.dropResources((BlockState)state, (LevelAccessor)world, (BlockPos)targetPos, null);
                    continue;
                }
                if (state.getBlock() instanceof SimpleWaterloggedBlock && state.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
                    FluidState fluidState = world.getFluidState(targetPos);
                    state = (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
                }
                world.destroyBlock(targetPos, true);
                if (AllBlocks.SHAFT.has(state)) {
                    state = ShaftBlock.pickCorrectShaftType((BlockState)state, (Level)world, (BlockPos)targetPos);
                }
                if (state.hasProperty((Property)SlidingDoorBlock.VISIBLE)) {
                    state = (BlockState)((BlockState)state.setValue((Property)SlidingDoorBlock.VISIBLE, (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)SlidingDoorBlock.OPEN) == false))).setValue((Property)SlidingDoorBlock.POWERED, (Comparable)Boolean.valueOf(false));
                }
                if (state.is(Blocks.SCULK_SHRIEKER)) {
                    state = Blocks.SCULK_SHRIEKER.defaultBlockState();
                }
                world.setBlock(targetPos, state, 67);
                boolean verticalRotation = transform.rotationAxis == null || transform.rotationAxis.isHorizontal();
                boolean bl = verticalRotation = verticalRotation && transform.rotation != Rotation.NONE;
                if (verticalRotation && (state.getBlock() instanceof PulleyBlock.RopeBlock || state.getBlock() instanceof PulleyBlock.MagnetBlock || state.getBlock() instanceof DoorBlock)) {
                    world.destroyBlock(targetPos, true);
                }
                BlockEntity blockEntity = world.getBlockEntity(targetPos);
                CompoundTag tag = block.nbt();
                if (state.is(Blocks.SCULK_SENSOR) || state.is(Blocks.SCULK_SHRIEKER)) {
                    tag = null;
                }
                if (blockEntity != null && (tag = NBTProcessors.process((BlockState)state, (BlockEntity)blockEntity, (CompoundTag)tag, (boolean)false)) != null) {
                    tag.putInt("x", targetPos.getX());
                    tag.putInt("y", targetPos.getY());
                    tag.putInt("z", targetPos.getZ());
                    if (verticalRotation && blockEntity instanceof PulleyBlockEntity) {
                        tag.remove("Offset");
                        tag.remove("InitialOffset");
                    }
                    if (blockEntity instanceof IMultiBlockEntityContainer && (tag.contains("LastKnownPos") || this.capturedMultiblocks.isEmpty())) {
                        tag.put("LastKnownPos", NbtUtils.writeBlockPos((BlockPos)BlockPos.ZERO.below(0x7FFFFFFE)));
                        tag.remove("Controller");
                    }
                    blockEntity.loadWithComponents(tag, (HolderLookup.Provider)world.registryAccess());
                }
                this.storage.unmount(world, block, targetPos, blockEntity);
                if (blockEntity == null) continue;
                transform.apply(blockEntity);
            }
        }
        for (StructureTemplate.StructureBlockInfo block : this.blocks.values()) {
            if (!this.shouldUpdateAfterMovement(block)) continue;
            BlockPos targetPos = transform.apply(block.pos());
            world.markAndNotifyBlock(targetPos, world.getChunkAt(targetPos), block.state(), block.state(), 67, 512);
        }
        for (AABB box : this.superglue) {
            box = new AABB(transform.apply(new Vec3(box.minX, box.minY, box.minZ)), transform.apply(new Vec3(box.maxX, box.maxY, box.maxZ)));
            if (world.isClientSide) continue;
            world.addFreshEntity((Entity)new SuperGlueEntity(world, box));
        }
        ci.cancel();
    }
}

