/*
 * Decompiled with CFR 0.152.
 */
package pl.epsi.settings;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import pl.epsi.OldPistonSounds;
import pl.epsi.settings.OldPistonSettings;

public class FileLoader {
    private final Gson gson;
    private final OldPistonSettings settings = OldPistonSettings.getInstance();

    public FileLoader() {
        this.gson = new GsonBuilder().setPrettyPrinting().create();
    }

    public void load() {
        try (FileReader reader = new FileReader("old_pistons.json", StandardCharsets.UTF_8);){
            ModData loaded = (ModData)this.gson.fromJson((Reader)reader, ModData.class);
            this.settings.cutoffPistons = loaded.settings.cutoffPistons;
            this.settings.modifyPistonPitch = loaded.settings.modifyPistonPitch;
            this.settings.cutoffSmoothLastPiston = loaded.settings.cutoffSmoothLastPiston;
            this.settings.pistonSoundThreshold = loaded.settings.pistonSoundThreshold;
            this.settings.cutoffTime = loaded.settings.cutoffTime;
            this.settings.profile = loaded.settings.profile;
            if (this.settings.profile.equalsIgnoreCase("default")) {
                this.settings.setToDefault();
            }
        }
        catch (IOException e) {
            OldPistonSounds.LOGGER.warn("Old Pistons save file not found!");
        }
        catch (JsonIOException e) {
            OldPistonSounds.LOGGER.warn("Json Error while loading Old Pistons save file", (Throwable)e);
        }
    }

    public void save() {
        ModData data = new ModData(OldPistonSettings.getInstance());
        try (FileWriter writer = new FileWriter("old_pistons.json", StandardCharsets.UTF_8);){
            this.gson.toJson((Object)data, (Appendable)writer);
            writer.close();
        }
        catch (IOException e) {
            OldPistonSounds.LOGGER.error("Failed to save!", (Throwable)e);
        }
    }

    public record ModData(OldPistonSettings settings) {
    }
}

