/*
 * Decompiled with CFR 0.152.
 */
package pl.epsi;

import java.util.ArrayList;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import pl.epsi.settings.OldPistonSettings;

public class PistonCutoffManager {
    private static PistonCutoffManager instance;
    private final OldPistonSettings settings = OldPistonSettings.getInstance();
    private final ArrayList<PistonSoundEvent> overloadedTicks = new ArrayList();
    private final ArrayList<PistonSoundEvent> tempSoundEvents = new ArrayList();
    private final ArrayList<PistonSoundEvent> tempRemove = new ArrayList();
    private class_310 client = class_310.method_1551();
    private int pistonsFiredInGameTick = 0;
    private int ticksSinceLastPiston = 10;

    private PistonCutoffManager() {
    }

    public static PistonCutoffManager getInstance() {
        if (instance == null) {
            instance = new PistonCutoffManager();
        }
        return instance;
    }

    public void increasePistonsFired() {
        ++this.pistonsFiredInGameTick;
    }

    public void resetTicksSinceLastPiston() {
        this.ticksSinceLastPiston = 0;
    }

    public void tick() {
        int i;
        if (this.client == null) {
            this.client = class_310.method_1551();
        }
        int pistonSoundThreshold = this.settings.pistonSoundThreshold * 2;
        int cutoffTime = this.settings.cutoffTime;
        if (this.pistonsFiredInGameTick > pistonSoundThreshold) {
            this.overloadedTicks.addAll(this.tempSoundEvents);
        }
        for (i = 0; i < this.overloadedTicks.size(); ++i) {
            PistonSoundEvent pistonEvent = this.overloadedTicks.get(i);
            if (pistonEvent == null) continue;
            if (pistonEvent.ticksSince >= cutoffTime && this.ticksSinceLastPiston < 3 && this.settings.cutoffPistons) {
                pistonEvent.cancelSound();
            }
            if (this.ticksSinceLastPiston != 3 || this.client == null || this.client.field_1724 == null || this.client.field_1724.method_37908() == null || !this.settings.cutoffPistons) continue;
            if (this.settings.cutoffSmoothLastPiston) {
                pistonEvent.playSound(this.client.field_1724.method_37908(), (class_1657)this.client.field_1724);
            }
            this.tempRemove.add(pistonEvent);
        }
        for (i = 0; i < this.tempRemove.size(); ++i) {
            this.overloadedTicks.remove(this.tempRemove.get(i));
        }
        this.overloadedTicks.forEach(a -> {
            if (a != null) {
                a.increment();
            }
        });
        this.tempSoundEvents.clear();
        this.tempRemove.clear();
        this.pistonsFiredInGameTick = 0;
        ++this.ticksSinceLastPiston;
    }

    public void addPistonSoundEvent(PistonSoundEvent e) {
        this.tempSoundEvents.add(e);
    }

    public static class PistonSoundEvent {
        private final class_2338 pos;
        private final class_1113 soundInstance;
        private int ticksSince;

        public PistonSoundEvent(class_2338 pos, class_1113 soundInstance) {
            this.pos = pos;
            this.ticksSince = 0;
            this.soundInstance = soundInstance;
        }

        public void increment() {
            ++this.ticksSince;
        }

        public class_1113 getSound() {
            return this.soundInstance;
        }

        public void playSound(class_1937 w, class_1657 player) {
            w.method_8396((class_1297)player, this.pos, class_3417.field_15228, class_3419.field_15245, 0.45f, 0.535f + w.field_9229.method_43057() * 0.2f);
        }

        public void cancelSound() {
            class_310.method_1551().method_1483().method_4870(this.soundInstance);
        }
    }
}

