/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.armoredElytra;

import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nl.pim16aap2.armoredElytra.handlers.AbstractSmithingTableListener;
import nl.pim16aap2.armoredElytra.handlers.AnvilHandler;
import nl.pim16aap2.armoredElytra.handlers.CommandHandler;
import nl.pim16aap2.armoredElytra.handlers.DroppedNetheriteUpdateListener;
import nl.pim16aap2.armoredElytra.handlers.EventHandlers;
import nl.pim16aap2.armoredElytra.handlers.FlyDurabilityHandler;
import nl.pim16aap2.armoredElytra.handlers.Uninstaller;
import nl.pim16aap2.armoredElytra.lib.bstats.bukkit.Metrics;
import nl.pim16aap2.armoredElytra.lib.semver4j.Semver;
import nl.pim16aap2.armoredElytra.nbtEditor.DurabilityManager;
import nl.pim16aap2.armoredElytra.nbtEditor.NBTEditor;
import nl.pim16aap2.armoredElytra.util.ArmorTier;
import nl.pim16aap2.armoredElytra.util.ArmorTierName;
import nl.pim16aap2.armoredElytra.util.ConfigLoader;
import nl.pim16aap2.armoredElytra.util.UpdateManager;
import nl.pim16aap2.armoredElytra.util.messages.Message;
import nl.pim16aap2.armoredElytra.util.messages.Messages;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ArmoredElytra
extends JavaPlugin
implements Listener {
    public static final Semver SERVER_VERSION = Objects.requireNonNull(Semver.coerce(Bukkit.getServer().getBukkitVersion())).withClearedPreReleaseAndBuild();
    private static ArmoredElytra INSTANCE;
    private Messages messages;
    private ConfigLoader config;
    private final Map<ArmorTier, ArmorTierName> armorTierNames = new EnumMap<ArmorTier, ArmorTierName>(ArmorTier.class);
    private UpdateManager updateManager;
    private NBTEditor nbtEditor;

    public ArmoredElytra() {
        INSTANCE = this;
    }

    public void onEnable() {
        if (SERVER_VERSION.isLowerThan(Semver.of(1, 16, 0))) {
            this.myLogger(Level.SEVERE, "Trying to run this plugin on an unsupported version... ABORT!");
            this.setEnabled(false);
            return;
        }
        this.nbtEditor = new NBTEditor();
        this.config = new ConfigLoader(this);
        DurabilityManager durabilityManager = new DurabilityManager(this.nbtEditor, this.config);
        this.messages = new Messages(this);
        this.readMessages();
        this.updateManager = new UpdateManager(this, 47136);
        this.updateManager.setEnabled(this.config.checkForUpdates());
        if (this.config.allowStats()) {
            this.myLogger(Level.INFO, "Enabling stats! Thanks, it really helps!");
            Metrics metrics = new Metrics(this, 1656);
        } else {
            this.myLogger(Level.INFO, "Stats disabled, not loading stats :(... Please consider enabling it! I am a simple man, seeing higher user numbers helps me stay motivated!");
        }
        Bukkit.getPluginManager().registerEvents((Listener)new EventHandlers(this, this.nbtEditor, durabilityManager), (Plugin)this);
        Objects.requireNonNull(this.getCommand("ArmoredElytra"), "ArmoredElytra base command not found!").setExecutor((CommandExecutor)new CommandHandler(this, this.nbtEditor, durabilityManager));
        if (!this.config.uninstallMode()) {
            Bukkit.getPluginManager().registerEvents((Listener)new FlyDurabilityHandler(this.config.noFlightDurability(), this.nbtEditor, durabilityManager), (Plugin)this);
            Bukkit.getPluginManager().registerEvents((Listener)AbstractSmithingTableListener.create(SERVER_VERSION, this, this.nbtEditor, durabilityManager, this.config), (Plugin)this);
            Bukkit.getPluginManager().registerEvents((Listener)new AnvilHandler(this, this.nbtEditor, durabilityManager, this.config), (Plugin)this);
            if (NBTEditor.HAS_FIRE_RESISTANT_METHOD) {
                Bukkit.getPluginManager().registerEvents((Listener)new DroppedNetheriteUpdateListener(this.nbtEditor), (Plugin)this);
            }
            this.myLogger(Level.INFO, "Allowed enchantments:");
            for (Enchantment enchantment : this.config.allowedEnchantments()) {
                this.myLogger(Level.INFO, " - " + String.valueOf(enchantment.getKey()));
            }
        } else {
            this.myLogger(Level.WARNING, "Plugin in uninstall mode!");
            Bukkit.getPluginManager().registerEvents((Listener)new Uninstaller(this, this.nbtEditor), (Plugin)this);
        }
    }

    public Messages getMyMessages() {
        return this.messages;
    }

    public NBTEditor getNbtEditor() {
        return this.nbtEditor;
    }

    private ArmorTierName getArmorTierName(Message longName, Message shortName) {
        return new ArmorTierName(this.messages.getString(longName, new String[0]), this.messages.getString(shortName, new String[0]));
    }

    private void readMessages(ArmorTier armorTier) {
        ArmorTierName armorTierName = switch (armorTier) {
            default -> throw new IncompatibleClassChangeError();
            case ArmorTier.NONE -> new ArmorTierName("NONE", "NONE");
            case ArmorTier.LEATHER -> this.getArmorTierName(Message.TIER_LEATHER, Message.TIER_SHORT_LEATHER);
            case ArmorTier.GOLD -> this.getArmorTierName(Message.TIER_GOLD, Message.TIER_SHORT_GOLD);
            case ArmorTier.CHAIN -> this.getArmorTierName(Message.TIER_CHAIN, Message.TIER_SHORT_CHAIN);
            case ArmorTier.IRON -> this.getArmorTierName(Message.TIER_IRON, Message.TIER_SHORT_IRON);
            case ArmorTier.DIAMOND -> this.getArmorTierName(Message.TIER_DIAMOND, Message.TIER_SHORT_DIAMOND);
            case ArmorTier.NETHERITE -> this.getArmorTierName(Message.TIER_NETHERITE, Message.TIER_SHORT_NETHERITE);
            case ArmorTier.COPPER -> this.getArmorTierName(Message.TIER_COPPER, Message.TIER_SHORT_COPPER);
        };
        this.armorTierNames.put(armorTier, armorTierName);
    }

    private void readMessages() {
        ArmorTier.VALUES.forEach(this::readMessages);
    }

    public boolean playerHasCraftPerm(@Nonnull HumanEntity player, ArmorTier armorTier) {
        return this.getConfigLoader().bypassCraftPerm() || player.hasPermission("armoredelytra.craft." + ArmorTier.getName(armorTier));
    }

    public boolean playerHasWearPerm(@Nonnull HumanEntity player, ArmorTier armorTier) {
        return this.getConfigLoader().bypassWearPerm() || player.hasPermission("armoredelytra.wear." + ArmorTier.getName(armorTier));
    }

    public ConfigLoader getConfigLoader() {
        return this.config;
    }

    public void messagePlayer(HumanEntity player, ChatColor color, String str) {
        player.sendMessage(String.valueOf(color) + str);
    }

    public void messagePlayer(HumanEntity player, String str) {
        this.messagePlayer(player, ChatColor.WHITE, str);
    }

    private String getMessageWithTierNames(Message message, ArmorTier armorTier) {
        ArmorTierName tierName = this.armorTierNames.get((Object)armorTier);
        return this.getMyMessages().getString(message, tierName.longName(), tierName.shortName());
    }

    public void usageDeniedMessage(HumanEntity player, ArmorTier armorTier) {
        String message = this.getMessageWithTierNames(Message.MESSAGES_USAGEDENIED, armorTier);
        if (!message.equals("NONE")) {
            this.messagePlayer(player, message);
        }
    }

    public void elytraReceivedMessage(HumanEntity player, ArmorTier armorTier) {
        String message = this.getMessageWithTierNames(Message.MESSAGES_ELYTRARECEIVED, armorTier);
        if (!message.equals("NONE")) {
            this.messagePlayer(player, message);
        }
    }

    public void sendNoGivePermissionMessage(HumanEntity player, ArmorTier armorTier) {
        String message = this.getMessageWithTierNames(Message.MESSAGES_NOGIVEPERMISSION, armorTier);
        this.messagePlayer(player, message);
    }

    @Nullable
    public List<String> getElytraLore(ArmorTier armorTier) {
        String message = this.getMessageWithTierNames(Message.MESSAGES_LORE, armorTier);
        return message.equals("NONE") ? null : Collections.singletonList(message);
    }

    public void myLogger(Level level, String str) {
        Bukkit.getLogger().log(level, "[" + this.getName() + "] " + str);
    }

    public void debugMsg(Level level, String str) {
        if (this.config.enableDebug()) {
            this.myLogger(level, str);
        }
    }

    public void giveArmoredElytraToPlayer(HumanEntity player, ItemStack item) {
        if (item != null) {
            player.getInventory().addItem(new ItemStack[]{item});
        }
    }

    public UpdateManager getUpdateManager() {
        return this.updateManager;
    }

    public static ArmoredElytra getInstance() {
        return INSTANCE;
    }

    public String getArmoredElytraName(ArmorTier tier) {
        if (tier == null) {
            this.getLogger().log(Level.INFO, "ArmorTier was null! Failed to obtain proper string!");
            return "NULL";
        }
        return this.armorTierNames.get((Object)tier).longName();
    }
}

