/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.armoredElytra.handlers;

import java.util.logging.Level;
import javax.annotation.Nullable;
import nl.pim16aap2.armoredElytra.ArmoredElytra;
import nl.pim16aap2.armoredElytra.handlers.ArmoredElytraHandler;
import nl.pim16aap2.armoredElytra.handlers.SmithingTableManualListener;
import nl.pim16aap2.armoredElytra.handlers.SmithingTableRecipeListener;
import nl.pim16aap2.armoredElytra.lib.semver4j.Semver;
import nl.pim16aap2.armoredElytra.nbtEditor.DurabilityManager;
import nl.pim16aap2.armoredElytra.nbtEditor.NBTEditor;
import nl.pim16aap2.armoredElytra.util.ArmorTier;
import nl.pim16aap2.armoredElytra.util.ConfigLoader;
import nl.pim16aap2.armoredElytra.util.SmithingTableUtil;
import nl.pim16aap2.armoredElytra.util.itemInput.ElytraInput;
import nl.pim16aap2.armoredElytra.util.itemInput.InputAction;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.PrepareSmithingEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.SmithingInventory;

public abstract class AbstractSmithingTableListener
extends ArmoredElytraHandler
implements Listener {
    protected AbstractSmithingTableListener(ArmoredElytra plugin, NBTEditor nbtEditor, DurabilityManager durabilityManager, ConfigLoader config) {
        super(plugin, nbtEditor, durabilityManager, config);
    }

    public static AbstractSmithingTableListener create(Semver serverVersion, ArmoredElytra plugin, NBTEditor nbtEditor, DurabilityManager durabilityManager, ConfigLoader config) {
        if (serverVersion.isGreaterThanOrEqualTo(Semver.of(1, 21, 1))) {
            return new SmithingTableRecipeListener(plugin, nbtEditor, durabilityManager, config);
        }
        return new SmithingTableManualListener(plugin, nbtEditor, durabilityManager, config);
    }

    protected ElytraInput onSmithingTableUsage0(PrepareSmithingEvent event) {
        SmithingInventory inventory = event.getInventory();
        ElytraInput input = ElytraInput.fromInventory(this.config, inventory);
        if (input.isIgnored()) {
            return input;
        }
        event.setResult(this.armoredElytraBuilder.handleInput(event.getView().getPlayer(), input));
        return input;
    }

    protected final void onSmithingInventoryResultClick(InventoryClickEvent event, Player player, SmithingInventory smithingInventory) {
        if (event.getSlot() != SmithingTableUtil.SMITHING_TABLE_RESULT_SLOT) {
            throw new IllegalArgumentException("Clicked slot must be '" + SmithingTableUtil.SMITHING_TABLE_RESULT_SLOT + "' but received '" + event.getSlot() + "'");
        }
        if (smithingInventory.getItem(SmithingTableUtil.SMITHING_TABLE_INPUT_SLOT_1) == null || smithingInventory.getItem(SmithingTableUtil.SMITHING_TABLE_INPUT_SLOT_2) == null || smithingInventory.getItem(SmithingTableUtil.SMITHING_TABLE_RESULT_SLOT) == null) {
            return;
        }
        ItemStack result = smithingInventory.getItem(SmithingTableUtil.SMITHING_TABLE_RESULT_SLOT);
        if (result == null) {
            return;
        }
        ElytraInput input = ElytraInput.fromInventory(this.config, smithingInventory);
        if (input.isIgnored()) {
            return;
        }
        if (this.nbtEditor.getArmorTierFromElytra(result) == ArmorTier.NONE) {
            this.plugin.myLogger(Level.SEVERE, "Smithing Table: Attempted to retrieve an item that is not an armored elytra! Result: " + String.valueOf(result) + ", input: " + String.valueOf(input));
            return;
        }
        event.setCancelled(true);
        if (this.isRecipeResultPlaceholder(result)) {
            this.plugin.myLogger(Level.SEVERE, "Smithing Table: Attempted to retrieve a placeholder result! Result: " + String.valueOf(result) + ", input: " + String.valueOf(input));
            return;
        }
        if (input.isBlocked()) {
            this.plugin.myLogger(Level.SEVERE, "Smithing Table: Attempted to retrieve an item from a blocked recipe! Input: " + String.valueOf(input));
            return;
        }
        if (!this.giveItemToPlayer(player, result, event.isShiftClick())) {
            return;
        }
        this.useItem(smithingInventory, SmithingTableUtil.SMITHING_TABLE_RESULT_SLOT);
        this.useItem(smithingInventory, SmithingTableUtil.SMITHING_TABLE_INPUT_SLOT_1);
        this.useItem(smithingInventory, SmithingTableUtil.SMITHING_TABLE_INPUT_SLOT_2);
        if (SmithingTableUtil.SMITHING_TABLE_HAS_TEMPLATE_SLOT && input.inputAction() == InputAction.UPGRADE) {
            this.useItem(smithingInventory, SmithingTableUtil.SMITHING_TABLE_TEMPLATE_SLOT);
        }
    }

    protected boolean isRecipeResultPlaceholder(@Nullable ItemStack result) {
        return false;
    }

    protected void useItem(SmithingInventory smithingInventory, int slot) {
        ItemStack item = smithingInventory.getItem(slot);
        if (item == null) {
            return;
        }
        item.setAmount(item.getAmount() - 1);
        if (item.getAmount() == 0) {
            smithingInventory.setItem(slot, null);
        }
        smithingInventory.setItem(slot, item);
    }
}

