/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.armoredElytra.handlers;

import java.util.logging.Level;
import javax.annotation.Nonnull;
import nl.pim16aap2.armoredElytra.ArmoredElytra;
import nl.pim16aap2.armoredElytra.nbtEditor.ArmoredElytraBuilder;
import nl.pim16aap2.armoredElytra.nbtEditor.DurabilityManager;
import nl.pim16aap2.armoredElytra.nbtEditor.NBTEditor;
import nl.pim16aap2.armoredElytra.util.ArmorTier;
import nl.pim16aap2.armoredElytra.util.messages.Message;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Registry;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;

public class CommandHandler
implements CommandExecutor {
    private final ArmoredElytra plugin;
    private final ArmoredElytraBuilder armoredElytraBuilder;

    public CommandHandler(ArmoredElytra plugin, NBTEditor nbtEditor, DurabilityManager durabilityManager) {
        this.plugin = plugin;
        this.armoredElytraBuilder = new ArmoredElytraBuilder(nbtEditor, durabilityManager, plugin.getConfigLoader(), plugin);
    }

    public boolean onCommand(@Nonnull CommandSender sender, @Nonnull Command cmd, @Nonnull String label, @Nonnull String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (this.plugin.getConfigLoader().uninstallMode()) {
                this.plugin.messagePlayer((HumanEntity)player, this.plugin.getMyMessages().getString(Message.MESSAGES_UNINSTALLMODE, new String[0]));
                return true;
            }
            if (cmd.getName().equalsIgnoreCase("ArmoredElytra") && (args.length == 1 || args.length == 2)) {
                Player receiver;
                Object newElytra = null;
                String tier = null;
                boolean allowed = false;
                if (args.length == 1) {
                    receiver = player;
                    tier = args[0];
                } else {
                    receiver = Bukkit.getPlayer((String)args[0]);
                    if (receiver == null) {
                        this.plugin.messagePlayer((HumanEntity)player, ChatColor.RED, "Player \"" + args[0] + "\" not found!");
                        return true;
                    }
                    tier = args[1];
                }
                ArmorTier armorTier = ArmorTier.valueOfName(tier.toLowerCase());
                if (armorTier == null) {
                    this.plugin.messagePlayer((HumanEntity)player, this.plugin.getMyMessages().getString(Message.MESSAGES_UNSUPPORTEDTIER, new String[0]));
                    return false;
                }
                allowed = player.hasPermission("armoredelytra.give." + ArmorTier.getName(armorTier));
                if (allowed) {
                    this.plugin.elytraReceivedMessage((HumanEntity)receiver, armorTier);
                    this.plugin.giveArmoredElytraToPlayer((HumanEntity)receiver, this.armoredElytraBuilder.newArmoredElytra((HumanEntity)player, armorTier));
                } else {
                    this.plugin.sendNoGivePermissionMessage((HumanEntity)player, armorTier);
                }
                return true;
            }
        } else {
            if (this.plugin.getConfigLoader().uninstallMode()) {
                this.plugin.myLogger(Level.INFO, "Plugin in uninstall mode! New Armored Elytras are not allowed!");
                return true;
            }
            if (args.length == 1 && (args[0].equalsIgnoreCase("listAvailableEnchantments") || args[0].equalsIgnoreCase("listEnchantments") || args[0].equalsIgnoreCase("enchantments"))) {
                this.listAvailableEnchantments();
                return true;
            }
            if (args.length == 2) {
                String tier = args[1];
                Player player = Bukkit.getPlayer((String)args[0]);
                if (player != null) {
                    ArmorTier armorTier = ArmorTier.valueOfName(tier.toLowerCase());
                    if (armorTier == null) {
                        return false;
                    }
                    this.plugin.elytraReceivedMessage((HumanEntity)player, armorTier);
                    this.plugin.giveArmoredElytraToPlayer((HumanEntity)player, this.armoredElytraBuilder.newArmoredElytra(null, armorTier));
                    this.plugin.myLogger(Level.INFO, "Giving an armored elytra of the " + ArmorTier.getArmor(armorTier) + " armor tier to player " + player.getName());
                    return true;
                }
                this.plugin.myLogger(Level.INFO, "Player " + args[1] + " not found!");
                return true;
            }
        }
        return false;
    }

    private void listAvailableEnchantments() {
        StringBuilder sb = new StringBuilder("\nAvailable enchantments: \n");
        Registry.ENCHANTMENT.forEach(enchantment -> sb.append("  - ").append(enchantment.getKey()).append("\n"));
        this.plugin.getLogger().info(sb.toString());
    }
}

