/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.armoredElytra.handlers;

import nl.pim16aap2.armoredElytra.nbtEditor.DurabilityManager;
import nl.pim16aap2.armoredElytra.nbtEditor.NBTEditor;
import nl.pim16aap2.armoredElytra.util.ArmorTier;
import nl.pim16aap2.armoredElytra.util.Util;
import org.bukkit.Material;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemDamageEvent;

public class FlyDurabilityHandler
implements Listener {
    private final boolean disableDurability;
    private final NBTEditor nbtEditor;
    private final DurabilityManager durabilityManager;

    public FlyDurabilityHandler(boolean disableDurability, NBTEditor nbtEditor, DurabilityManager durabilityManager) {
        this.disableDurability = disableDurability;
        this.nbtEditor = nbtEditor;
        this.durabilityManager = durabilityManager;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onItemDamage(PlayerItemDamageEvent e) {
        if (e.getItem().getType() != Material.ELYTRA) {
            return;
        }
        if (!e.getPlayer().isGliding()) {
            return;
        }
        ArmorTier armorTier = this.nbtEditor.getArmorTierFromElytra(e.getItem());
        if (armorTier == ArmorTier.NONE) {
            return;
        }
        e.setCancelled(true);
        if (this.disableDurability) {
            return;
        }
        int newDurability = this.durabilityManager.removeDurability(e.getItem(), e.getDamage(), armorTier);
        if (this.durabilityManager.isBroken(newDurability, armorTier)) {
            Util.moveChestplateToInventory(e.getPlayer());
        }
    }
}

