/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.armoredElytra.handlers;

import javax.annotation.Nullable;
import nl.pim16aap2.armoredElytra.ArmoredElytra;
import nl.pim16aap2.armoredElytra.handlers.AbstractSmithingTableListener;
import nl.pim16aap2.armoredElytra.lib.semver4j.Semver;
import nl.pim16aap2.armoredElytra.nbtEditor.DurabilityManager;
import nl.pim16aap2.armoredElytra.nbtEditor.NBTEditor;
import nl.pim16aap2.armoredElytra.util.ArmorTier;
import nl.pim16aap2.armoredElytra.util.ConfigLoader;
import nl.pim16aap2.armoredElytra.util.SmithingTableUtil;
import nl.pim16aap2.armoredElytra.util.Util;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.PrepareSmithingEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.SmithingInventory;

class SmithingTableManualListener
extends AbstractSmithingTableListener
implements Listener {
    private static final boolean NEEDS_INV_UPDATE = ArmoredElytra.SERVER_VERSION.isLowerThan(Semver.of(1, 17, 0));

    SmithingTableManualListener(ArmoredElytra plugin, NBTEditor nbtEditor, DurabilityManager durabilityManager, ConfigLoader config) {
        super(plugin, nbtEditor, durabilityManager, config);
    }

    @EventHandler(ignoreCancelled=true)
    public void onSmithingTableUsage(PrepareSmithingEvent event) {
        this.onSmithingTableUsage0(event);
        if (NEEDS_INV_UPDATE) {
            event.getViewers().stream().filter(Player.class::isInstance).map(Player.class::cast).forEach(Player::updateInventory);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOW)
    public void onInventoryClick(InventoryClickEvent event) {
        Player player = Util.humanEntityToPlayer(event.getWhoClicked());
        Inventory inventory = player.getOpenInventory().getTopInventory();
        if (!(inventory instanceof SmithingInventory)) {
            return;
        }
        SmithingInventory smithingInventory = (SmithingInventory)inventory;
        if (event.getClickedInventory() instanceof PlayerInventory) {
            this.onPlayerInventoryClick(event, smithingInventory);
        } else {
            Inventory inventory2 = event.getClickedInventory();
            if (inventory2 instanceof SmithingInventory) {
                SmithingInventory clickedSmithingInventory = (SmithingInventory)inventory2;
                this.onSmithingInventoryClick(event, player, clickedSmithingInventory);
            }
        }
    }

    protected void insertElytraToSmithingTable(SmithingInventory smithingInventory, InventoryClickEvent event, @Nullable Integer clickedSlot) {
        int targetSlot;
        ItemStack source;
        ItemStack cursor = event.getCursor();
        ItemStack current = event.getCurrentItem();
        ItemStack itemStack = source = event.isShiftClick() ? current : cursor;
        if (source == null || source.getType() != Material.ELYTRA) {
            return;
        }
        ItemStack itemA = smithingInventory.getItem(SmithingTableUtil.SMITHING_TABLE_INPUT_SLOT_1);
        ItemStack itemB = smithingInventory.getItem(SmithingTableUtil.SMITHING_TABLE_INPUT_SLOT_2);
        if (itemA != null && itemB != null) {
            return;
        }
        ArmorTier armorTier = this.nbtEditor.getArmorTierFromElytra(source);
        if (armorTier == ArmorTier.NONE) {
            if (!this.config.allowCraftingInSmithingTable()) {
                return;
            }
            targetSlot = SmithingTableUtil.SMITHING_TABLE_INPUT_SLOT_2;
        } else {
            targetSlot = SmithingTableUtil.SMITHING_TABLE_INPUT_SLOT_1;
        }
        if (clickedSlot != null && clickedSlot != targetSlot) {
            return;
        }
        if (event.isShiftClick() && smithingInventory.getItem(targetSlot) != null) {
            return;
        }
        ItemStack insertedItem = source.clone();
        insertedItem.setAmount(1);
        ItemStack swapItem = current;
        smithingInventory.setItem(targetSlot, insertedItem);
        source.setAmount(source.getAmount() - 1);
        event.getWhoClicked().setItemOnCursor(swapItem);
        event.setCancelled(true);
    }

    protected void onPlayerInventoryClick(InventoryClickEvent event, SmithingInventory smithingInventory) {
        if (!event.isShiftClick()) {
            return;
        }
        this.insertElytraToSmithingTable(smithingInventory, event, null);
    }

    protected void onSmithingInventoryClick(InventoryClickEvent event, Player player, SmithingInventory smithingInventory) {
        if (event.getSlot() == SmithingTableUtil.SMITHING_TABLE_RESULT_SLOT) {
            this.onSmithingInventoryResultClick(event, player, smithingInventory);
        } else if (event.getSlot() == SmithingTableUtil.SMITHING_TABLE_INPUT_SLOT_2 || event.getSlot() == SmithingTableUtil.SMITHING_TABLE_INPUT_SLOT_1) {
            this.insertElytraToSmithingTable(smithingInventory, event, event.getSlot());
        }
    }
}

