/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.armoredElytra.handlers;

import nl.pim16aap2.armoredElytra.ArmoredElytra;
import nl.pim16aap2.armoredElytra.nbtEditor.NBTEditor;
import nl.pim16aap2.armoredElytra.util.ArmorTier;
import org.bukkit.ChatColor;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Uninstaller
implements Listener {
    private final ArmoredElytra plugin;
    private final NBTEditor nbtEditor;

    public Uninstaller(ArmoredElytra plugin, NBTEditor nbtEditor) {
        this.plugin = plugin;
        this.nbtEditor = nbtEditor;
    }

    public int removeArmoredElytras(Inventory inv) {
        int count = 0;
        for (ItemStack is : inv) {
            if (this.nbtEditor.getArmorTierFromElytra(is) == ArmorTier.NONE) continue;
            inv.remove(is);
            ++count;
        }
        return count;
    }

    @EventHandler
    public void onChestOpen(final InventoryOpenEvent event) {
        if (event.getInventory().getType().equals((Object)InventoryType.CHEST)) {
            new BukkitRunnable(){

                public void run() {
                    Inventory inv = event.getInventory();
                    int removed = Uninstaller.this.removeArmoredElytras(inv);
                    if (removed != 0) {
                        Uninstaller.this.plugin.messagePlayer((HumanEntity)((Player)event.getPlayer()), ChatColor.RED, "Removed " + removed + " armored elytras from your chest!");
                    }
                }
            }.runTaskLater((Plugin)this.plugin, 20L);
        }
    }

    @EventHandler
    public void onPlayerLogin(final PlayerLoginEvent event) {
        new BukkitRunnable(){

            public void run() {
                PlayerInventory inv = event.getPlayer().getInventory();
                int removed = Uninstaller.this.removeArmoredElytras((Inventory)inv);
                if (removed != 0) {
                    Uninstaller.this.plugin.messagePlayer((HumanEntity)event.getPlayer(), ChatColor.RED, "Removed " + removed + " armored elytras from your inventory!");
                }
            }
        }.runTaskLater((Plugin)this.plugin, 20L);
    }
}

