/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.armoredElytra.nbtEditor;

import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nl.pim16aap2.armoredElytra.nbtEditor.NBTEditor;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class AutoPersistentDataContainer
implements AutoCloseable,
PersistentDataContainer {
    private final ItemStack itemStack;
    private final ItemMeta meta;
    private final PersistentDataContainer pdc;

    public AutoPersistentDataContainer(ItemStack itemStack) {
        this.itemStack = itemStack;
        this.meta = NBTEditor.getOrCreateItemMeta(itemStack);
        this.pdc = this.meta.getPersistentDataContainer();
    }

    @Override
    public void close() {
        this.itemStack.setItemMeta(this.meta);
    }

    public <P, C> void set(@Nonnull NamespacedKey key, @Nonnull PersistentDataType<P, C> type, @Nonnull C value) {
        this.pdc.set(key, type, value);
    }

    public <P, C> boolean has(@Nonnull NamespacedKey key, @Nonnull PersistentDataType<P, C> type) {
        return this.pdc.has(key, type);
    }

    public boolean has(@Nonnull NamespacedKey key) {
        return this.pdc.has(key);
    }

    @Nullable
    public <P, C> C get(@Nonnull NamespacedKey key, @Nonnull PersistentDataType<P, C> type) {
        return (C)this.pdc.get(key, type);
    }

    @Nonnull
    public <P, C> C getOrDefault(@Nonnull NamespacedKey key, @Nonnull PersistentDataType<P, C> type, @Nonnull C defaultValue) {
        return (C)this.pdc.getOrDefault(key, type, defaultValue);
    }

    @Nonnull
    public Set<NamespacedKey> getKeys() {
        return this.pdc.getKeys();
    }

    public void remove(@Nonnull NamespacedKey key) {
        this.pdc.remove(key);
    }

    public boolean isEmpty() {
        return this.pdc.isEmpty();
    }

    public void copyTo(@Nonnull PersistentDataContainer other, boolean replace) {
        this.pdc.copyTo(other, replace);
    }

    @Nonnull
    public PersistentDataAdapterContext getAdapterContext() {
        return this.pdc.getAdapterContext();
    }
}

