/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.armoredElytra.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.pim16aap2.armoredElytra.util.MappedMaterial;
import org.bukkit.Material;
import org.jspecify.annotations.Nullable;

public enum ArmorTier {
    NONE(0, 0, 0, 0.0, null, 0, "", 0),
    LEATHER(1, 3, 0, 0.0, Material.LEATHER, 6, "leather", 80),
    GOLD(2, 5, 0, 0.0, Material.GOLD_INGOT, 6, "gold", 112),
    CHAIN(3, 5, 0, 0.0, Material.IRON_INGOT, 4, "chain", 240),
    IRON(4, 6, 0, 0.0, Material.IRON_INGOT, 4, "iron", 240),
    DIAMOND(5, 8, 2, 0.0, Material.DIAMOND, 3, "diamond", 528),
    NETHERITE(6, 8, 3, 0.1, Material.NETHERITE_INGOT, 3, "netherite", 592),
    COPPER(7, 4, 0, 0.0, MappedMaterial.COPPER_INGOT, 4, "copper", 176);

    public static final List<ArmorTier> VALUES;
    public static final List<ArmorTier> ARMOR_TIERS;
    private final int tierID;
    private final int armor;
    private final int toughness;
    private final double knockbackResistance;
    private final @Nullable Material repair;
    private final int defaultRepairCount;
    private final String name;
    private final int durability;
    private static final Map<String, ArmorTier> map;
    private static final Map<Integer, ArmorTier> armorValueMap;
    private static final Map<Integer, ArmorTier> armorIDMap;

    private ArmorTier(int tierID, int armor, @Nullable int toughness, double knockbackResistance, Material repair, int defaultRepairCount, String name, int durability) {
        this.tierID = tierID;
        this.armor = armor;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
        this.repair = repair;
        this.defaultRepairCount = defaultRepairCount;
        this.name = name;
        this.durability = durability;
    }

    public static int getArmor(ArmorTier tier) {
        return tier.armor;
    }

    public static int getMaxDurability(ArmorTier tier) {
        return tier.durability;
    }

    public static int getTierID(ArmorTier tier) {
        return tier.tierID;
    }

    public static int getToughness(ArmorTier tier) {
        return tier.toughness;
    }

    public static double getKnockbackResistance(ArmorTier tier) {
        return tier.knockbackResistance;
    }

    public static @Nullable Material getRepairItem(ArmorTier tier) {
        return tier.repair;
    }

    public static String getName(ArmorTier tier) {
        return tier.name;
    }

    public static ArmorTier valueOfName(String name) {
        return map.get(name);
    }

    public static ArmorTier getArmorTierFromArmor(int armor) {
        ArmorTier tier = armorValueMap.get(armor);
        return tier == null ? NONE : tier;
    }

    public static ArmorTier getArmorTierFromID(int tierID) {
        ArmorTier tier = armorIDMap.get(tierID);
        return tier == null ? NONE : tier;
    }

    public static int getDefaultRepairCount(ArmorTier armorTier) {
        return armorTier.defaultRepairCount;
    }

    static {
        VALUES = List.of(ArmorTier.values());
        ARMOR_TIERS = VALUES.subList(1, VALUES.size());
        map = new HashMap<String, ArmorTier>();
        armorValueMap = new HashMap<Integer, ArmorTier>();
        armorIDMap = new HashMap<Integer, ArmorTier>();
        for (ArmorTier tier : ArmorTier.values()) {
            map.put(tier.name, tier);
            armorValueMap.put(tier.armor, tier);
            armorIDMap.put(tier.tierID, tier);
        }
        armorValueMap.put(ArmorTier.DIAMOND.armor, DIAMOND);
    }
}

