/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.armoredElytra.util;

import java.util.Locale;
import java.util.logging.Level;
import javax.annotation.Nullable;
import nl.pim16aap2.armoredElytra.ArmoredElytra;
import nl.pim16aap2.armoredElytra.util.RemappedEnchantment;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;

public class EnchantmentParser {
    private final ArmoredElytra plugin;

    public EnchantmentParser(ArmoredElytra plugin) {
        this.plugin = plugin;
    }

    @Nullable
    public Enchantment parse(@Nullable String input) {
        if (input == null) {
            return null;
        }
        Enchantment enchantment = this.parse0(input.toLowerCase(Locale.ROOT));
        if (enchantment == null) {
            this.plugin.getLogger().warning("Failed to parse enchantment: '" + input + "'");
        }
        return enchantment;
    }

    @Nullable
    private Enchantment parseWithoutNamespace(String name) {
        try {
            return Enchantment.getByName((String)name);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to parse enchantment without namespace: '" + name + "'", e);
        }
    }

    @Nullable
    private Enchantment parseFromMinecraftNamespace(String key) {
        try {
            for (RemappedEnchantment remappedEnchantment : RemappedEnchantment.getRemappedEnchantments()) {
                if (!remappedEnchantment.getNames().contains(key)) continue;
                return remappedEnchantment.getEnchantment();
            }
            return this.parseFromNamespace("minecraft", key);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to parse enchantment from Minecraft namespace: '" + key + "'", e);
        }
    }

    @Nullable
    private Enchantment parseFromNamespace(String namespace, String key) {
        try {
            NamespacedKey namespacedKey = new NamespacedKey(namespace, key);
            return Enchantment.getByKey((NamespacedKey)namespacedKey);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to parse enchantment from namespace: '" + namespace + ":" + key + "'", e);
        }
    }

    @Nullable
    private Enchantment parse0(String input) {
        try {
            String stripped = input.strip();
            if (stripped.isEmpty()) {
                return null;
            }
            String[] keyParts = stripped.split(":", 2);
            if (keyParts.length < 2) {
                return this.parseWithoutNamespace(stripped);
            }
            String namespace = keyParts[0];
            String key = keyParts[1];
            if ("minecraft".equals(namespace)) {
                return this.parseFromMinecraftNamespace(key);
            }
            return this.parseFromNamespace(namespace, key);
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, e, () -> "Failed to parse enchantment from input: '" + input + "'");
            return null;
        }
    }
}

