/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.armoredElytra.util;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import nl.pim16aap2.armoredElytra.ArmoredElytra;
import nl.pim16aap2.armoredElytra.lib.semver4j.Semver;
import nl.pim16aap2.armoredElytra.lib.semver4j.SemverException;
import nl.pim16aap2.armoredElytra.lib.semver4j.internal.Coerce;

public final class UpdateChecker {
    private static final String USER_AGENT = "ArmoredElytra-update-checker";
    private static final String UPDATE_URL = "https://api.spiget.org/v2/resources/%d/versions?size=1&sort=-releaseDate";
    private static UpdateChecker instance;
    private UpdateResult lastResult = null;
    private final ArmoredElytra plugin;
    private final int pluginID;

    private UpdateChecker(ArmoredElytra plugin, int pluginID) {
        this.plugin = plugin;
        this.pluginID = pluginID;
    }

    public CompletableFuture<UpdateResult> requestUpdateCheck() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                URL url = new URL(String.format(UPDATE_URL, this.pluginID));
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.addRequestProperty("User-Agent", USER_AGENT);
                InputStreamReader reader = new InputStreamReader(connection.getInputStream());
                int responseCode = connection.getResponseCode();
                if (responseCode != 200) {
                    return new UpdateResult(responseCode == 401 ? UpdateReason.UNAUTHORIZED_QUERY : UpdateReason.UNKNOWN_ERROR);
                }
                JsonElement element = JsonParser.parseReader((Reader)reader);
                if (!element.isJsonArray()) {
                    return new UpdateResult(UpdateReason.INVALID_JSON);
                }
                reader.close();
                JsonObject versionObject = element.getAsJsonArray().get(0).getAsJsonObject();
                long age = -1L;
                String ageString = versionObject.get("releaseDate").getAsString();
                try {
                    age = this.getAge(Long.parseLong(ageString));
                }
                catch (NumberFormatException e) {
                    this.plugin.myLogger(Level.WARNING, "Failed to obtain age of update from ageString: \"" + ageString + "\"");
                }
                String currentString = this.plugin.getDescription().getVersion();
                String latestAvailableString = versionObject.get("name").getAsString();
                Semver current = UpdateChecker.parseVersion(currentString);
                Semver latestAvailable = UpdateChecker.parseVersion(latestAvailableString);
                if (current == null || latestAvailable == null) {
                    return new UpdateResult(UpdateReason.UNSUPPORTED_VERSION_SCHEME);
                }
                if (latestAvailable.isGreaterThan(current)) {
                    return new UpdateResult(UpdateReason.NEW_UPDATE, latestAvailableString, age);
                }
                return new UpdateResult(current.equals(latestAvailable) ? UpdateReason.UP_TO_DATE : UpdateReason.UNRELEASED_VERSION, currentString, age);
            }
            catch (IOException e) {
                return new UpdateResult(UpdateReason.COULD_NOT_CONNECT);
            }
            catch (JsonSyntaxException e) {
                return new UpdateResult(UpdateReason.INVALID_JSON);
            }
        });
    }

    private long getAge(long updateTime) {
        long currentTime = Instant.now().getEpochSecond();
        return currentTime - updateTime;
    }

    public UpdateResult getLastResult() {
        return this.lastResult;
    }

    public static synchronized UpdateChecker init(ArmoredElytra plugin, int pluginID) {
        Preconditions.checkArgument((pluginID > 0 ? 1 : 0) != 0, (Object)"Plugin ID must be greater than 0");
        return instance == null ? (instance = new UpdateChecker(plugin, pluginID)) : instance;
    }

    public static UpdateChecker get() {
        Preconditions.checkState((instance != null ? 1 : 0) != 0, (Object)"Instance has not yet been initialized. Be sure #init() has been invoked");
        return instance;
    }

    public static boolean isInitialized() {
        return instance != null;
    }

    static Semver parseVersion(String version) {
        Object coerced;
        String suffix = null;
        int dashIndex = version.indexOf(45);
        if (dashIndex != -1) {
            suffix = version.substring(dashIndex + 1);
            version = version.substring(0, dashIndex);
        }
        if ((coerced = Coerce.coerce(version)) == null) {
            return null;
        }
        if (suffix != null) {
            coerced = (String)coerced + "-" + suffix;
        }
        try {
            return new Semver((String)coerced);
        }
        catch (SemverException e) {
            return null;
        }
    }

    public final class UpdateResult {
        private final UpdateReason reason;
        private final String newestVersion;
        private final long age;

        private UpdateResult(UpdateReason reason, String newestVersion, long age) {
            UpdateChecker.this.lastResult = this;
            this.reason = reason;
            this.newestVersion = newestVersion;
            this.age = age;
        }

        private UpdateResult(UpdateReason reason) {
            UpdateChecker.this.lastResult = this;
            Preconditions.checkArgument((reason != UpdateReason.NEW_UPDATE && reason != UpdateReason.UP_TO_DATE ? 1 : 0) != 0, (Object)"Reasons that might require updates must also provide the latest version String");
            this.reason = reason;
            this.newestVersion = UpdateChecker.this.plugin.getDescription().getVersion();
            this.age = -1L;
        }

        public UpdateReason getReason() {
            return this.reason;
        }

        public boolean requiresUpdate() {
            return this.reason == UpdateReason.NEW_UPDATE;
        }

        public String getNewestVersion() {
            return this.newestVersion;
        }

        public long getAge() {
            return this.age;
        }
    }

    public static enum UpdateReason {
        NEW_UPDATE,
        COULD_NOT_CONNECT,
        INVALID_JSON,
        UNAUTHORIZED_QUERY,
        UNRELEASED_VERSION,
        UNKNOWN_ERROR,
        UNSUPPORTED_VERSION_SCHEME,
        UP_TO_DATE;

    }
}

