/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.armoredElytra.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nl.pim16aap2.armoredElytra.util.ArmorTier;
import nl.pim16aap2.armoredElytra.util.MappedMaterial;
import nl.pim16aap2.armoredElytra.util.RemappedEnchantment;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class Util {
    private static final boolean CHEST_ARMOR_TAG_AVAILABLE = Util.verifyTagExists("ITEMS_CHEST_ARMOR");

    public static String errorToString(Error e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static String exceptionToString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static boolean isBroken(ItemStack item) {
        return item.getDurability() >= item.getType().getMaxDurability();
    }

    public static ArmorTier armorToTier(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            return ArmorTier.NONE;
        }
        return Util.armorToTier(itemStack.getType());
    }

    public static ArmorTier armorToTier(Material mat) {
        if (mat == MappedMaterial.COPPER_CHESTPLATE) {
            return ArmorTier.COPPER;
        }
        return switch (mat) {
            case Material.LEATHER_CHESTPLATE -> ArmorTier.LEATHER;
            case Material.GOLDEN_CHESTPLATE -> ArmorTier.GOLD;
            case Material.CHAINMAIL_CHESTPLATE -> ArmorTier.CHAIN;
            case Material.IRON_CHESTPLATE -> ArmorTier.IRON;
            case Material.DIAMOND_CHESTPLATE -> ArmorTier.DIAMOND;
            case Material.NETHERITE_CHESTPLATE -> ArmorTier.NETHERITE;
            default -> ArmorTier.NONE;
        };
    }

    @Nullable
    public static Material tierToChestPlate(@Nullable ArmorTier armorTier) {
        if (armorTier == null) {
            return null;
        }
        return switch (armorTier) {
            default -> throw new IncompatibleClassChangeError();
            case ArmorTier.NONE -> null;
            case ArmorTier.LEATHER -> Material.LEATHER_CHESTPLATE;
            case ArmorTier.GOLD -> Material.GOLDEN_CHESTPLATE;
            case ArmorTier.CHAIN -> Material.CHAINMAIL_CHESTPLATE;
            case ArmorTier.IRON -> Material.IRON_CHESTPLATE;
            case ArmorTier.DIAMOND -> Material.DIAMOND_CHESTPLATE;
            case ArmorTier.NETHERITE -> Material.NETHERITE_CHESTPLATE;
            case ArmorTier.COPPER -> MappedMaterial.COPPER_CHESTPLATE;
        };
    }

    public static boolean isChestPlate(@Nullable ItemStack itemStack) {
        return itemStack != null && Util.isChestPlate(itemStack.getType());
    }

    public static boolean isChestPlate(Material mat) {
        if (CHEST_ARMOR_TAG_AVAILABLE) {
            return Tag.ITEMS_CHEST_ARMOR.isTagged((Keyed)mat);
        }
        return mat == Material.LEATHER_CHESTPLATE || mat == Material.GOLDEN_CHESTPLATE || mat == Material.CHAINMAIL_CHESTPLATE || mat == Material.IRON_CHESTPLATE || mat == Material.DIAMOND_CHESTPLATE || mat == Material.NETHERITE_CHESTPLATE;
    }

    @Nonnull
    public static Player humanEntityToPlayer(HumanEntity humanEntity) {
        if (humanEntity instanceof Player) {
            Player player = (Player)humanEntity;
            return player;
        }
        return Objects.requireNonNull(Bukkit.getPlayer((UUID)humanEntity.getUniqueId()), "Could not get player from human entity: '" + String.valueOf(humanEntity) + "'!");
    }

    @Nullable
    public static Player humanEntityToOptionalPlayer(HumanEntity humanEntity) {
        if (humanEntity instanceof Player) {
            Player player = (Player)humanEntity;
            return player;
        }
        return null;
    }

    public static String nullableColorToString(@Nullable ChatColor color) {
        return color == null ? "" : color.toString();
    }

    public static String snakeToCamelCase(String input) {
        char[] arr = input.toLowerCase(Locale.US).toCharArray();
        int skipped = 0;
        boolean capitalize = false;
        for (int idx = 0; idx < arr.length; ++idx) {
            char current = arr[idx];
            if (current == '_') {
                ++skipped;
                capitalize = true;
                continue;
            }
            int targetIdx = idx - skipped;
            if (capitalize) {
                if (targetIdx > 0) {
                    current = Character.toUpperCase(current);
                }
                capitalize = false;
            }
            arr[targetIdx] = current;
        }
        return new String(arr, 0, arr.length - skipped);
    }

    public static int getProtectionEnchantmentsVal(Map<Enchantment, Integer> enchantments) {
        int ret = 0;
        if (enchantments.containsKey(RemappedEnchantment.PROTECTION_ENVIRONMENTAL)) {
            ++ret;
        }
        if (enchantments.containsKey(RemappedEnchantment.PROTECTION_EXPLOSIONS)) {
            ret += 2;
        }
        if (enchantments.containsKey(RemappedEnchantment.PROTECTION_FALL)) {
            ret += 4;
        }
        if (enchantments.containsKey(RemappedEnchantment.PROTECTION_FIRE)) {
            ret += 8;
        }
        if (enchantments.containsKey(RemappedEnchantment.PROTECTION_PROJECTILE)) {
            ret += 16;
        }
        return ret;
    }

    public static void moveChestplateToInventory(Player player) {
        PlayerInventory inventory = player.getInventory();
        inventory.addItem(new ItemStack[]{inventory.getChestplate()});
        ItemStack chestplate = inventory.getChestplate();
        if (chestplate != null) {
            chestplate.setAmount(0);
        }
        player.updateInventory();
    }

    public static int toInt(String str, int defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static int between(int val, int min, int max) {
        return Math.max(min, Math.min(max, val));
    }

    private static boolean verifyTagExists(String tagName) {
        try {
            Tag.class.getField(tagName);
            return true;
        }
        catch (NoSuchFieldException e) {
            return false;
        }
    }
}

