/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.armoredElytra.util.messages;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.regex.Pattern;
import nl.pim16aap2.armoredElytra.ArmoredElytra;
import nl.pim16aap2.armoredElytra.util.messages.Message;
import org.bukkit.ChatColor;

public class Messages {
    private static final String DEFAULT_FILENAME = "en_US.txt";
    private final Map<Message, String> messageMap = new EnumMap<Message, String>(Message.class);
    private final ArmoredElytra plugin;
    private Path textFile;
    private static final Pattern matchDots = Pattern.compile("\\.");
    private static final Pattern matchNewLines = Pattern.compile("\\\\n");
    private static final Pattern matchColorCodes = Pattern.compile("&((?i)[0-9a-fk-or])");

    public Messages(ArmoredElytra plugin) {
        this.plugin = plugin;
        Messages.writeDefaultFiles(plugin);
        Object fileName = plugin.getConfigLoader().languageFile();
        fileName = ((String)fileName).endsWith(".txt") ? fileName : (String)fileName + ".txt";
        this.textFile = Path.of(plugin.getDataFolder().toURI()).resolve((String)fileName);
        if (!Files.exists(this.textFile, new LinkOption[0])) {
            plugin.myLogger(Level.WARNING, "Failed to load language file: \"" + String.valueOf(this.textFile) + "\": File not found! Using default file (\"en_US.txt\") instead!");
            this.textFile = Path.of(plugin.getDataFolder().toURI()).resolve(DEFAULT_FILENAME);
        }
        this.populateMessageMap();
    }

    private void processFile(BufferedReader br, BiConsumer<Message, String> action) throws IOException {
        String sCurrentLine;
        while ((sCurrentLine = br.readLine()) != null) {
            if (sCurrentLine.startsWith("#") || sCurrentLine.isEmpty()) continue;
            String[] parts = sCurrentLine.split("=", 2);
            try {
                Message msg = Message.valueOf(matchDots.matcher(parts[0]).replaceAll("_").toUpperCase());
                String value = matchNewLines.matcher(matchColorCodes.matcher(parts[1]).replaceAll("\u00a7$1")).replaceAll("\n");
                action.accept(msg, value);
            }
            catch (IllegalArgumentException e) {
                this.plugin.myLogger(Level.WARNING, "Failed to identify Message corresponding to key: \"" + parts[0] + "\". Its value will be ignored!");
                System.out.println("Trying to find enum value of: " + matchDots.matcher(parts[0]).replaceAll("_").toUpperCase());
            }
        }
    }

    private void addMessage(Message message, String value) {
        this.messageMap.put(message, message.getDefaultColor() + ChatColor.translateAlternateColorCodes((char)'&', (String)value));
    }

    private void addBackupMessage(Message message, String value) {
        if (this.messageMap.containsKey(message)) {
            return;
        }
        this.plugin.myLogger(Level.WARNING, "Could not find translation of key: \"" + message.name() + "\". Using default value instead!");
        this.addMessage(message, value);
    }

    private void populateMessageMap() {
        try (BufferedReader br = Files.newBufferedReader(this.textFile, StandardCharsets.UTF_8);){
            this.processFile(br, this::addMessage);
        }
        catch (FileNotFoundException e) {
            this.plugin.myLogger(Level.SEVERE, "Locale file \"" + String.valueOf(this.textFile) + "\" does not exist!");
            e.printStackTrace();
        }
        catch (IOException e) {
            this.plugin.myLogger(Level.SEVERE, "Could not read locale file! \"" + String.valueOf(this.textFile) + "\"");
            e.printStackTrace();
        }
        URL defaultFileUrl = Objects.requireNonNull(this.getClass().getClassLoader().getResource(DEFAULT_FILENAME));
        try (BufferedReader br = new BufferedReader(new InputStreamReader(defaultFileUrl.openStream(), StandardCharsets.UTF_8));){
            this.processFile(br, this::addBackupMessage);
        }
        catch (FileNotFoundException e) {
            this.plugin.myLogger(Level.SEVERE, "Failed to load internal locale file!");
            e.printStackTrace();
        }
        catch (IOException e) {
            this.plugin.myLogger(Level.SEVERE, "Could not read internal locale file!");
            e.printStackTrace();
        }
        for (Message msg : Message.values()) {
            if (msg.equals(Message.EMPTY) || this.messageMap.containsKey(msg)) continue;
            this.plugin.myLogger(Level.WARNING, "Could not find translation of key: " + msg.name());
            this.messageMap.put(msg, this.getFailureString(msg.name()));
        }
    }

    private String getFailureString(String key) {
        return "Translation for key \"" + key + "\" not found! Contact server admin!";
    }

    public String getString(Message msg, String ... values) {
        if (msg.equals(Message.EMPTY)) {
            return "";
        }
        if (values.length != Message.getVariableCount(msg)) {
            this.plugin.myLogger(Level.SEVERE, "Expected " + Message.getVariableCount(msg) + " variables for key " + msg.name() + " but only got " + values.length + ". This is a bug. Please contact pim16aap2!");
            return this.getFailureString(msg.name());
        }
        String value = this.messageMap.get(msg);
        if (value != null) {
            for (int idx = 0; idx != values.length; ++idx) {
                value = Messages.insertVariable(value, Message.getVariableName(msg, idx), values[idx]);
            }
            return value;
        }
        this.plugin.myLogger(Level.WARNING, "Failed to get the translation for key " + msg.name());
        return this.getFailureString(msg.name());
    }

    static String insertVariable(String base, String variable, String value) {
        int idx = base.indexOf(variable);
        if (idx == -1) {
            return base;
        }
        String color = ChatColor.getLastColors((String)base.substring(0, idx));
        if (color.isEmpty()) {
            color = ChatColor.RESET.toString();
        }
        return base.replaceFirst(variable, value + color);
    }

    private static void writeDefaultFiles(ArmoredElytra plugin) {
        try {
            Messages.getPackagedLocalizations(plugin).forEach(file -> Messages.saveResource(plugin, file, false));
        }
        catch (IOException e) {
            plugin.myLogger(Level.SEVERE, "Failed to write default localization files!");
            e.printStackTrace();
        }
    }

    private static void saveResource(ArmoredElytra plugin, String resourcePath, boolean replace) {
        File outFile = new File(plugin.getDataFolder(), resourcePath);
        if (!replace && outFile.exists()) {
            return;
        }
        plugin.saveResource(resourcePath, replace);
    }

    private static List<String> getPackagedLocalizations(ArmoredElytra plugin) throws IOException {
        ArrayList<String> files = new ArrayList<String>();
        Enumeration<URL> enumeration = ((Object)((Object)plugin)).getClass().getClassLoader().getResources("META-INF");
        while (enumeration.hasMoreElements()) {
            URL url = enumeration.nextElement();
            JarURLConnection connection = (JarURLConnection)url.openConnection();
            JarFile jarFile = connection.getJarFile();
            try {
                Enumeration<JarEntry> jarEntries = jarFile.entries();
                while (jarEntries.hasMoreElements()) {
                    String name = jarEntries.nextElement().getName();
                    if (name.contains("/") || !name.endsWith(".txt")) continue;
                    files.add(name);
                }
            }
            finally {
                if (jarFile == null) continue;
                jarFile.close();
            }
        }
        return files;
    }
}

