/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.armoredElytra.handlers;

import java.util.Arrays;
import java.util.logging.Level;
import nl.pim16aap2.armoredElytra.ArmoredElytra;
import nl.pim16aap2.armoredElytra.handlers.ArmoredElytraHandler;
import nl.pim16aap2.armoredElytra.nbtEditor.DurabilityManager;
import nl.pim16aap2.armoredElytra.nbtEditor.NBTEditor;
import nl.pim16aap2.armoredElytra.util.ArmorTier;
import nl.pim16aap2.armoredElytra.util.ConfigLoader;
import nl.pim16aap2.armoredElytra.util.itemInput.ElytraInput;
import nl.pim16aap2.armoredElytra.util.itemInput.InputAction;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class AnvilHandler
extends ArmoredElytraHandler
implements Listener {
    public AnvilHandler(ArmoredElytra plugin, NBTEditor nbtEditor, DurabilityManager durabilityManager, ConfigLoader config) {
        super(plugin, nbtEditor, durabilityManager, config);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    private void onAnvilInventoryOpen(PrepareAnvilEvent event) {
        HumanEntity humanEntity = event.getView().getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        ElytraInput input = ElytraInput.fromInventory(this.config, this.durabilityManager, event.getInventory());
        if (input.isIgnored()) {
            return;
        }
        event.setResult(this.armoredElytraBuilder.handleInput((HumanEntity)player, input));
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        Inventory inventory;
        HumanEntity humanEntity;
        if (event.getRawSlot() != 2 || !((humanEntity = event.getWhoClicked()) instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (event.getView().getType() != InventoryType.ANVIL || !((inventory = event.getInventory()) instanceof AnvilInventory)) {
            return;
        }
        AnvilInventory anvilInventory = (AnvilInventory)inventory;
        ItemStack result = anvilInventory.getItem(2);
        if (result == null) {
            return;
        }
        ElytraInput input = ElytraInput.fromInventory(this.config, this.durabilityManager, anvilInventory);
        if (input.isIgnored()) {
            return;
        }
        if (this.nbtEditor.getArmorTierFromElytra(result) == ArmorTier.NONE) {
            this.plugin.myLogger(Level.SEVERE, "Anvil: Attempted to retrieve an item that is not an armored elytra! Result: " + String.valueOf(result) + ", input: " + String.valueOf(input));
            return;
        }
        event.setCancelled(true);
        if (input.isBlocked()) {
            this.plugin.getLogger().severe("Anvil: Attempted to retrieve an item from a blocked recipe! Input: " + String.valueOf(input));
            return;
        }
        if (!this.giveItemToPlayer(player, result, event.isShiftClick())) {
            return;
        }
        try {
            this.consumeInput(anvilInventory, input.inputAction());
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("An error occurred while consuming the input of the anvil.");
            e.printStackTrace();
            anvilInventory.clear();
        }
    }

    private void consumeInput(AnvilInventory anvilInventory, InputAction inputAction) {
        ItemStack newRepairItem;
        ItemStack repairItem;
        ItemStack elytra;
        int repairItemSlot;
        int elytraSlot;
        if (inputAction != InputAction.REPAIR) {
            anvilInventory.clear();
            return;
        }
        ItemStack item0 = anvilInventory.getItem(0);
        ItemStack item1 = anvilInventory.getItem(1);
        ArmorTier armorTier = this.nbtEditor.getArmorTierFromElytra(item0);
        if (armorTier != ArmorTier.NONE) {
            elytraSlot = 0;
            repairItemSlot = 1;
            elytra = item0;
            repairItem = item1;
        } else {
            elytraSlot = 1;
            repairItemSlot = 0;
            armorTier = this.nbtEditor.getArmorTierFromElytra(item1);
            elytra = item1;
            repairItem = item0;
        }
        if (armorTier == ArmorTier.NONE) {
            throw new IllegalStateException("No elytra found in anvil inventory with contents: " + Arrays.toString(anvilInventory.getContents()));
        }
        Material expectedRepairItem = ArmorTier.getRepairItem(armorTier);
        if (repairItem == null || ArmorTier.getRepairItem(armorTier) != repairItem.getType()) {
            throw new IllegalStateException("Expected repair item to be '" + String.valueOf(expectedRepairItem) + "' but received '" + String.valueOf(repairItem) + "' in anvil inventory with contents: " + Arrays.toString(anvilInventory.getContents()));
        }
        anvilInventory.setItem(2, null);
        int fullRepairAmount = this.durabilityManager.getFullRepairItemCount(elytra, armorTier);
        int newRepairItemAmount = Math.max(0, repairItem.getAmount() - fullRepairAmount);
        if (newRepairItemAmount == 0) {
            newRepairItem = null;
        } else {
            newRepairItem = repairItem.clone();
            newRepairItem.setAmount(newRepairItemAmount);
        }
        anvilInventory.setItem(repairItemSlot, newRepairItem);
        anvilInventory.setItem(elytraSlot, null);
    }
}

