/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.armoredElytra.handlers;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Random;
import java.util.Set;
import nl.pim16aap2.armoredElytra.ArmoredElytra;
import nl.pim16aap2.armoredElytra.lib.armorequip.ArmorEquipEvent;
import nl.pim16aap2.armoredElytra.lib.armorequip.ArmorListener;
import nl.pim16aap2.armoredElytra.lib.armorequip.ArmorType;
import nl.pim16aap2.armoredElytra.lib.armorequip.DispenserArmorListener;
import nl.pim16aap2.armoredElytra.nbtEditor.DurabilityManager;
import nl.pim16aap2.armoredElytra.nbtEditor.NBTEditor;
import nl.pim16aap2.armoredElytra.util.AllowedToWearEnum;
import nl.pim16aap2.armoredElytra.util.ArmorTier;
import nl.pim16aap2.armoredElytra.util.RemappedEnchantment;
import nl.pim16aap2.armoredElytra.util.Util;
import nl.pim16aap2.armoredElytra.util.messages.Message;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerItemMendEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class EventHandlers
implements Listener {
    private static final Set<EntityDamageEvent.DamageCause> IGNORED_DAMAGE_CAUSES = EnumSet.of(EntityDamageEvent.DamageCause.CRAMMING, new EntityDamageEvent.DamageCause[]{EntityDamageEvent.DamageCause.DRAGON_BREATH, EntityDamageEvent.DamageCause.DROWNING, EntityDamageEvent.DamageCause.FALL, EntityDamageEvent.DamageCause.FIRE_TICK, EntityDamageEvent.DamageCause.FLY_INTO_WALL, EntityDamageEvent.DamageCause.KILL, EntityDamageEvent.DamageCause.MAGIC, EntityDamageEvent.DamageCause.POISON, EntityDamageEvent.DamageCause.STARVATION, EntityDamageEvent.DamageCause.SUFFOCATION, EntityDamageEvent.DamageCause.SUICIDE, EntityDamageEvent.DamageCause.VOID, EntityDamageEvent.DamageCause.WITHER, EntityDamageEvent.DamageCause.WORLD_BORDER});
    private static final Set<EntityDamageEvent.DamageCause> FIRE_DAMAGE_CAUSES = EnumSet.of(EntityDamageEvent.DamageCause.FIRE, EntityDamageEvent.DamageCause.FIRE_TICK, EntityDamageEvent.DamageCause.LAVA, EntityDamageEvent.DamageCause.HOT_FLOOR);
    private final Random random = new Random();
    private final ArmoredElytra plugin;
    private final NBTEditor nbtEditor;
    private final DurabilityManager durabilityManager;

    public EventHandlers(ArmoredElytra plugin, NBTEditor nbtEditor, DurabilityManager durabilityManager) {
        this.plugin = plugin;
        this.nbtEditor = nbtEditor;
        this.durabilityManager = durabilityManager;
        this.initializeArmorEquipEvent();
    }

    private void initializeArmorEquipEvent() {
        Bukkit.getPluginManager().registerEvents((Listener)new ArmorListener(new ArrayList<String>()), (Plugin)this.plugin);
        Bukkit.getPluginManager().registerEvents((Listener)new DispenserArmorListener(), (Plugin)this.plugin);
    }

    private AllowedToWearEnum isAllowedToWear(ItemStack elytra, Player player, ArmorTier armorTier) {
        if (armorTier.equals((Object)ArmorTier.NONE)) {
            return AllowedToWearEnum.ALLOWED;
        }
        if (Util.isBroken(elytra)) {
            return AllowedToWearEnum.BROKEN;
        }
        if (!this.plugin.playerHasWearPerm((HumanEntity)player, armorTier)) {
            return AllowedToWearEnum.NOPERMISSION;
        }
        return AllowedToWearEnum.ALLOWED;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerDamage(EntityDamageEvent e) {
        int enchantLevel;
        float removeDurabilityChance;
        int randomInt;
        Entity entity = e.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player p = (Player)entity;
        ItemStack elytra = p.getInventory().getChestplate();
        if (elytra == null) {
            return;
        }
        ArmorTier armorTier = this.nbtEditor.getArmorTierFromElytra(elytra);
        if (armorTier == ArmorTier.NONE) {
            return;
        }
        EntityDamageEvent.DamageCause cause = e.getCause();
        if (IGNORED_DAMAGE_CAUSES.contains(cause)) {
            return;
        }
        if (armorTier == ArmorTier.NETHERITE && FIRE_DAMAGE_CAUSES.contains(cause)) {
            return;
        }
        boolean removeDurability = elytra.containsEnchantment(RemappedEnchantment.UNBREAKING) ? (float)(randomInt = this.random.nextInt(101)) <= (removeDurabilityChance = 60.0f + 40.0f / (float)((enchantLevel = elytra.getEnchantmentLevel(RemappedEnchantment.UNBREAKING)) + 1)) : true;
        int durabilityLoss = removeDurability ? (int)Math.max(1.0, e.getDamage() / 4.0) : 0;
        int newDurability = this.durabilityManager.removeDurability(elytra, durabilityLoss, armorTier);
        if (this.durabilityManager.isBroken(newDurability, armorTier)) {
            Util.moveChestplateToInventory(p);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onMending(PlayerItemMendEvent e) {
        ArmorTier armorTier = this.nbtEditor.getArmorTierFromElytra(e.getItem());
        if (armorTier == ArmorTier.NONE) {
            return;
        }
        int newDurability = this.durabilityManager.removeDurability(e.getItem(), -e.getRepairAmount(), armorTier);
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.durabilityManager.setDurability(e.getItem(), newDurability, armorTier), 1L);
    }

    @EventHandler
    public void onEquip(ArmorEquipEvent e) {
        if (e.getMethod().equals((Object)ArmorEquipEvent.EquipMethod.DEATH) || e.getMethod().equals((Object)ArmorEquipEvent.EquipMethod.BROKE)) {
            return;
        }
        if (!e.getType().equals((Object)ArmorType.CHESTPLATE) || e.getNewArmorPiece() == null || !e.getNewArmorPiece().getType().equals((Object)Material.ELYTRA)) {
            return;
        }
        ArmorTier armorTier = this.nbtEditor.getArmorTierFromElytra(e.getNewArmorPiece());
        AllowedToWearEnum allowed = this.isAllowedToWear(e.getNewArmorPiece(), e.getPlayer(), armorTier);
        switch (allowed) {
            case ALLOWED: {
                break;
            }
            case BROKEN: {
                this.plugin.messagePlayer((HumanEntity)e.getPlayer(), this.plugin.getMyMessages().getString(Message.MESSAGES_REPAIRNEEDED, new String[0]));
                e.setCancelled(true);
                break;
            }
            case NOPERMISSION: {
                this.plugin.usageDeniedMessage((HumanEntity)e.getPlayer(), armorTier);
                e.setCancelled(true);
                break;
            }
        }
    }
}

