/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.armoredElytra.handlers;

import java.util.Locale;
import java.util.logging.Level;
import javax.annotation.Nullable;
import nl.pim16aap2.armoredElytra.ArmoredElytra;
import nl.pim16aap2.armoredElytra.handlers.AbstractSmithingTableListener;
import nl.pim16aap2.armoredElytra.nbtEditor.AutoPersistentDataContainer;
import nl.pim16aap2.armoredElytra.nbtEditor.DurabilityManager;
import nl.pim16aap2.armoredElytra.nbtEditor.NBTEditor;
import nl.pim16aap2.armoredElytra.util.ArmorTier;
import nl.pim16aap2.armoredElytra.util.ConfigLoader;
import nl.pim16aap2.armoredElytra.util.SmithingTableUtil;
import nl.pim16aap2.armoredElytra.util.Util;
import nl.pim16aap2.armoredElytra.util.itemInput.ElytraInput;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.PrepareSmithingEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.SmithingInventory;
import org.bukkit.inventory.SmithingTransformRecipe;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

class SmithingTableRecipeListener
extends AbstractSmithingTableListener
implements Listener {
    @Nullable
    private static final RecipeChoice NETHERITE_UPGRADE_TEMPLATE_CHOICE = new RecipeChoice.MaterialChoice(Material.NETHERITE_UPGRADE_SMITHING_TEMPLATE);
    private static final NamespacedKey RECIPE_PLACEHOLDER_KEY = new NamespacedKey((Plugin)ArmoredElytra.getInstance(), "st_placeholder");
    private static final ItemStack RECIPE_RESULT_PLACEHOLDER = SmithingTableRecipeListener.createRecipeResultPlaceholder();
    private static final RecipeChoice RECIPE_CHOICE_ELYTRA = new RecipeChoice.MaterialChoice(Material.ELYTRA);

    SmithingTableRecipeListener(ArmoredElytra plugin, NBTEditor nbtEditor, DurabilityManager durabilityManager, ConfigLoader config) {
        super(plugin, nbtEditor, durabilityManager, config);
        this.registerRecipes();
    }

    @EventHandler(ignoreCancelled=true)
    public void onSmithingTableUsage(PrepareSmithingEvent event) {
        ElytraInput input = this.onSmithingTableUsage0(event);
        this.verifyRecipeResultPlaceholder(event.getInventory(), input);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOW)
    public void onInventoryClick(InventoryClickEvent event) {
        Player player = Util.humanEntityToPlayer(event.getWhoClicked());
        if (!(player.getOpenInventory().getTopInventory() instanceof SmithingInventory)) {
            return;
        }
        Inventory inventory = event.getClickedInventory();
        if (inventory instanceof SmithingInventory) {
            SmithingInventory clickedSmithingInventory = (SmithingInventory)inventory;
            this.onSmithingInventoryClick(event, player, clickedSmithingInventory);
        }
    }

    protected void onSmithingInventoryClick(InventoryClickEvent event, Player player, SmithingInventory smithingInventory) {
        if (event.getSlot() == SmithingTableUtil.SMITHING_TABLE_RESULT_SLOT) {
            this.onSmithingInventoryResultClick(event, player, smithingInventory);
        }
    }

    private static ItemStack createRecipeResultPlaceholder() {
        ItemStack result = new ItemStack(Material.ELYTRA);
        try (AutoPersistentDataContainer pdc = new AutoPersistentDataContainer(result);){
            pdc.set(RECIPE_PLACEHOLDER_KEY, PersistentDataType.BYTE, (byte)1);
        }
        return result;
    }

    @Override
    protected boolean isRecipeResultPlaceholder(ItemStack item) {
        if (item == null || item.getType() != Material.ELYTRA) {
            return false;
        }
        return NBTEditor.hasPdcWithKey(item, RECIPE_PLACEHOLDER_KEY, PersistentDataType.BYTE);
    }

    private void verifyRecipeResultPlaceholder(SmithingInventory inventory, ElytraInput input) {
        ItemStack result = inventory.getItem(SmithingTableUtil.SMITHING_TABLE_RESULT_SLOT);
        if (this.isRecipeResultPlaceholder(result)) {
            this.plugin.myLogger(Level.SEVERE, "Smithing Table: Attempted to retrieve a placeholder result! Result: " + String.valueOf(result) + ", input: " + String.valueOf(input));
            inventory.setItem(SmithingTableUtil.SMITHING_TABLE_RESULT_SLOT, null);
        }
    }

    private void registerRecipes() {
        if (this.config.allowCraftingInSmithingTable()) {
            ArmorTier.ARMOR_TIERS.forEach(this::registerCraftingRecipe);
        }
        if (this.config.allowUpgradeToNetherite()) {
            this.registerUpgradeToNetheriteRecipe();
        }
    }

    private void registerUpgradeToNetheriteRecipe() {
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "st_upgrade_to_netherite");
        RecipeChoice.MaterialChoice netheriteIngot = new RecipeChoice.MaterialChoice(Material.NETHERITE_INGOT);
        this.registerCraftingRecipe(key, NETHERITE_UPGRADE_TEMPLATE_CHOICE, (RecipeChoice)netheriteIngot);
    }

    private void registerCraftingRecipe(ArmorTier tier) {
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "st_recipe_" + tier.name().toLowerCase(Locale.ROOT));
        Material chestPlateMaterial = Util.tierToChestPlate(tier);
        if (chestPlateMaterial == null) {
            return;
        }
        RecipeChoice.MaterialChoice chestPlate = new RecipeChoice.MaterialChoice(chestPlateMaterial);
        this.registerCraftingRecipe(key, null, (RecipeChoice)chestPlate);
    }

    private void registerCraftingRecipe(NamespacedKey key, @Nullable RecipeChoice template, RecipeChoice chestPlate) {
        Bukkit.addRecipe((Recipe)new SmithingTransformRecipe(key, RECIPE_RESULT_PLACEHOLDER, template, RECIPE_CHOICE_ELYTRA, chestPlate));
    }
}

