/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.armoredElytra.lib.semver4j;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nl.pim16aap2.armoredElytra.lib.semver4j.Range;
import nl.pim16aap2.armoredElytra.lib.semver4j.RangesList;
import nl.pim16aap2.armoredElytra.lib.semver4j.internal.Tokenizers;
import nl.pim16aap2.armoredElytra.lib.semver4j.internal.range.RangeProcessorPipeline;
import nl.pim16aap2.armoredElytra.lib.semver4j.internal.range.processor.AllVersionsProcessor;
import nl.pim16aap2.armoredElytra.lib.semver4j.internal.range.processor.CaretProcessor;
import nl.pim16aap2.armoredElytra.lib.semver4j.internal.range.processor.HyphenProcessor;
import nl.pim16aap2.armoredElytra.lib.semver4j.internal.range.processor.IvyProcessor;
import nl.pim16aap2.armoredElytra.lib.semver4j.internal.range.processor.TildeProcessor;
import nl.pim16aap2.armoredElytra.lib.semver4j.internal.range.processor.XRangeProcessor;
import org.jspecify.annotations.NullMarked;

@NullMarked
class RangesString {
    private static final Pattern splitterPattern = Pattern.compile("(\\s*)([<>]?=?)\\s*");
    private static final Pattern comparatorPattern = Pattern.compile(Tokenizers.COMPARATOR);
    private static final RangeProcessorPipeline rangeProcessorPipeline = RangeProcessorPipeline.startWith(new AllVersionsProcessor()).addProcessor(new IvyProcessor()).addProcessor(new HyphenProcessor()).addProcessor(new CaretProcessor()).addProcessor(new TildeProcessor()).addProcessor(new XRangeProcessor());

    RangesString() {
    }

    RangesList get(String range) {
        String[] rangeSections;
        RangesList rangesList = new RangesList();
        range = range.trim();
        for (String rangeSection : rangeSections = range.split("\\|\\|")) {
            rangeSection = RangesString.stripWhitespacesBetweenRangeOperator(rangeSection);
            rangeSection = RangesString.applyProcessors(rangeSection);
            List<Range> ranges = RangesString.addRanges(rangeSection);
            rangesList.add(ranges);
        }
        return rangesList;
    }

    private static String stripWhitespacesBetweenRangeOperator(String rangeSection) {
        Matcher matcher = splitterPattern.matcher(rangeSection);
        return matcher.replaceAll("$1$2").trim();
    }

    private static String applyProcessors(String range) {
        return rangeProcessorPipeline.process(range);
    }

    private static List<Range> addRanges(String range) {
        String[] parsedRanges;
        ArrayList<Range> ranges = new ArrayList<Range>();
        for (String parsedRange : parsedRanges = range.split("\\s+")) {
            Matcher matcher = comparatorPattern.matcher(parsedRange);
            if (!matcher.matches()) continue;
            String rangeOperator = matcher.group(1);
            String version = matcher.group(2);
            ranges.add(new Range(version, Range.RangeOperator.value(rangeOperator)));
        }
        return ranges;
    }
}

