/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.armoredElytra.lib.semver4j.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import nl.pim16aap2.armoredElytra.lib.semver4j.Semver;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class Modifier {
    private static final String FULL_FORMAT = "%d.%d.%d";
    private static final String MAJOR_FORMAT = "%d.0.0";
    private static final String MAJOR_MINOR_FORMAT = "%d.%d.0";

    private Modifier() {
    }

    public static Semver nextMajor(Semver version) {
        int nextMajor = version.getMajor();
        if (version.getMinor() != 0 || version.getPatch() != 0 || version.getPreRelease().isEmpty()) {
            ++nextMajor;
        }
        String newVersion = Modifier.createFullVersion(version, String.format(Locale.ROOT, MAJOR_FORMAT, nextMajor), Collections.emptyList());
        return new Semver(newVersion);
    }

    public static Semver withIncMajor(Semver version, int number) {
        String newVersion = Modifier.createFullVersion(version, String.format(Locale.ROOT, FULL_FORMAT, version.getMajor() + number, version.getMinor(), version.getPatch()), version.getPreRelease());
        return new Semver(newVersion);
    }

    public static Semver nextMinor(Semver version) {
        int nextMinor = version.getMinor();
        if (version.getPatch() != 0 || version.getPreRelease().isEmpty()) {
            ++nextMinor;
        }
        String newVersion = Modifier.createFullVersion(version, String.format(Locale.ROOT, MAJOR_MINOR_FORMAT, version.getMajor(), nextMinor), Collections.emptyList());
        return new Semver(newVersion);
    }

    public static Semver withIncMinor(Semver version, int number) {
        String newVersion = Modifier.createFullVersion(version, String.format(Locale.ROOT, FULL_FORMAT, version.getMajor(), version.getMinor() + number, version.getPatch()), version.getPreRelease());
        return new Semver(newVersion);
    }

    public static Semver nextPatch(Semver version) {
        int newPatch = version.getPatch();
        if (version.getPreRelease().isEmpty()) {
            ++newPatch;
        }
        String newVersion = Modifier.createFullVersion(version, String.format(Locale.ROOT, FULL_FORMAT, version.getMajor(), version.getMinor(), newPatch), Collections.emptyList());
        return new Semver(newVersion);
    }

    public static Semver withIncPatch(Semver version, int number) {
        String newVersion = Modifier.createFullVersion(version, String.format(Locale.ROOT, FULL_FORMAT, version.getMajor(), version.getMinor(), version.getPatch() + number), version.getPreRelease());
        return new Semver(newVersion);
    }

    public static Semver withPreRelease(Semver version, String preRelease) {
        List<String> newPreRelease = Arrays.asList(preRelease.split("\\."));
        String newVersion = Modifier.createFullVersion(version, String.format(Locale.ROOT, FULL_FORMAT, version.getMajor(), version.getMinor(), version.getPatch()), newPreRelease);
        return new Semver(newVersion);
    }

    public static Semver withBuild(Semver version, String build) {
        List<String> newBuild = Arrays.asList(build.split("\\."));
        String newVersion = Modifier.createFullVersion(String.format(Locale.ROOT, FULL_FORMAT, version.getMajor(), version.getMinor(), version.getPatch()), version.getPreRelease(), newBuild);
        return new Semver(newVersion);
    }

    public static Semver withClearedPreRelease(Semver version) {
        String newVersion = Modifier.createFullVersion(version, String.format(Locale.ROOT, FULL_FORMAT, version.getMajor(), version.getMinor(), version.getPatch()), Collections.emptyList());
        return new Semver(newVersion);
    }

    public static Semver withClearedBuild(Semver version) {
        String newVersion = Modifier.createFullVersion(String.format(Locale.ROOT, FULL_FORMAT, version.getMajor(), version.getMinor(), version.getPatch()), version.getPreRelease(), Collections.emptyList());
        return new Semver(newVersion);
    }

    public static Semver withClearedPreReleaseAndBuild(Semver version) {
        String newVersion = String.format(Locale.ROOT, FULL_FORMAT, version.getMajor(), version.getMinor(), version.getPatch());
        return new Semver(newVersion);
    }

    private static String createFullVersion(Semver version, String main, List<String> preRelease) {
        return Modifier.createFullVersion(main, preRelease, version.getBuild());
    }

    private static String createFullVersion(String main, List<String> preRelease, List<String> build) {
        StringBuilder stringBuilder = new StringBuilder(main);
        if (!preRelease.isEmpty()) {
            stringBuilder.append("-");
            for (String s : preRelease) {
                stringBuilder.append(s).append(".");
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        if (!build.isEmpty()) {
            stringBuilder.append("+");
            for (String s : build) {
                stringBuilder.append(s).append(".");
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }
}

