/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.armoredElytra.nbtEditor;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import nl.pim16aap2.armoredElytra.ArmoredElytra;
import nl.pim16aap2.armoredElytra.nbtEditor.DurabilityManager;
import nl.pim16aap2.armoredElytra.nbtEditor.NBTEditor;
import nl.pim16aap2.armoredElytra.util.ArmorTier;
import nl.pim16aap2.armoredElytra.util.ConfigLoader;
import nl.pim16aap2.armoredElytra.util.EnchantmentContainer;
import nl.pim16aap2.armoredElytra.util.itemInput.ElytraInput;
import nl.pim16aap2.armoredElytra.util.itemInput.InputAction;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.LeatherArmorMeta;

public class ArmoredElytraBuilder {
    private final NBTEditor nbtEditor;
    private final DurabilityManager durabilityManager;
    private final ConfigLoader config;
    private final ArmoredElytra plugin;

    public ArmoredElytraBuilder(NBTEditor nbtEditor, DurabilityManager durabilityManager, ConfigLoader config, ArmoredElytra plugin) {
        this.nbtEditor = nbtEditor;
        this.durabilityManager = durabilityManager;
        this.config = config;
        this.plugin = plugin;
    }

    public IStep0 newBuilder(HumanEntity player) {
        return new Builder(player, this.nbtEditor, this.durabilityManager, this.config, this.plugin);
    }

    @Nullable
    public ItemStack repair(HumanEntity player, ItemStack armoredElytra, ItemStack repairItems, @Nullable String name) {
        return this.newBuilder(player).ofElytra(armoredElytra).repair(repairItems.getAmount()).withName(name).build();
    }

    @Nullable
    public ItemStack enchant(HumanEntity player, ItemStack armoredElytra, ItemStack sourceItem, @Nullable String name) {
        EnchantmentContainer enchantments = EnchantmentContainer.getEnchantmentsOf(sourceItem, this.plugin);
        if (enchantments.isEmpty()) {
            return null;
        }
        return this.newBuilder(player).ofElytra(armoredElytra).addEnchantments(enchantments).withName(name).build();
    }

    @Nullable
    public ItemStack handleInput(HumanEntity player, ElytraInput input) {
        if (input.isBlocked()) {
            return null;
        }
        IStep1 builder = this.newBuilder(player).ofElytra(input.elytra());
        IStep2 withAction = switch (input.inputAction()) {
            case InputAction.CREATE -> builder.combineWith(input.combinedWith(), input.newArmorTier());
            case InputAction.ENCHANT -> {
                EnchantmentContainer container = EnchantmentContainer.getEnchantmentsOf(input.combinedWith(), this.plugin);
                if (container.isEmpty()) {
                    yield null;
                }
                yield builder.addEnchantments(container);
            }
            case InputAction.RENAME -> builder.skipStep();
            case InputAction.REPAIR -> builder.repair(input.combinedWith());
            case InputAction.UPGRADE -> builder.upgradeToTier(input.newArmorTier());
            default -> throw new IllegalStateException("Unexpected input action: '" + String.valueOf((Object)input.inputAction()) + "'");
        };
        return withAction == null ? null : withAction.withName(input.name()).build();
    }

    public ItemStack combine(@Nullable HumanEntity player, ItemStack elytra, ItemStack combiner, ArmorTier armorTier, @Nullable String name) {
        return this.newBuilder(player).ofElytra(elytra).combineWith(combiner, armorTier).withName(name).build();
    }

    public ItemStack combine(@Nullable HumanEntity player, ItemStack elytra, ItemStack combiner, @Nullable String name) {
        return this.newBuilder(player).ofElytra(elytra).combineWith(combiner).withName(name).build();
    }

    public ItemStack newArmoredElytra(@Nullable HumanEntity player, ArmorTier armorTier) {
        return this.newBuilder(player).newItem(armorTier).build();
    }

    private static final class Builder
    implements IStep0,
    IStep1,
    IStep2 {
        private static final Color DEFAULT_LEATHER_COLOR = Bukkit.getServer().getItemFactory().getDefaultLeatherColor();
        private final NBTEditor nbtEditor;
        private final DurabilityManager durabilityManager;
        private final ConfigLoader config;
        private final ArmoredElytra plugin;
        @Nullable
        private final HumanEntity player;
        private ItemStack newArmoredElytra;
        private EnchantmentContainer combinedEnchantments;
        private ArmorTier currentArmorTier;
        private int durability;
        @Nullable
        private ArmorTier newArmorTier;
        @Nullable
        private String name;
        @Nullable
        private List<String> lore;
        @Nullable
        private Color color;
        @Nullable
        private ItemStack otherItem;
        @Nullable
        private Boolean isUnbreakable = null;

        private Builder(@Nullable HumanEntity player, NBTEditor nbtEditor, DurabilityManager durabilityManager, ConfigLoader config, ArmoredElytra plugin) {
            this.player = player;
            this.nbtEditor = nbtEditor;
            this.durabilityManager = durabilityManager;
            this.config = config;
            this.plugin = plugin;
        }

        @Override
        public ItemStack build() {
            ArmorTier armorTier = this.newArmorTier = this.newArmorTier == null ? this.currentArmorTier : this.newArmorTier;
            if (this.player != null && !this.plugin.playerHasCraftPerm(this.player, this.newArmorTier)) {
                return null;
            }
            this.name = this.name == null ? this.plugin.getArmoredElytraName(this.newArmorTier) : this.name;
            this.lore = this.lore == null ? this.plugin.getElytraLore(this.newArmorTier) : this.lore;
            this.isUnbreakable = this.isUnbreakable == null ? this.config.unbreakable() : this.isUnbreakable.booleanValue();
            ItemStack output = this.nbtEditor.addArmorNBTTags(this.newArmoredElytra, this.newArmorTier, this.otherItem, this.isUnbreakable, this.name, this.lore, this.color);
            this.durabilityManager.setDurability(output, this.durability, this.newArmorTier);
            this.combinedEnchantments.applyEnchantments(output);
            output.setAmount(1);
            return output;
        }

        @Override
        public IStep2 withName(@Nullable String name) {
            this.name = name;
            return this;
        }

        @Override
        public IStep2 withColor(@Nullable Color color) {
            this.color = color;
            return this;
        }

        @Override
        public IStep2 withLore(@Nullable List<String> lore) {
            this.lore = lore;
            return this;
        }

        @Override
        public IStep2 unbreakable(boolean isUnbreakable) {
            this.isUnbreakable = isUnbreakable;
            return this;
        }

        @Override
        public IStep2 repair(int count) {
            if (this.currentArmorTier == ArmorTier.NONE) {
                throw new IllegalArgumentException("Non-armored elytras cannot be repaired!");
            }
            this.durability = this.durabilityManager.getRepairedDurability(this.newArmoredElytra, count, this.currentArmorTier);
            return this;
        }

        @Override
        public IStep2 addEnchantments(EnchantmentContainer enchantmentContainer) {
            this.combinedEnchantments.merge(enchantmentContainer);
            return this;
        }

        @Override
        public IStep2 addEnchantments(ItemStack sourceItem) {
            return this.addEnchantments(EnchantmentContainer.getEnchantmentsOf(sourceItem, this.plugin));
        }

        @Override
        public IStep2 combineWith(ItemStack item, ArmorTier armorTier) {
            if (armorTier == ArmorTier.NONE) {
                throw new IllegalArgumentException("Cannot combine an elytra with a non-armor item!");
            }
            if (this.currentArmorTier != ArmorTier.NONE) {
                throw new IllegalArgumentException("An armored elytra cannot be combined with another chest plate!");
            }
            this.otherItem = item;
            this.newArmorTier = armorTier;
            this.withColor(this.getItemColor(this.newArmoredElytra, item));
            this.addEnchantments(item);
            this.durability = this.durabilityManager.getCombinedDurability(this.newArmoredElytra, item, this.currentArmorTier, this.newArmorTier);
            return this;
        }

        @Override
        public IStep2 combineWith(ItemStack item) {
            return this.combineWith(item, this.nbtEditor.getArmorTier(item));
        }

        @Override
        public IStep2 upgradeToTier(ArmorTier armorTier) {
            this.newArmorTier = armorTier;
            return this;
        }

        @Override
        public IStep2 skipStep() {
            return this;
        }

        @Override
        public IStep1 ofElytra(ItemStack elytra) {
            if (!elytra.getType().equals((Object)Material.ELYTRA)) {
                throw new IllegalArgumentException("Expected elytra as input, but got: " + String.valueOf(elytra));
            }
            this.newArmoredElytra = new ItemStack(elytra);
            if (this.currentArmorTier == null) {
                this.currentArmorTier = this.nbtEditor.getArmorTierFromElytra(elytra);
            }
            this.combinedEnchantments = EnchantmentContainer.getEnchantmentsOf(this.newArmoredElytra, this.plugin);
            this.durability = this.durabilityManager.getRealDurability(this.newArmoredElytra, this.currentArmorTier);
            return this;
        }

        @Override
        public IStep2 newItem(ArmorTier armorTier) {
            this.currentArmorTier = this.newArmorTier = armorTier;
            this.ofElytra(new ItemStack(Material.ELYTRA));
            return this;
        }

        @Nullable
        private Color getItemColor(ItemStack itemA, ItemStack itemB) {
            Color colorA = this.getItemColor(itemA);
            if (colorA != null && !colorA.equals((Object)DEFAULT_LEATHER_COLOR)) {
                return colorA;
            }
            Color colorB = this.getItemColor(itemB);
            return colorB != null ? colorB : colorA;
        }

        @Nullable
        private Color getItemColor(ItemStack itemStack) {
            if (itemStack.getType() == Material.ELYTRA) {
                return this.nbtEditor.getColorOfArmoredElytra(itemStack);
            }
            if (!itemStack.hasItemMeta() || !(itemStack.getItemMeta() instanceof LeatherArmorMeta)) {
                return null;
            }
            return ((LeatherArmorMeta)itemStack.getItemMeta()).getColor();
        }
    }

    public static interface IStep0 {
        public IStep1 ofElytra(ItemStack var1);

        public IStep2 newItem(ArmorTier var1);
    }

    public static interface IStep1 {
        public IStep2 repair(int var1);

        default public IStep2 repair(@Nullable ItemStack repairItems) {
            return this.repair(Objects.requireNonNull(repairItems, "Repair ItemStack cannot be null!").getAmount());
        }

        public IStep2 addEnchantments(EnchantmentContainer var1);

        public IStep2 addEnchantments(ItemStack var1);

        public IStep2 combineWith(ItemStack var1, ArmorTier var2);

        public IStep2 combineWith(ItemStack var1);

        public IStep2 upgradeToTier(ArmorTier var1);

        public IStep2 skipStep();
    }

    public static interface IStep2 {
        public IStep2 withName(@Nullable String var1);

        public IStep2 withColor(@Nullable Color var1);

        public IStep2 withLore(@Nullable List<String> var1);

        public IStep2 unbreakable(boolean var1);

        public ItemStack build();
    }
}

