/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.armoredElytra.nbtEditor;

import java.lang.reflect.Constructor;
import java.util.List;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.ToDoubleFunction;
import nl.pim16aap2.armoredElytra.lib.semver4j.Semver;
import nl.pim16aap2.armoredElytra.util.ArmorTier;
import nl.pim16aap2.armoredElytra.util.AttributeUtil;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.inventory.meta.ItemMeta;

abstract class AttributeModifierManager {
    private static final List<AttributeCreator> ATTRIBUTE_SETTERS = List.of(new AttributeCreator(AttributeUtil.ATTRIBUTE_ARMOR, ArmorTier::getArmor, AttributeModifierManager::newGenericArmorModifier), new AttributeCreator(AttributeUtil.ATTRIBUTE_ARMOR_TOUGHNESS, ArmorTier::getToughness, AttributeModifierManager::newGenericArmorToughnessModifier), new AttributeCreator(AttributeUtil.ATTRIBUTE_KNOCKBACK_RESISTANCE, ArmorTier::getKnockbackResistance, AttributeModifierManager::newGenericKnockbackResistanceModifier));

    AttributeModifierManager() {
    }

    static AttributeModifierManager create(Semver version) {
        if (version.isGreaterThanOrEqualTo(Semver.of(1, 21, 0))) {
            return new AttributeModifierManagerNamespacedKey();
        }
        return new AttributeModifierManagerUUID();
    }

    public final void overwriteAttributeModifiers(ItemMeta meta, ArmorTier armorTier) {
        ATTRIBUTE_SETTERS.forEach(setter -> setter.apply(this, meta, armorTier));
    }

    protected abstract AttributeModifier newGenericArmorModifier(double var1);

    protected abstract AttributeModifier newGenericArmorToughnessModifier(double var1);

    protected abstract AttributeModifier newGenericKnockbackResistanceModifier(double var1);

    private static final class AttributeModifierManagerNamespacedKey
    extends AttributeModifierManager {
        private static final Constructor<AttributeModifier> ATTRIBUTE_MODIFIER_CONSTRUCTOR = AttributeModifierManagerNamespacedKey.findAttributeModifierConstructor();

        private AttributeModifierManagerNamespacedKey() {
        }

        @Override
        protected AttributeModifier newGenericArmorModifier(double value) {
            return AttributeModifierManagerNamespacedKey.addNumberToChestModifier(AttributeUtil.ATTRIBUTE_ARMOR.getKey(), value);
        }

        @Override
        protected AttributeModifier newGenericArmorToughnessModifier(double value) {
            return AttributeModifierManagerNamespacedKey.addNumberToChestModifier(AttributeUtil.ATTRIBUTE_ARMOR_TOUGHNESS.getKey(), value);
        }

        @Override
        protected AttributeModifier newGenericKnockbackResistanceModifier(double value) {
            return AttributeModifierManagerNamespacedKey.addNumberToChestModifier(AttributeUtil.ATTRIBUTE_KNOCKBACK_RESISTANCE.getKey(), value);
        }

        private static AttributeModifier addNumberToChestModifier(NamespacedKey key, double value) {
            try {
                return ATTRIBUTE_MODIFIER_CONSTRUCTOR.newInstance(key, value, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlotGroup.CHEST);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("Could not create a new AttributeModifier{ key: " + String.valueOf(key) + ", value: " + value + " }", e);
            }
        }

        private static Constructor<AttributeModifier> findAttributeModifierConstructor() {
            try {
                return AttributeModifier.class.getDeclaredConstructor(NamespacedKey.class, Double.TYPE, AttributeModifier.Operation.class, EquipmentSlotGroup.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Could not find the constructor of AttributeModifier.", e);
            }
        }
    }

    private static final class AttributeModifierManagerUUID
    extends AttributeModifierManager {
        private static final UUID UUID_GENERIC_ARMOR = UUID.fromString("afa5a6a1-f3bc-4cbb-aeb4-13383b5fcd5a");
        private static final UUID UUID_GENERIC_ARMOR_TOUGHNESS = UUID.fromString("a334b502-88c0-47ec-9adc-738036bf3e27");
        private static final UUID UUID_GENERIC_KNOCKBACK_RESISTANCE = UUID.fromString("4a66cb1c-f606-4baf-b04b-6fb5d6bcfb88");

        private AttributeModifierManagerUUID() {
        }

        @Override
        protected AttributeModifier newGenericArmorModifier(double value) {
            return this.addNumberToChestModifier(UUID_GENERIC_ARMOR, AttributeUtil.ATTRIBUTE_ARMOR, value);
        }

        @Override
        protected AttributeModifier newGenericArmorToughnessModifier(double value) {
            return this.addNumberToChestModifier(UUID_GENERIC_ARMOR_TOUGHNESS, AttributeUtil.ATTRIBUTE_ARMOR_TOUGHNESS, value);
        }

        @Override
        protected AttributeModifier newGenericKnockbackResistanceModifier(double value) {
            return this.addNumberToChestModifier(UUID_GENERIC_KNOCKBACK_RESISTANCE, AttributeUtil.ATTRIBUTE_KNOCKBACK_RESISTANCE, value);
        }

        private AttributeModifier addNumberToChestModifier(UUID key, Attribute attribute, double value) {
            return new AttributeModifier(key, attribute.getKey().getKey(), value, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlot.CHEST);
        }
    }

    private record AttributeCreator(Attribute attribute, ToDoubleFunction<ArmorTier> valuePredicate, BiFunction<AttributeModifierManager, Double, AttributeModifier> creator) {
        public void apply(AttributeModifierManager manager, ItemMeta meta, ArmorTier armorTier) {
            meta.removeAttributeModifier(this.attribute);
            double value = this.valuePredicate.applyAsDouble(armorTier);
            meta.addAttributeModifier(this.attribute, this.creator.apply(manager, value));
        }
    }
}

