/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.armoredElytra.nbtEditor;

import javax.annotation.Nullable;
import nl.pim16aap2.armoredElytra.nbtEditor.NBTEditor;
import nl.pim16aap2.armoredElytra.util.ArmorTier;
import nl.pim16aap2.armoredElytra.util.ConfigLoader;
import nl.pim16aap2.armoredElytra.util.Util;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class DurabilityManager {
    private static final int ELYTRA_MAX_DURABILITY = Material.ELYTRA.getMaxDurability();
    private final int[] repairAmounts = new int[ArmorTier.values().length];
    private final int[] maxDurabilities = new int[ArmorTier.values().length];
    private final NBTEditor nbtEditor;
    private final ConfigLoader config;

    public DurabilityManager(NBTEditor nbtEditor, ConfigLoader config) {
        this.nbtEditor = nbtEditor;
        this.config = config;
        this.init();
    }

    public int setCombinedDurability(ItemStack armoredElytraOut, ItemStack armoredElytraIn, ItemStack other, ArmorTier currentTier, ArmorTier targetTier) {
        if (this.nbtEditor.isUnbreakable(armoredElytraIn)) {
            return 0;
        }
        int combinedDurability = this.getCombinedDurability(armoredElytraIn, other, currentTier, targetTier);
        this.setDurability(armoredElytraOut, combinedDurability, targetTier);
        return combinedDurability;
    }

    public int getCombinedDurability(ItemStack armoredElytra, ItemStack other, ArmorTier currentTier, ArmorTier targetTier) {
        if (this.nbtEditor.isUnbreakable(armoredElytra)) {
            return 0;
        }
        ArmorTier otherTier = this.nbtEditor.getArmorTierFromElytra(other);
        int currentMaxDurability = this.getMaxDurability(currentTier);
        int targetMaxDurability = this.getMaxDurability(targetTier);
        int otherMaxDurability = otherTier != ArmorTier.NONE ? this.getMaxDurability(otherTier) : (int)other.getType().getMaxDurability();
        int otherDurability = other.getType().equals((Object)Material.ELYTRA) ? this.getRealDurability(other, null) : this.getItemDurability(other);
        int currentDurability = this.getRealDurability(armoredElytra, currentTier);
        int combinedDurability = targetMaxDurability - (otherMaxDurability - otherDurability) - (currentMaxDurability - currentDurability);
        return Util.between(combinedDurability, 0, targetMaxDurability);
    }

    public int removeDurability(ItemStack armoredElytra, int durabilityLoss, @Nullable ArmorTier providedTier) {
        if (this.nbtEditor.isUnbreakable(armoredElytra)) {
            return 0;
        }
        ArmorTier currentTier = providedTier == null ? this.nbtEditor.getArmorTierFromElytra(armoredElytra) : providedTier;
        int currentDurability = this.getRealDurability(armoredElytra, currentTier);
        int newDurability = Util.between(currentDurability + durabilityLoss, 0, this.getMaxDurability(currentTier));
        this.setDurability(armoredElytra, newDurability, providedTier);
        return newDurability;
    }

    public int getFullRepairItemCount(ItemStack armoredElytra, @Nullable ArmorTier providedTier) {
        if (this.nbtEditor.isUnbreakable(armoredElytra)) {
            return 0;
        }
        ArmorTier currentTier = providedTier == null ? this.nbtEditor.getArmorTierFromElytra(armoredElytra) : providedTier;
        int currentDurability = this.getRealDurability(armoredElytra, currentTier);
        return (int)Math.ceil((float)currentDurability / (float)this.getRepairAmount(currentTier));
    }

    public int getRepairedDurability(ItemStack armoredElytra, int repairCount, @Nullable ArmorTier providedTier) {
        if (this.nbtEditor.isUnbreakable(armoredElytra)) {
            return 0;
        }
        ArmorTier currentTier = providedTier == null ? this.nbtEditor.getArmorTierFromElytra(armoredElytra) : providedTier;
        int restoredDurability = repairCount * this.getRepairAmount(currentTier);
        int currentDurability = this.getRealDurability(armoredElytra, currentTier);
        return Math.max(0, currentDurability - restoredDurability);
    }

    public int getRealDurability(ItemStack item, @Nullable ArmorTier providedTier) {
        ArmorTier currentTier;
        ArmorTier armorTier = currentTier = providedTier == null ? this.nbtEditor.getArmorTierFromElytra(item) : providedTier;
        if (currentTier == ArmorTier.NONE) {
            return this.getItemDurability(item);
        }
        if (this.nbtEditor.isUnbreakable(item)) {
            return 0;
        }
        int realDurability = this.nbtEditor.getRealDurability(item, currentTier);
        if (this.getItemDurability(item) == 0 && realDurability > 0) {
            this.nbtEditor.updateDurability(item, 0, 0);
            return 0;
        }
        return realDurability == -1 ? this.upgradeArmoredElytraToDurability(item, currentTier) : realDurability;
    }

    public void setDurability(ItemStack item, int durability, @Nullable ArmorTier providedTier) {
        if (this.nbtEditor.isUnbreakable(item)) {
            return;
        }
        ArmorTier currentTier = providedTier == null ? this.nbtEditor.getArmorTierFromElytra(item) : providedTier;
        int oldMaxDurability = this.getMaxDurability(currentTier);
        int rawDurability = this.getRemappedDurability(durability, oldMaxDurability, ELYTRA_MAX_DURABILITY);
        this.nbtEditor.updateDurability(item, durability, rawDurability);
    }

    private int upgradeArmoredElytraToDurability(ItemStack armoredElytra, ArmorTier currentTier) {
        int maxDurability = this.getMaxDurability(currentTier);
        int rawDurability = this.getItemDurability(armoredElytra);
        int realDurability = this.getRemappedDurability(rawDurability, ELYTRA_MAX_DURABILITY, maxDurability);
        this.nbtEditor.updateDurability(armoredElytra, realDurability, rawDurability);
        return realDurability;
    }

    private int calculateMaxDurability(ArmorTier armorTier) {
        if (armorTier == ArmorTier.NONE || !this.config.useTierDurability()) {
            return ELYTRA_MAX_DURABILITY;
        }
        return ArmorTier.getMaxDurability(armorTier);
    }

    public boolean isBroken(int durability, ArmorTier armorTier) {
        return durability >= this.getMaxDurability(armorTier);
    }

    public boolean isBroken(ItemStack armoredElytra, @Nullable ArmorTier armorTier) {
        int realDurability = this.getRealDurability(armoredElytra, armorTier);
        if (realDurability == 0) {
            return false;
        }
        return this.isBroken(realDurability, armorTier == null ? this.nbtEditor.getArmorTierFromElytra(armoredElytra) : armorTier);
    }

    private int getMaxDurability(ArmorTier armorTier) {
        return this.maxDurabilities[armorTier.ordinal()];
    }

    private int getRepairAmount(ArmorTier armorTier) {
        return this.repairAmounts[armorTier.ordinal()];
    }

    private int getRemappedDurability(int durability, int oldMax, int newMax) {
        int scaledDurability;
        if (durability == 0) {
            return 0;
        }
        if (oldMax == newMax) {
            scaledDurability = durability;
        } else {
            float relativeDurability = (float)durability / (float)oldMax;
            scaledDurability = (int)Math.ceil(relativeDurability * (float)newMax);
        }
        return Util.between(scaledDurability, 0, newMax);
    }

    private void init() {
        this.repairAmounts[0] = 0;
        this.maxDurabilities[0] = ELYTRA_MAX_DURABILITY;
        ArmorTier[] armorTiers = ArmorTier.values();
        for (int idx = 1; idx < armorTiers.length; ++idx) {
            int maxDurability;
            ArmorTier armorTier = armorTiers[idx];
            this.maxDurabilities[idx] = maxDurability = this.calculateMaxDurability(armorTier);
            int steps = Math.max(1, this.config.getFullRepairItemCount(armorTier));
            this.repairAmounts[idx] = (int)Math.ceil((float)maxDurability / (float)steps);
        }
    }

    private int getItemDurability(ItemStack item) {
        return item.getDurability();
    }
}

