/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.armoredElytra.nbtEditor;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nl.pim16aap2.armoredElytra.ArmoredElytra;
import nl.pim16aap2.armoredElytra.lib.semver4j.Semver;
import nl.pim16aap2.armoredElytra.nbtEditor.AttributeModifierManager;
import nl.pim16aap2.armoredElytra.nbtEditor.TrimEditor;
import nl.pim16aap2.armoredElytra.util.ArmorTier;
import nl.pim16aap2.armoredElytra.util.AttributeUtil;
import nl.pim16aap2.armoredElytra.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class NBTEditor {
    public static final boolean HAS_FIRE_RESISTANT_METHOD = ArmoredElytra.SERVER_VERSION.isGreaterThanOrEqualTo(Semver.of(1, 20, 5));
    private static final NamespacedKey ARMOR_TIER_KEY = new NamespacedKey((Plugin)ArmoredElytra.getInstance(), "armor_tier_level");
    private static final NamespacedKey ARMOR_COLOR_KEY = new NamespacedKey((Plugin)ArmoredElytra.getInstance(), "armored_elytra_color");
    private static final NamespacedKey DURABILITY_KEY = new NamespacedKey((Plugin)ArmoredElytra.getInstance(), "armored_elytra_durability");
    public static final int HAS_NO_CUSTOM_DURABILITY = -1;
    private final AttributeModifierManager attributeModifierManager = AttributeModifierManager.create(ArmoredElytra.SERVER_VERSION);
    @Nullable
    private final TrimEditor trimEditor = NBTEditor.newTrimEditor();

    public static <P, C> boolean hasPdcWithKey(@Nullable ItemStack item, @Nonnull NamespacedKey key, @Nonnull PersistentDataType<P, C> type) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        return container.has(key, type);
    }

    public int getRealDurability(ItemStack itemStack, @Nullable ArmorTier providedTier) {
        ArmorTier armorTier;
        ItemMeta meta = itemStack.getItemMeta();
        ArmorTier armorTier2 = armorTier = providedTier == null ? this.getArmorTier(meta) : providedTier;
        if (armorTier == ArmorTier.NONE) {
            return -1;
        }
        Integer realDurability = (Integer)Objects.requireNonNull(meta, "Meta cannot be null for armored elytras!").getPersistentDataContainer().get(DURABILITY_KEY, PersistentDataType.INTEGER);
        return realDurability == null ? -1 : realDurability;
    }

    public void updateDurability(ItemStack itemStack, int realDurability, int displayDurability) {
        int fixedDisplayDurability;
        ItemMeta meta = NBTEditor.getOrCreateItemMeta(itemStack);
        meta.getPersistentDataContainer().set(DURABILITY_KEY, PersistentDataType.INTEGER, (Object)realDurability);
        int n = fixedDisplayDurability = realDurability > 0 ? Math.max(1, displayDurability) : displayDurability;
        if (meta instanceof Damageable) {
            Damageable damageable = (Damageable)meta;
            damageable.setDamage(fixedDisplayDurability);
        }
        itemStack.setItemMeta(meta);
    }

    private void copyArmorTrim(ItemMeta elytraMeta, ItemStack chestplate) {
        if (this.trimEditor == null) {
            return;
        }
        this.trimEditor.copyArmorTrim(elytraMeta, chestplate);
    }

    public ItemStack addArmorNBTTags(ItemStack item, ArmorTier armorTier, @Nullable ItemStack otherItem, boolean unbreakable, String name, @Nullable List<String> lore, @Nullable Color color) {
        if (armorTier == null || armorTier == ArmorTier.NONE) {
            return new ItemStack(item);
        }
        ItemStack ret = new ItemStack(item);
        ItemMeta meta = NBTEditor.getOrCreateItemMeta(ret);
        if (Util.isChestPlate(otherItem)) {
            this.copyArmorTrim(meta, otherItem);
        }
        meta.getPersistentDataContainer().set(ARMOR_TIER_KEY, PersistentDataType.INTEGER, (Object)ArmorTier.getTierID(armorTier));
        if (color != null && armorTier == ArmorTier.LEATHER) {
            meta.getPersistentDataContainer().set(ARMOR_COLOR_KEY, PersistentDataType.INTEGER, (Object)color.asRGB());
        }
        this.attributeModifierManager.overwriteAttributeModifiers(meta, armorTier);
        meta.setUnbreakable(unbreakable);
        meta.setDisplayName(name);
        if (lore != null) {
            meta.setLore(lore);
        }
        if (armorTier == ArmorTier.NETHERITE && HAS_FIRE_RESISTANT_METHOD) {
            meta.setFireResistant(true);
        }
        if (!ret.setItemMeta(meta)) {
            throw new IllegalStateException("Failed to set item meta '" + String.valueOf(meta) + "' for item: " + String.valueOf(ret));
        }
        return ret;
    }

    ArmorTier getArmorTier(@Nullable ItemMeta meta) {
        if (meta == null || !meta.hasAttributeModifiers()) {
            return ArmorTier.NONE;
        }
        Integer tierID = (Integer)meta.getPersistentDataContainer().get(ARMOR_TIER_KEY, PersistentDataType.INTEGER);
        if (tierID != null) {
            return ArmorTier.getArmorTierFromID(tierID);
        }
        Collection attributeModifiers = meta.getAttributeModifiers(AttributeUtil.ATTRIBUTE_ARMOR);
        if (attributeModifiers == null) {
            return ArmorTier.NONE;
        }
        for (AttributeModifier attributeModifier : attributeModifiers) {
            ArmorTier armorTier = ArmorTier.getArmorTierFromArmor((int)attributeModifier.getAmount());
            if (armorTier == ArmorTier.NONE) continue;
            return armorTier;
        }
        return ArmorTier.NONE;
    }

    private boolean isElytra(@Nullable ItemStack item) {
        return item != null && item.getType() == Material.ELYTRA;
    }

    public ArmorTier getArmorTier(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            return ArmorTier.NONE;
        }
        if (Util.isChestPlate(itemStack)) {
            return Util.armorToTier(itemStack);
        }
        return this.getArmorTier(itemStack.getItemMeta());
    }

    public ArmorTier getArmorTierFromElytra(@Nullable ItemStack elytra) {
        if (!this.isElytra(elytra)) {
            return ArmorTier.NONE;
        }
        return this.getArmorTier(elytra.getItemMeta());
    }

    public boolean isUnbreakable(@Nullable ItemStack item) {
        ItemMeta meta = item == null ? null : item.getItemMeta();
        return meta != null && meta.isUnbreakable();
    }

    public Color getColorOfArmoredElytra(@Nullable ItemStack item) {
        if (item == null || item.getType() != Material.ELYTRA || !item.hasItemMeta()) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return null;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        if (!container.has(ARMOR_COLOR_KEY, PersistentDataType.INTEGER)) {
            return null;
        }
        Integer rgb = (Integer)container.get(ARMOR_COLOR_KEY, PersistentDataType.INTEGER);
        return rgb == null ? null : Color.fromRGB((int)rgb);
    }

    static ItemMeta getOrCreateItemMeta(ItemStack item) {
        ItemMeta meta;
        ItemMeta itemMeta = meta = item.hasItemMeta() ? item.getItemMeta() : Bukkit.getItemFactory().getItemMeta(item.getType());
        if (meta == null) {
            throw new IllegalArgumentException("Tried to add armor to invalid item: " + String.valueOf(item));
        }
        return meta;
    }

    @Nullable
    private static TrimEditor newTrimEditor() {
        if (!ArmoredElytra.SERVER_VERSION.isGreaterThanOrEqualTo(Semver.of(1, 20, 0))) {
            return null;
        }
        try {
            return new TrimEditor();
        }
        catch (Throwable t) {
            ArmoredElytra.getInstance().myLogger(Level.INFO, "Failed to initialize TrimEditor! Item trimming will be disabled!");
            t.printStackTrace();
            return null;
        }
    }

    public boolean updateFireResistance(@Nullable ItemStack itemStack) {
        if (!HAS_FIRE_RESISTANT_METHOD) {
            throw new IllegalStateException("Trying to set fire resistance on a version that does not support it!");
        }
        if (!this.isElytra(itemStack)) {
            return false;
        }
        ItemMeta meta = itemStack.getItemMeta();
        if (meta == null) {
            return false;
        }
        ArmorTier armorTier = this.getArmorTier(meta);
        if (armorTier != ArmorTier.NETHERITE) {
            return false;
        }
        if (meta.isFireResistant()) {
            return false;
        }
        meta.setFireResistant(true);
        itemStack.setItemMeta(meta);
        return true;
    }
}

