/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.armoredElytra.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import nl.pim16aap2.armoredElytra.ArmoredElytra;
import nl.pim16aap2.armoredElytra.util.ArmorTier;
import nl.pim16aap2.armoredElytra.util.ConfigOption;
import nl.pim16aap2.armoredElytra.util.EnchantmentParser;
import nl.pim16aap2.armoredElytra.util.Util;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;

public class ConfigLoader {
    private static final String HEADER = "Config file for ArmoredElytra. Don't forget to make a backup before making changes!";
    private final ArmoredElytra plugin;
    private final EnchantmentParser enchantmentParser;
    private final int[] repairCounts = new int[ArmorTier.values().length];
    private final ArrayList<ConfigOption<?>> configOptionsList = new ArrayList();
    private boolean allowStats;
    private boolean unbreakable;
    private boolean enableDebug;
    private String languageFile;
    private boolean uninstallMode;
    private boolean checkForUpdates;
    private boolean noFlightDurability;
    private boolean useTierDurability;
    private LinkedHashSet<Enchantment> allowedEnchantments;
    private List<List<Enchantment>> mutuallyExclusiveEnchantments;
    private boolean craftingInSmithingTable;
    private boolean allowUpgradeToNetherite;
    private boolean bypassWearPerm;
    private boolean bypassCraftPerm;
    private boolean allowRenaming;
    private boolean allowAddingEnchantments;

    public ConfigLoader(ArmoredElytra plugin) {
        this.plugin = plugin;
        this.enchantmentParser = new EnchantmentParser(plugin);
        this.makeConfig();
    }

    private void makeConfig() {
        String[] unbreakableComment = new String[]{"Setting this to true will cause armored elytras to be unbreakable.", "Changing this to false will NOT make unbreakable elytras breakable again!"};
        String[] flyDurabilityComment = new String[]{"Setting this to true will cause armored elytras to not lose any durability while flying.", "This is not a permanent option and will affect ALL elytras."};
        String[] useTierDurabilityComment = new String[]{"Use the maximum durability of the armor tier of armored elytras.", "For example, when this is true, a diamond armored elytra would have a durability of 528.", "When this is false, all armored elytras have the maximum durability of a regular elytra."};
        String[] repairComment = new String[]{"Amount of items it takes to fully repair an armored elytra", "Repair cost for every tier of armored elytra in number of items to repair 100%.", "Note that this value cannot be less than 1."};
        String[] enchantmentsComment = new String[]{"List of enchantments that are allowed to be put on an armored elytra.", "If you do not want to allow any enchantments at all, remove them all and add \"NONE\"", "You can find supported enchantments by running the command:", "\"armoredelytra listAvailableEnchantments\" in console", "If you install additional enchantment plugins, you can add their enchantments as well.", "Just add their 'NamespacedKey'. Ask the enchantment plugin dev for more info if you need it."};
        String[] mutuallyExclusiveEnchantmentsComment = new String[]{"The lists of enchantments that are mutually exclusive.", "Each group [] on this list is treated as mutually exclusive, so only one of them can be on an ArmoredElytra.", "The default follows modern vanilla rules by making the different types of protection mutually exclusive.", "If you do not want any enchantments to be mutually exclusive, replace all the entries in this list with \"[]\"", "You can find supported enchantments by running the command:", "\"armoredelytra listAvailableEnchantments\" in console", "If you install additional enchant plugins, you can make their enchantments mutually exclusive as well.", "Just add their 'NamespacedKey'. Ask the enchantment plugin dev for more info if you need it."};
        String[] updateComment = new String[]{"Allow this plugin to check for updates on startup. It will not download new versions on its own!"};
        String[] bStatsComment = new String[]{"Allow this plugin to send (anonymous) stats using bStats. Please consider keeping it enabled.", "It has a negligible impact on performance and more users on stats keeps me more motivated to support this plugin!"};
        String[] debugComment = new String[]{"Print debug messages to console. You will most likely never need this."};
        String[] uninstallComment = new String[]{"Setting this to true will disable this plugin and remove any armored elytras it can find.", "It will check player's inventories and their end chest upon login and any regular chest when it is opened.", "This means it will take a while for all armored elytras to be removed from your server, but it doesn't take up ", "a lot of resources, so you can just leave the plugin enabled and ignore it.", "Please do not forget to MAKE A BACKUP before enabling this option!"};
        String[] languageFileComment = new String[]{"Specify a language file to be used."};
        String[] permissionsComment = new String[]{"Globally bypass permissions for wearing and/or crafting armored elytras.", "Useful if permissions are unavailable."};
        String[] craftingInSmithingTableComment = new String[]{"When enabled, armored elytra creation in anvils is disabled. ", "Instead, you will have to craft them in a smithy. Enchanting/repairing them still works via the anvil."};
        String[] allowUpgradeToNetheriteComment = new String[]{"Whether or not to allow upgrading diamond armored elytras to netherite ones is possible.", "When allowed, you can combine a diamond one with a netherite ingot in a smithing table", "and you'll receive a netherite one."};
        String[] allowRenamingComment = new String[]{"Whether or not to allow renaming of armored elytras in anvils."};
        String[] allowAddingEnchantmentsComment = new String[]{"Allow new enchantments to be added to armored elytras.", "When false, no enchantments can be added to armored elytras, even those on the allowed list.", "When true, only enchantments from the allowed list can be added."};
        List<String> defaultAllowedEnchantments = new ArrayList<String>(Arrays.asList("minecraft:unbreaking", "minecraft:fire_protection", "minecraft:blast_protection", "minecraft:projectile_protection", "minecraft:protection", "minecraft:thorns", "minecraft:binding_curse", "minecraft:vanishing_curse", "minecraft:mending"));
        List defaultMutuallyExclusiveEnchantments = new ArrayList<List<String>>();
        defaultMutuallyExclusiveEnchantments.add(List.of("minecraft:protection", "minecraft:projectile_protection", "minecraft:blast_protection", "minecraft:fire_protection"));
        FileConfiguration config = this.plugin.getConfig();
        this.unbreakable = this.addNewConfigOption(config, "unbreakable", false, unbreakableComment);
        this.noFlightDurability = this.addNewConfigOption(config, "noFlightDurability", false, flyDurabilityComment);
        this.useTierDurability = this.addNewConfigOption(config, "useTierDurability", true, useTierDurabilityComment);
        ArmorTier[] armorTiers = ArmorTier.values();
        for (int idx = 1; idx < armorTiers.length; ++idx) {
            ArmorTier armorTier = armorTiers[idx];
            if (armorTier == ArmorTier.IRON) {
                this.repairCounts[idx] = this.repairCounts[idx - 1];
                continue;
            }
            String[] comment = idx == 1 ? repairComment : null;
            String name = Util.snakeToCamelCase(ArmorTier.getRepairItem(armorTier).name());
            int defaultRepairCount = ArmorTier.getDefaultRepairCount(armorTier);
            this.repairCounts[idx] = this.addNewConfigOption(config, name, defaultRepairCount, comment);
        }
        int armorTierCount = ArmorTier.values().length;
        if (this.repairCounts.length != armorTierCount) {
            throw new IllegalStateException("Incorrect repair counts array size! Expected size " + armorTierCount + " but got size " + this.repairCounts.length);
        }
        this.craftingInSmithingTable = this.addNewConfigOption(config, "craftingInSmithingTable", true, craftingInSmithingTableComment);
        this.allowUpgradeToNetherite = this.addNewConfigOption(config, "allowUpgradeToNetherite", true, allowUpgradeToNetheriteComment);
        defaultAllowedEnchantments = this.addNewConfigOption(config, "allowedEnchantments", defaultAllowedEnchantments, enchantmentsComment);
        this.allowedEnchantments = new LinkedHashSet();
        defaultAllowedEnchantments.forEach(this::addNameSpacedKey);
        defaultMutuallyExclusiveEnchantments = this.addNewConfigOption(config, "mutuallyExclusiveEnchantments", defaultMutuallyExclusiveEnchantments, mutuallyExclusiveEnchantmentsComment);
        this.mutuallyExclusiveEnchantments = new LinkedList<List<Enchantment>>();
        defaultMutuallyExclusiveEnchantments.forEach(this::addMutuallyExclusiveEnchantments);
        this.allowAddingEnchantments = this.addNewConfigOption(config, "allowAddingEnchantments", true, allowAddingEnchantmentsComment);
        this.allowRenaming = this.addNewConfigOption(config, "allowRenaming", true, allowRenamingComment);
        this.checkForUpdates = this.addNewConfigOption(config, "checkForUpdates", true, updateComment);
        this.allowStats = this.addNewConfigOption(config, "allowStats", true, bStatsComment);
        this.enableDebug = this.addNewConfigOption(config, "enableDebug", false, debugComment);
        this.uninstallMode = this.addNewConfigOption(config, "uninstallMode", false, uninstallComment);
        this.languageFile = this.addNewConfigOption(config, "languageFile", "en_US", languageFileComment);
        this.bypassWearPerm = this.addNewConfigOption(config, "bypassWearPermissions", true, permissionsComment);
        this.bypassCraftPerm = this.addNewConfigOption(config, "bypassCraftPermissions", true, null);
        this.writeConfig();
    }

    private void addNameSpacedKey(String fullKey) {
        Enchantment enchantment = this.enchantmentParser.parse(fullKey);
        if (enchantment != null) {
            this.allowedEnchantments.add(enchantment);
        }
    }

    private void addMutuallyExclusiveEnchantments(List<String> fullKeys) {
        LinkedList<Enchantment> enchantments = new LinkedList<Enchantment>();
        for (String fullKey : fullKeys) {
            Enchantment enchantment = this.enchantmentParser.parse(fullKey);
            if (enchantment == null) continue;
            enchantments.add(enchantment);
        }
        this.mutuallyExclusiveEnchantments.add(enchantments);
    }

    private <T> T addNewConfigOption(FileConfiguration config, String optionName, T defaultValue, String[] comment) {
        ConfigOption<T> option = new ConfigOption<T>(this.plugin, config, optionName, defaultValue, comment);
        this.configOptionsList.add(option);
        return option.getValue();
    }

    private void writeConfig() {
        try {
            Path dataDir = this.plugin.getDataFolder().toPath();
            if (!Files.exists(dataDir, new LinkOption[0])) {
                Files.createDirectory(dataDir, new FileAttribute[0]);
            }
            Path configFile = dataDir.resolve("config.yml");
            StringBuilder sb = new StringBuilder(6000);
            sb.append("# ").append(HEADER).append('\n');
            for (ConfigOption<?> configOption : this.configOptionsList) {
                if (configOption.hasComment()) {
                    sb.append('\n');
                }
                sb.append(configOption).append('\n');
            }
            Files.write(configFile, sb.toString().getBytes(), StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not save config.yml! Please contact pim16aap2 and show him the following code:");
            e.printStackTrace();
        }
    }

    public boolean allowStats() {
        return this.allowStats;
    }

    public boolean allowCraftingInSmithingTable() {
        return this.craftingInSmithingTable;
    }

    public boolean allowCraftingInAnvil() {
        return !this.craftingInSmithingTable;
    }

    public boolean allowUpgradeToNetherite() {
        return this.allowUpgradeToNetherite;
    }

    public boolean unbreakable() {
        return this.unbreakable;
    }

    public boolean enableDebug() {
        return this.enableDebug;
    }

    public String languageFile() {
        return this.languageFile;
    }

    public int getFullRepairItemCount(ArmorTier armorTier) {
        return this.repairCounts[armorTier.ordinal()];
    }

    public boolean allowRenaming() {
        return this.allowRenaming;
    }

    public boolean allowAddingEnchantments() {
        return this.allowAddingEnchantments;
    }

    public boolean uninstallMode() {
        return this.uninstallMode;
    }

    public boolean checkForUpdates() {
        return this.checkForUpdates;
    }

    public boolean noFlightDurability() {
        return this.noFlightDurability;
    }

    public LinkedHashSet<Enchantment> allowedEnchantments() {
        return this.allowedEnchantments;
    }

    public List<List<Enchantment>> getMutuallyExclusiveEnchantments() {
        return this.mutuallyExclusiveEnchantments;
    }

    public boolean bypassWearPerm() {
        return this.bypassWearPerm;
    }

    public boolean bypassCraftPerm() {
        return this.bypassCraftPerm;
    }

    public boolean useTierDurability() {
        return this.useTierDurability;
    }
}

