/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.armoredElytra.util;

import java.util.List;
import java.util.logging.Level;
import javax.annotation.Nullable;
import nl.pim16aap2.armoredElytra.ArmoredElytra;
import nl.pim16aap2.armoredElytra.util.Util;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigOption<V> {
    private final ArmoredElytra plugin;
    private final FileConfiguration config;
    private final String optionName;
    private V value;
    private final V defaultValue;
    private final String[] comment;

    public ConfigOption(ArmoredElytra plugin, FileConfiguration config, String optionName, V defaultValue, String[] comment) {
        this.plugin = plugin;
        this.config = config;
        this.optionName = optionName;
        this.defaultValue = defaultValue;
        this.comment = comment;
        this.setValue();
    }

    private void setValue() {
        try {
            this.value = this.config.get(this.optionName, this.defaultValue);
        }
        catch (Exception e) {
            this.plugin.myLogger(Level.WARNING, "Failed to read config value of: \"" + this.optionName + "\"! Using default value instead!");
            this.plugin.myLogger(Level.WARNING, Util.exceptionToString(e));
            this.value = this.defaultValue;
        }
    }

    public V getValue() {
        return this.value;
    }

    @Nullable
    public String[] getComment() {
        return this.comment;
    }

    public boolean hasComment() {
        return this.comment != null;
    }

    public String toString() {
        Object string = "";
        if (this.comment != null) {
            for (String comLine : this.comment) {
                string = (String)string + "# " + comLine + "\n";
            }
        }
        string = (String)string + this.optionName + ": ";
        if (this.value.getClass().isAssignableFrom(String.class)) {
            string = (String)string + "'" + this.value.toString() + "'";
        } else if (this.value instanceof List) {
            StringBuilder builder = new StringBuilder();
            builder.append("\n");
            int listSize = ((List)this.value).size();
            for (int index = 0; index < listSize; ++index) {
                builder.append("  - " + String.valueOf(((List)this.value).get(index)) + (index == listSize - 1 ? "" : "\n"));
            }
            string = (String)string + builder.toString();
        } else {
            string = (String)string + this.value.toString();
        }
        return string;
    }
}

