/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.armoredElytra.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import nl.pim16aap2.armoredElytra.ArmoredElytra;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;

public class EnchantmentContainer
implements Iterable<Map.Entry<Enchantment, Integer>> {
    private Map<Enchantment, Integer> enchantments;

    public EnchantmentContainer(Map<Enchantment, Integer> enchantments, ArmoredElytra plugin) {
        this(enchantments);
        this.filter(plugin.getConfigLoader().allowedEnchantments());
        this.filterMutuallyExclusive();
    }

    public EnchantmentContainer(EnchantmentContainer other) {
        this(other.enchantments);
    }

    public EnchantmentContainer() {
        this.enchantments = new HashMap<Enchantment, Integer>();
    }

    private EnchantmentContainer(Map<Enchantment, Integer> enchantments) {
        this.enchantments = new HashMap<Enchantment, Integer>(enchantments);
    }

    public static EnchantmentContainer getEnchantmentsOf(ItemStack is, ArmoredElytra plugin) {
        if (is == null) {
            return new EnchantmentContainer(Collections.emptyMap(), plugin);
        }
        return is.getType() == Material.ENCHANTED_BOOK ? EnchantmentContainer.getEnchantmentsFromBook(is, plugin) : EnchantmentContainer.getEnchantmentsFromItem(is, plugin);
    }

    private static EnchantmentContainer getEnchantmentsFromItem(ItemStack is, ArmoredElytra plugin) {
        return new EnchantmentContainer(is.getEnchantments(), plugin);
    }

    private static EnchantmentContainer getEnchantmentsFromBook(ItemStack is, ArmoredElytra plugin) {
        if (!is.hasItemMeta()) {
            return new EnchantmentContainer(new HashMap<Enchantment, Integer>(0), plugin);
        }
        EnchantmentStorageMeta meta = (EnchantmentStorageMeta)is.getItemMeta();
        if (meta == null || !meta.hasStoredEnchants()) {
            return new EnchantmentContainer(new HashMap<Enchantment, Integer>(0), plugin);
        }
        return new EnchantmentContainer(meta.getStoredEnchants(), plugin);
    }

    private static List<Enchantment> getMutuallyExclusiveEnchantments(Enchantment enchantment) {
        LinkedList<Enchantment> enchantments = new LinkedList<Enchantment>();
        block0: for (List<Enchantment> mutuallyExclusiveEnchantments : ArmoredElytra.getInstance().getConfigLoader().getMutuallyExclusiveEnchantments()) {
            for (Enchantment mutuallyExclusiveEnchantment : mutuallyExclusiveEnchantments) {
                if (!mutuallyExclusiveEnchantment.equals(enchantment)) continue;
                enchantments.addAll(mutuallyExclusiveEnchantments.stream().filter((? super T i) -> !i.equals(enchantment)).toList());
                continue block0;
            }
        }
        return enchantments;
    }

    public int getEnchantmentCount() {
        return this.enchantments.size();
    }

    public void filter(Collection<Enchantment> allowed) {
        if (!this.enchantments.isEmpty()) {
            this.enchantments.keySet().retainAll(allowed);
        }
    }

    private void filterMutuallyExclusive() {
        LinkedList<Enchantment> disallowedEnchantments = new LinkedList<Enchantment>();
        for (Map.Entry<Enchantment, Integer> entry : this.enchantments.entrySet()) {
            if (disallowedEnchantments.contains(entry.getKey())) continue;
            disallowedEnchantments.addAll(EnchantmentContainer.getMutuallyExclusiveEnchantments(entry.getKey()));
        }
        disallowedEnchantments.forEach(this.enchantments.keySet()::remove);
    }

    public void applyEnchantments(ItemStack is) {
        for (Enchantment enchantment : is.getEnchantments().keySet()) {
            is.removeEnchantment(enchantment);
        }
        is.addUnsafeEnchantments(this.enchantments);
    }

    public void merge(EnchantmentContainer other) {
        if (this == other) {
            throw new IllegalArgumentException("EnchantmentContainers cannot be combined with themselves!");
        }
        this.enchantments = EnchantmentContainer.merge(this.enchantments, other.enchantments);
    }

    public int size() {
        return this.enchantments.size();
    }

    public boolean isEmpty() {
        return this.enchantments.isEmpty();
    }

    public static EnchantmentContainer merge(EnchantmentContainer first, EnchantmentContainer second) {
        return new EnchantmentContainer(EnchantmentContainer.merge(first.enchantments, second.enchantments));
    }

    private static Map<Enchantment, Integer> merge(Map<Enchantment, Integer> first, Map<Enchantment, Integer> second) {
        if (second == null || second.isEmpty()) {
            return first;
        }
        if (first == null || first.isEmpty()) {
            return second;
        }
        List blackList = second.keySet().stream().flatMap(ench -> EnchantmentContainer.getMutuallyExclusiveEnchantments(ench).stream()).toList();
        blackList.forEach(first.keySet()::remove);
        HashMap<Enchantment, Integer> combined = new HashMap<Enchantment, Integer>(first);
        for (Map.Entry<Enchantment, Integer> entry : second.entrySet()) {
            Integer enchantLevel = (Integer)combined.get(entry.getKey());
            if (enchantLevel != null) {
                int oldLevel = enchantLevel;
                if (entry.getValue().equals(enchantLevel) && entry.getValue() < entry.getKey().getMaxLevel()) {
                    enchantLevel = entry.getValue() + 1;
                } else if (entry.getValue() > enchantLevel) {
                    enchantLevel = entry.getValue();
                }
                if (enchantLevel == oldLevel) continue;
                combined.put(entry.getKey(), enchantLevel);
                continue;
            }
            combined.put(entry.getKey(), entry.getValue());
        }
        return combined;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        this.enchantments.forEach((? super K k, ? super V v) -> sb.append("\"").append(k).append("\" (").append(v).append("), "));
        String ret = sb.toString();
        ret = ret.length() > 1 ? ret.substring(0, ret.length() - 2) : ret;
        return ret + "]";
    }

    @Override
    public Iterator<Map.Entry<Enchantment, Integer>> iterator() {
        return this.enchantments.entrySet().iterator();
    }
}

