/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.armoredElytra.util;

import java.util.List;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.enchantments.Enchantment;

public final class RemappedEnchantment {
    private static final RemappedEnchantment REMAPPED_UNBREAKING = new RemappedEnchantment("unbreaking", "durability");
    private static final RemappedEnchantment REMAPPED_PROTECTION_ENVIRONMENTAL = new RemappedEnchantment("protection", "protection_environmental");
    private static final RemappedEnchantment REMAPPED_PROTECTION_FIRE = new RemappedEnchantment("fire_protection", "protection_fire");
    private static final RemappedEnchantment REMAPPED_PROTECTION_FALL = new RemappedEnchantment("feather_falling", "protection_fall");
    private static final RemappedEnchantment REMAPPED_PROTECTION_EXPLOSIONS = new RemappedEnchantment("blast_protection", "protection_explosions");
    private static final RemappedEnchantment REMAPPED_PROTECTION_PROJECTILE = new RemappedEnchantment("projectile_protection", "protection_projectile");
    private static final List<RemappedEnchantment> REMAPPED_ENCHANTMENTS = List.of(REMAPPED_UNBREAKING, REMAPPED_PROTECTION_ENVIRONMENTAL, REMAPPED_PROTECTION_FIRE, REMAPPED_PROTECTION_FALL, REMAPPED_PROTECTION_EXPLOSIONS, REMAPPED_PROTECTION_PROJECTILE);
    public static final Enchantment UNBREAKING = REMAPPED_UNBREAKING.getEnchantment();
    public static final Enchantment PROTECTION_ENVIRONMENTAL = REMAPPED_PROTECTION_ENVIRONMENTAL.getEnchantment();
    public static final Enchantment PROTECTION_FIRE = REMAPPED_PROTECTION_FIRE.getEnchantment();
    public static final Enchantment PROTECTION_FALL = REMAPPED_PROTECTION_FALL.getEnchantment();
    public static final Enchantment PROTECTION_EXPLOSIONS = REMAPPED_PROTECTION_EXPLOSIONS.getEnchantment();
    public static final Enchantment PROTECTION_PROJECTILE = REMAPPED_PROTECTION_PROJECTILE.getEnchantment();
    private final List<String> names;
    private final Enchantment enchantment;

    private RemappedEnchantment(String ... names) {
        this.names = List.of(names);
        this.enchantment = this.findEnchantment();
    }

    public static List<RemappedEnchantment> getRemappedEnchantments() {
        return REMAPPED_ENCHANTMENTS;
    }

    public List<String> getNames() {
        return this.names;
    }

    public Enchantment getEnchantment() {
        return this.enchantment;
    }

    private Enchantment findEnchantment() {
        for (String name : this.names) {
            Enchantment enchantment = (Enchantment)Registry.ENCHANTMENT.get(NamespacedKey.minecraft((String)name));
            if (enchantment == null) continue;
            return enchantment;
        }
        throw new IllegalArgumentException("No enchantment found with the given names: " + String.join((CharSequence)", ", this.names));
    }
}

