/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.armoredElytra.util;

import java.util.logging.Level;
import nl.pim16aap2.armoredElytra.ArmoredElytra;
import nl.pim16aap2.armoredElytra.util.UpdateChecker;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public final class UpdateManager {
    private final ArmoredElytra plugin;
    private boolean checkForUpdates = false;
    private final UpdateChecker updater;
    private BukkitTask updateRunner = null;

    public UpdateManager(ArmoredElytra plugin, int pluginID) {
        this.plugin = plugin;
        this.updater = UpdateChecker.init(plugin, pluginID);
    }

    public void setEnabled(boolean newCheckForUpdates) {
        this.checkForUpdates = newCheckForUpdates;
        this.initUpdater();
    }

    public String getNewestVersion() {
        if (!this.checkForUpdates || this.updater.getLastResult() == null) {
            return null;
        }
        return this.updater.getLastResult().getNewestVersion();
    }

    public boolean updateAvailable() {
        if (!this.checkForUpdates || this.updater.getLastResult() == null) {
            return false;
        }
        return this.updater.getLastResult().requiresUpdate();
    }

    public void checkForUpdates() {
        this.updater.requestUpdateCheck().whenComplete((result, throwable) -> {
            boolean updateAvailable = this.updateAvailable();
            if (updateAvailable) {
                this.plugin.myLogger(Level.INFO, "A new update is available: " + this.plugin.getUpdateManager().getNewestVersion());
            }
        });
    }

    private void initUpdater() {
        if (this.checkForUpdates) {
            if (this.updateRunner == null) {
                this.updateRunner = new BukkitRunnable(){

                    public void run() {
                        UpdateManager.this.checkForUpdates();
                    }
                }.runTaskTimer((Plugin)this.plugin, 0L, 864000L);
            }
        } else {
            this.plugin.myLogger(Level.INFO, "Plugin update checking not enabled! You will not receive any messages about new updates for this plugin. Please consider turning this on in the config.");
            if (this.updateRunner != null) {
                this.updateRunner.cancel();
                this.updateRunner = null;
            }
        }
    }
}

