/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.armoredElytra.util.itemInput;

import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nl.pim16aap2.armoredElytra.ArmoredElytra;
import nl.pim16aap2.armoredElytra.nbtEditor.DurabilityManager;
import nl.pim16aap2.armoredElytra.nbtEditor.NBTEditor;
import nl.pim16aap2.armoredElytra.util.ArmorTier;
import nl.pim16aap2.armoredElytra.util.ConfigLoader;
import nl.pim16aap2.armoredElytra.util.SmithingTableUtil;
import nl.pim16aap2.armoredElytra.util.Util;
import nl.pim16aap2.armoredElytra.util.itemInput.InputAction;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.SmithingInventory;
import org.bukkit.inventory.meta.ItemMeta;

public record ElytraInput(ItemStack elytra, @Nullable ItemStack combinedWith, @Nullable ItemStack template, @Nullable String name, InputAction inputAction, ArmorTier oldArmorTier, ArmorTier newArmorTier) {
    private static final ElytraInput IGNORED = new ElytraInput(new ItemStack(Material.ELYTRA), null, null, null, InputAction.IGNORE, ArmorTier.NONE, ArmorTier.NONE);

    public ElytraInput {
        if (Objects.requireNonNull(elytra).getType() != Material.ELYTRA) {
            throw new IllegalArgumentException("Elytra must be an elytra!");
        }
    }

    private ElytraInput(InputItems inputItems, @Nullable ItemStack template, @Nullable String name, InputAction inputAction, ArmorTier oldArmorTier, ArmorTier newArmorTier) {
        this(inputItems.elytra(), inputItems.combinedWith(), template, name, inputAction, oldArmorTier, newArmorTier);
    }

    public boolean isIgnored() {
        return this.inputAction == InputAction.IGNORE;
    }

    public boolean isBlocked() {
        return this.inputAction == InputAction.BLOCK;
    }

    @Nonnull
    public static ElytraInput fromInventory(ConfigLoader config, DurabilityManager durabilityManager, AnvilInventory inventory) {
        boolean elytraIsArmored;
        NBTEditor nbtEditor = ArmoredElytra.getInstance().getNbtEditor();
        InputItems inputItems = InputItems.fromContents(0, 1, inventory.getContents());
        if (!inputItems.isValid()) {
            return IGNORED;
        }
        ArmorTier oldArmorTier = nbtEditor.getArmorTierFromElytra(inputItems.elytra());
        ArmorTier newArmorTier = Util.armorToTier(inputItems.combinedWith());
        ArmorTier nameUpdateArmorTier = newArmorTier != ArmorTier.NONE ? newArmorTier : oldArmorTier;
        NameUpdate nameUpdate = NameUpdate.fromInput(config, inputItems.elytra(), nameUpdateArmorTier, inventory.getRenameText());
        InputAction inputAction = null;
        boolean bl = elytraIsArmored = oldArmorTier != ArmorTier.NONE;
        if (elytraIsArmored && inputItems.combinedWith() == null && inputItems.elytraIsFirst() && nameUpdate.overrideName() != null) {
            inputAction = config.allowRenaming() ? InputAction.RENAME : InputAction.BLOCK;
        } else if (!elytraIsArmored) {
            inputAction = newArmorTier == ArmorTier.NONE ? InputAction.IGNORE : (!config.allowCraftingInAnvil() ? InputAction.BLOCK : InputAction.CREATE);
        } else if (newArmorTier != ArmorTier.NONE) {
            inputAction = InputAction.IGNORE;
        } else if (!inputItems.isFilled()) {
            inputAction = InputAction.IGNORE;
        } else if (inputItems.combinedWithType() == Material.ENCHANTED_BOOK) {
            inputAction = config.allowAddingEnchantments() ? InputAction.ENCHANT : InputAction.BLOCK;
        } else if (inputItems.combinedWithType() == ArmorTier.getRepairItem(oldArmorTier)) {
            inputAction = durabilityManager.getRealDurability(inputItems.elytra(), oldArmorTier) == 0 ? InputAction.BLOCK : InputAction.REPAIR;
        } else if (oldArmorTier != ArmorTier.LEATHER && inputItems.combinedWithType() == Material.ELYTRA || inputItems.combinedWithType() == Material.LEATHER || inputItems.combinedWithType() == Material.PHANTOM_MEMBRANE) {
            inputAction = InputAction.BLOCK;
        }
        if (inputAction == null) {
            throw new IllegalStateException(String.format("Could not determine the input action for the input:\nInput items: %s\nTemplate: %s\nNameUpdate: %s\nOld armor tier: %s\nNew armor tier: %s\n", new Object[]{inputItems, null, nameUpdate, oldArmorTier, newArmorTier}));
        }
        return new ElytraInput(inputItems, null, nameUpdate.finalName(), inputAction, oldArmorTier, newArmorTier);
    }

    @Nonnull
    public static ElytraInput fromInventory(ConfigLoader config, SmithingInventory inventory) {
        InputAction inputAction;
        Material templateType;
        ItemStack[] contents = inventory.getContents();
        InputItems inputItems = InputItems.fromContents(SmithingTableUtil.SMITHING_TABLE_INPUT_SLOT_1, SmithingTableUtil.SMITHING_TABLE_INPUT_SLOT_2, contents);
        if (!inputItems.isValid() || inputItems.combinedWith() == null) {
            return IGNORED;
        }
        ArmorTier newArmorTier = Util.armorToTier(inputItems.combinedWith());
        ArmorTier oldArmorTier = ArmoredElytra.getInstance().getNbtEditor().getArmorTierFromElytra(inputItems.elytra());
        ItemStack template = SmithingTableUtil.SMITHING_TABLE_HAS_TEMPLATE_SLOT ? contents[SmithingTableUtil.SMITHING_TABLE_TEMPLATE_SLOT] : null;
        Material material = templateType = template != null ? template.getType() : null;
        if (oldArmorTier == ArmorTier.NONE) {
            inputAction = config.allowCraftingInSmithingTable() && newArmorTier != ArmorTier.NONE ? InputAction.CREATE : InputAction.IGNORE;
        } else if (!SmithingTableUtil.SMITHING_TABLE_HAS_TEMPLATE_SLOT || templateType == Material.NETHERITE_UPGRADE_SMITHING_TEMPLATE) {
            if (config.allowUpgradeToNetherite() && oldArmorTier == ArmorTier.DIAMOND && inputItems.combinedWithType() == Material.NETHERITE_INGOT) {
                inputAction = InputAction.UPGRADE;
                newArmorTier = ArmorTier.NETHERITE;
            } else {
                inputAction = InputAction.BLOCK;
            }
        } else {
            inputAction = InputAction.BLOCK;
        }
        return new ElytraInput(inputItems, template, null, inputAction, oldArmorTier, newArmorTier);
    }

    private record InputItems(@Nullable ItemStack elytra, @Nullable ItemStack combinedWith, @Nullable Material combinedWithType, boolean elytraIsFirst) {
        boolean isFilled() {
            return this.elytra != null && this.combinedWith != null;
        }

        boolean isValid() {
            return this.elytra != null && this.elytra.getType() == Material.ELYTRA;
        }

        private static InputItems fromContents(int idxElytra, int idxCombinedWIth, ItemStack ... contents) {
            boolean elytraIsFirst;
            if (contents.length < 2) {
                throw new IllegalArgumentException("Contents must have a length of 2! Got " + contents.length + " instead. " + Arrays.toString(contents));
            }
            ItemStack elytra = contents[idxElytra];
            ItemStack combinedWith = contents[idxCombinedWIth];
            boolean bl = elytraIsFirst = elytra != null && elytra.getType() == Material.ELYTRA;
            if (elytra != null && elytra.getType() != Material.ELYTRA && combinedWith != null && combinedWith.getType() == Material.ELYTRA) {
                ItemStack temp = elytra;
                elytra = combinedWith;
                combinedWith = temp;
            }
            Material combinedWithType = combinedWith != null ? combinedWith.getType() : null;
            return new InputItems(elytra, combinedWith, combinedWithType, elytraIsFirst);
        }
    }

    private record NameUpdate(String defaultName, @Nullable String overrideName, String finalName) {
        public NameUpdate {
            if (defaultName.isEmpty()) {
                throw new IllegalArgumentException("Default name cannot be empty!");
            }
            if (finalName.isEmpty()) {
                throw new IllegalArgumentException("Final name cannot be empty!");
            }
        }

        private NameUpdate(String defaultName, @Nullable String overrideName) {
            this(defaultName, overrideName, overrideName != null && !overrideName.isBlank() ? overrideName : defaultName);
        }

        private static NameUpdate fromInput(ConfigLoader config, ItemStack elytra, ArmorTier newArmorTier, @Nullable String renameText) {
            String name = ArmoredElytra.getInstance().getArmoredElytraName(newArmorTier);
            if (renameText == null) {
                return new NameUpdate(name, null);
            }
            ItemMeta meta = elytra.getItemMeta();
            if (meta == null) {
                throw new IllegalArgumentException("Item meta is null for input elytra: '" + String.valueOf(elytra) + "'");
            }
            String strippedCurrentName = ChatColor.stripColor((String)meta.getDisplayName());
            if (strippedCurrentName.equals(ChatColor.stripColor((String)renameText))) {
                return new NameUpdate(name, null);
            }
            if (!config.allowRenaming()) {
                return new NameUpdate(name, renameText, name);
            }
            return new NameUpdate(name, renameText);
        }
    }
}

