/*
 * Decompiled with CFR 0.152.
 */
package xbigellx.rbp.internal.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import xbigellx.rbp.RealisticBlockPhysics;
import xbigellx.rbp.internal.config.BlockDefinitionConfig;
import xbigellx.rbp.internal.config.ForgeBlockDefinitionConfig;
import xbigellx.rbp.internal.config.ForgeMainConfig;
import xbigellx.rbp.internal.config.ForgeWorldDefinitionConfig;
import xbigellx.rbp.internal.config.MainConfig;
import xbigellx.rbp.internal.config.ModConfiguration;
import xbigellx.rbp.internal.config.WorldDefinitionConfig;
import xbigellx.rbp.internal.level.DefaultWorldDefinitions;
import xbigellx.rbp.internal.level.RBPWorldDefinition;
import xbigellx.rbp.internal.level.block.DefaultBlockDefinitions;
import xbigellx.rbp.internal.level.block.RBPBlockDefinition;
import xbigellx.realisticphysics.internal.config.RPConfig;
import xbigellx.realisticphysics.internal.util.CollectionUtil;
import xbigellx.realisticphysics.internal.util.FileUtil;
import xbigellx.realisticphysics.internal.util.logging.ModLogger;

public class ConfigurationManager {
    private static final ModLogger LOGGER = RealisticBlockPhysics.getLogger();
    private static final String BASE_DIRECTORY = "config/rbp";
    private static final String BLOCK_DEFINITIONS_DIRECTORY = ConfigurationManager.createPath("config/rbp", "block_definitions");
    private static final String WORLD_DEFINITIONS_DIRECTORY = ConfigurationManager.createPath("config/rbp", "world_definitions");
    private static final String MAIN_CONFIG_FILE = ConfigurationManager.createPath("config/rbp", "rbp-common.toml");
    private ModConfiguration modConfig;
    private MainConfig mainConfig;
    private final List<WorldDefinitionConfig> worldDefinitions = new ArrayList<WorldDefinitionConfig>();
    private List<BlockDefinitionConfig> globalBlockDefinitions = new ArrayList<BlockDefinitionConfig>();
    private boolean worldDefinitionsExist = false;
    private boolean blockDefinitionsExist = false;
    private static final RBPBlockDefinition.BlockPhysics DEFAULT_BLOCK_PHYSICS = RBPBlockDefinition.BlockPhysics.DEFAULT;
    private static final RBPBlockDefinition.ChunkAnalysis DEFAULT_BLOCK_CHUNK_ANALYSIS = RBPBlockDefinition.ChunkAnalysis.DEFAULT;
    private static final MainConfig.Model DEFAULT_MAIN_CONFIG = new MainConfig.Model(new MainConfig.Model.Performance(2, true), new MainConfig.Model.Physics(1.0, true, true, true, 500), new MainConfig.Model.Audio(1.0), new MainConfig.Model.ChunkAnalysis(true, 4), new MainConfig.Model.Defaults(""));

    private static boolean initialiseDirectory(String path) {
        File dir = new File(path);
        if (!dir.exists()) {
            LOGGER.trace("Creating Realistic Block Physics configuration directory: {}", new Object[]{path});
            dir.mkdir();
            return true;
        }
        return false;
    }

    private static String createPath(String basePath, String fileName) {
        return basePath + "/" + fileName;
    }

    public void load() {
        LOGGER.info("Loading Realistic Block Physics configuration.");
        this.initialiseDirectories();
        this.initialiseDefaults();
        this.loadAllConfigs();
        List<WorldDefinitionConfig.Model> worldDefinitions = this.worldDefinitions.stream().map(RPConfig::getValue).collect(Collectors.toList());
        List<BlockDefinitionConfig.Model> globalBlockDefinitions = this.globalBlockDefinitions.stream().map(RPConfig::getValue).collect(Collectors.toList());
        HashMap<WorldDefinitionConfig.Model, ImmutableList<BlockDefinitionConfig.Model>> worldBlockDefinitions = new HashMap<WorldDefinitionConfig.Model, ImmutableList<BlockDefinitionConfig.Model>>();
        this.worldDefinitions.forEach(w -> {
            List<BlockDefinitionConfig> blockConfigs = this.readWorldBlockDefinitions((WorldDefinitionConfig)w);
            blockConfigs.forEach(RPConfig::load);
            List blocks = blockConfigs.stream().map(RPConfig::getValue).collect(Collectors.toList());
            worldBlockDefinitions.put((WorldDefinitionConfig.Model)w.getValue(), ImmutableList.copyOf(blocks));
        });
        if (((MainConfig.Model)this.mainConfig.getValue()).defaults().hasDefaultWorldDefinition()) {
            String defaultWorldDefName = ((MainConfig.Model)this.mainConfig.getValue()).defaults().defaultWorldDefinition();
            Optional<WorldDefinitionConfig.Model> defaultWorldDef = worldDefinitions.stream().filter(w -> w.worldDefinition().name().equals(defaultWorldDefName)).findFirst();
            if (defaultWorldDef.isEmpty()) {
                throw new IllegalArgumentException("The specified default world definition '" + defaultWorldDefName + "' does not exist.");
            }
        }
        this.modConfig = new ModConfiguration((MainConfig.Model)this.mainConfig.getValue(), worldDefinitions, globalBlockDefinitions, worldBlockDefinitions);
    }

    private void loadAllConfigs() {
        this.mainConfig.load();
        this.worldDefinitions.forEach(RPConfig::load);
        this.globalBlockDefinitions.forEach(RPConfig::load);
    }

    private void initialiseDefaults() {
        this.clearConfig();
        this.mainConfig = new ForgeMainConfig(new File(MAIN_CONFIG_FILE), DEFAULT_MAIN_CONFIG);
        if (!this.worldDefinitionsExist) {
            LOGGER.info("No existing Realistic Block Physics world definitions found. Default configurations will be created.");
            this.createDefaultWorldDefinitions();
        } else {
            this.readWorldDefinitions();
        }
        if (!this.blockDefinitionsExist) {
            LOGGER.info("No existing Realistic Block Physics block definitions found. Default configurations will be created.");
            this.createDefaultBlockDefinitions();
        } else {
            this.readBlockDefinitions();
        }
    }

    private void initialiseDirectories() {
        LOGGER.info("Initialising Realistic Block Physics configuration directories.");
        ConfigurationManager.initialiseDirectory(BASE_DIRECTORY);
        this.blockDefinitionsExist = !ConfigurationManager.initialiseDirectory(BLOCK_DEFINITIONS_DIRECTORY);
        this.worldDefinitionsExist = !ConfigurationManager.initialiseDirectory(WORLD_DEFINITIONS_DIRECTORY);
    }

    private void clearConfig() {
        this.mainConfig = null;
        this.worldDefinitions.clear();
        this.globalBlockDefinitions.clear();
        this.modConfig = null;
    }

    private void readWorldDefinitions() {
        LOGGER.info("Reading Realistic Block Physics world definition configurations.");
        File directory = new File(WORLD_DEFINITIONS_DIRECTORY);
        ImmutableSet blockBlacklist = ImmutableSet.of();
        for (File file : directory.listFiles()) {
            if (file.isDirectory()) continue;
            String fileName = FileUtil.stripExtension((String)file.getName());
            RBPWorldDefinition defaultValue = new RBPWorldDefinition(fileName, true, DefaultWorldDefinitions.OVERWORLD.physics(), DefaultWorldDefinitions.OVERWORLD.chunkAnalysis(), DefaultWorldDefinitions.OVERWORLD.defaults(), (Set<String>)blockBlacklist);
            this.worldDefinitions.add(new ForgeWorldDefinitionConfig(file, WorldDefinitionConfig.Model.of(CollectionUtil.setOf((String[])new String[0]), defaultValue)));
            LOGGER.trace("Realistic Block Physics world definition read: {}", new Object[]{fileName});
        }
    }

    private WorldDefinitionConfig createDefaultWorldDefinition(RBPWorldDefinition value, Set<String> dimensions) {
        String path = ConfigurationManager.createPath(WORLD_DEFINITIONS_DIRECTORY, value.name() + ".toml");
        File file = new File(path);
        if (file.exists()) {
            throw new IllegalStateException("File already exists.");
        }
        ForgeWorldDefinitionConfig config = new ForgeWorldDefinitionConfig(file, WorldDefinitionConfig.Model.of(dimensions, value));
        this.worldDefinitions.add(config);
        LOGGER.trace("Created default Realistic Block Physics world definition configuration: {}", new Object[]{value.name()});
        return config;
    }

    private void createDefaultWorldDefinitions() {
        LOGGER.info("Creating default Realistic Block Physics world definition configurations.");
        this.createDefaultWorldDefinition(DefaultWorldDefinitions.OVERWORLD, CollectionUtil.setOf((String[])new String[]{"minecraft:overworld"}));
        this.createDefaultWorldDefinition(DefaultWorldDefinitions.THE_NETHER, CollectionUtil.setOf((String[])new String[]{"minecraft:the_nether"}));
        this.createDefaultWorldDefinition(DefaultWorldDefinitions.THE_END, CollectionUtil.setOf((String[])new String[]{"minecraft:the_end"}));
    }

    private List<BlockDefinitionConfig> readWorldBlockDefinitions(WorldDefinitionConfig worldDefConfig) {
        File directory = new File(BLOCK_DEFINITIONS_DIRECTORY + "/" + ((WorldDefinitionConfig.Model)worldDefConfig.getValue()).worldDefinition().name());
        if (!directory.exists()) {
            directory.mkdir();
            return new ArrayList<BlockDefinitionConfig>(0);
        }
        return this.readBlockDefinitionDirectory(directory);
    }

    private void readBlockDefinitions() {
        LOGGER.info("Reading Realistic Block Physics block definition configurations.");
        File directory = new File(BLOCK_DEFINITIONS_DIRECTORY);
        this.globalBlockDefinitions = this.readBlockDefinitionDirectory(directory);
    }

    private List<BlockDefinitionConfig> readBlockDefinitionDirectory(File directory) {
        ArrayList<BlockDefinitionConfig> values = new ArrayList<BlockDefinitionConfig>();
        for (File file : directory.listFiles()) {
            if (file.isDirectory()) continue;
            String fileName = FileUtil.stripExtension((String)file.getName());
            RBPBlockDefinition defaultValue = new RBPBlockDefinition(fileName, DEFAULT_BLOCK_PHYSICS, DEFAULT_BLOCK_CHUNK_ANALYSIS);
            ForgeBlockDefinitionConfig config = new ForgeBlockDefinitionConfig(file, BlockDefinitionConfig.Model.of(CollectionUtil.setOf((String[])new String[0]), defaultValue));
            values.add(config);
            LOGGER.trace("Realistic Block Physics block definition read: {}", new Object[]{fileName});
        }
        return values;
    }

    private BlockDefinitionConfig createDefaultBlockDefinition(RBPBlockDefinition value, Set<String> blocks) {
        String path = ConfigurationManager.createPath(BLOCK_DEFINITIONS_DIRECTORY, value.getName() + ".toml");
        File file = new File(path);
        if (file.exists()) {
            throw new IllegalStateException("File already exists.");
        }
        ForgeBlockDefinitionConfig config = new ForgeBlockDefinitionConfig(file, BlockDefinitionConfig.Model.of(blocks, value));
        this.globalBlockDefinitions.add(config);
        LOGGER.trace("Created default Realistic Block Physics block definition configuration: {}", new Object[]{value.getName()});
        return config;
    }

    private void createDefaultBlockDefinitions() {
        LOGGER.info("Creating default Realistic Block Physics block definition configurations.");
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.BASIC_CONSTRUCTION, CollectionUtil.setOf((String[])new String[]{"#forge:cobblestone", "minecraft:blackstone", "minecraft:chiseled_deepslate", "minecraft:chiseled_polished_blackstone", "minecraft:chiseled_quartz_block", "minecraft:chiseled_red_sandstone", "minecraft:chiseled_sandstone", "minecraft:cut_copper", "minecraft:cut_red_sandstone", "minecraft:cut_sandstone", "minecraft:cracked_deepslate_tiles", "minecraft:dark_prismarine", "minecraft:deepslate_tiles", "minecraft:exposed_copper", "minecraft:exposed_cut_copper", "minecraft:oxidized_copper", "minecraft:oxidized_cut_copper", "minecraft:polished_andesite", "minecraft:polished_basalt", "minecraft:polished_blackstone", "minecraft:polished_diorite", "minecraft:polished_granite", "minecraft:prismarine", "minecraft:purpur_block", "minecraft:purpur_pillar", "minecraft:quartz_block", "minecraft:quartz_pillar", "minecraft:red_sandstone", "minecraft:sandstone", "minecraft:smooth_quartz", "minecraft:smooth_red_sandstone", "minecraft:smooth_sandstone", "minecraft:smooth_stone"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.BASIC_CONSTRUCTION_SLAB, CollectionUtil.setOf((String[])new String[]{"minecraft:andesite_slab", "minecraft:blackstone_slab", "minecraft:cobbled_deepslate_slab", "minecraft:cobblestone_slab", "minecraft:cut_copper_slab", "minecraft:cut_sandstone_slab", "minecraft:cut_red_sandstone_slab", "minecraft:dark_prismarine_slab", "minecraft:deepslate_tile_slab", "minecraft:diorite_slab", "minecraft:exposed_cut_copper_slab", "minecraft:granite_slab", "minecraft:mossy_cobblestone_slab", "minecraft:oxidized_cut_copper_slab", "minecraft:polished_andesite_slab", "minecraft:polished_blackstone_slab", "minecraft:polished_deepslate_slab", "minecraft:polished_diorite_slab", "minecraft:polished_granite_slab", "minecraft:prismarine_slab", "minecraft:purpur_slab", "minecraft:quartz_slab", "minecraft:red_sandstone_slab", "minecraft:sandstone_slab", "minecraft:smooth_quartz_slab", "minecraft:smooth_red_sandstone_slab", "minecraft:smooth_sandstone_slab", "minecraft:smooth_stone_slab", "minecraft:stone_slab"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.BASIC_CONSTRUCTION_STAIRS, CollectionUtil.setOf((String[])new String[]{"minecraft:andesite_stairs", "minecraft:blackstone_stairs", "minecraft:cobbled_deepslate_stairs", "minecraft:cobblestone_stairs", "minecraft:cut_copper_stairs", "minecraft:dark_prismarine_stairs", "minecraft:deepslate_tile_stairs", "minecraft:diorite_stairs", "minecraft:exposed_cut_copper_stairs", "minecraft:granite_stairs", "minecraft:mossy_cobblestone_stairs", "minecraft:oxidized_cut_copper_stairs", "minecraft:polished_andesite_stairs", "minecraft:polished_blackstone_stairs", "minecraft:polished_deepslate_stairs", "minecraft:polished_diorite_stairs", "minecraft:polished_granite_stairs", "minecraft:prismarine_stairs", "minecraft:purpur_stairs", "minecraft:quartz_stairs", "minecraft:red_sandstone_stairs", "minecraft:sandstone_stairs", "minecraft:smooth_quartz_stairs", "minecraft:smooth_red_sandstone_stairs", "minecraft:smooth_sandstone_stairs", "minecraft:stone_stairs"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.BASIC_CONSTRUCTION_WALL, CollectionUtil.setOf((String[])new String[]{"minecraft:andesite_wall", "minecraft:blackstone_wall", "minecraft:cobbled_deepslate_wall", "minecraft:cobblestone_wall", "minecraft:deepslate_tile_wall", "minecraft:diorite_wall", "minecraft:granite_wall", "minecraft:mossy_cobblestone_wall", "minecraft:polished_blackstone_wall", "minecraft:polished_deepslate_wall", "minecraft:prismarine_wall", "minecraft:red_sandstone_wall", "minecraft:sandstone_wall"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.BED, CollectionUtil.setOf((String[])new String[]{"#minecraft:beds"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.BEEHIVE, CollectionUtil.setOf((String[])new String[]{"minecraft:bee_nest", "minecraft:beehive"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.BONE_BLOCK, CollectionUtil.setOf((String[])new String[]{"minecraft:bone_block"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.BOOKSHELF, CollectionUtil.setOf((String[])new String[]{"minecraft:bookshelf"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.CARPET, CollectionUtil.setOf((String[])new String[]{"#minecraft:wool_carpets"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.CHAIN, CollectionUtil.setOf((String[])new String[]{"minecraft:chain"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.CHEST, CollectionUtil.setOf((String[])new String[]{"minecraft:barrel", "minecraft:chest", "minecraft:ender_chest", "minecraft:trapped_chest"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.CHORUS_PLANT, CollectionUtil.setOf((String[])new String[]{"minecraft:chorus_plant"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.CONCRETE, CollectionUtil.setOf((String[])new String[]{"minecraft:black_concrete", "minecraft:blue_concrete", "minecraft:brown_concrete", "minecraft:cyan_concrete", "minecraft:gray_concrete", "minecraft:green_concrete", "minecraft:light_blue_concrete", "minecraft:light_gray_concrete", "minecraft:lime_concrete", "minecraft:magenta_concrete", "minecraft:orange_concrete", "minecraft:pink_concrete", "minecraft:purple_concrete", "minecraft:red_concrete", "minecraft:white_concrete", "minecraft:yellow_concrete"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.CORAL, CollectionUtil.setOf((String[])new String[]{"minecraft:brain_coral_block", "minecraft:bubble_coral_block", "minecraft:dead_brain_coral_block", "minecraft:dead_bubble_coral_block", "minecraft:dead_fire_coral_block", "minecraft:dead_horn_coral_block", "minecraft:dead_tube_coral_block", "minecraft:fire_coral_block", "minecraft:horn_coral_block", "minecraft:tube_coral_block"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.DIRT, CollectionUtil.setOf((String[])new String[]{"#minecraft:dirt", "minecraft:clay", "minecraft:crimson_nylium", "minecraft:dirt_path", "minecraft:farmland", "minecraft:mangrove_roots", "minecraft:mud", "minecraft:mycelium", "minecraft:packed_mud", "minecraft:podzol", "minecraft:sculk", "minecraft:soul_sand", "minecraft:soul_soil", "minecraft:warped_nylium"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.DOOR, CollectionUtil.setOf((String[])new String[]{"#minecraft:doors"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.END_PORTAL, CollectionUtil.setOf((String[])new String[]{"minecraft:end_portal_frame"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.END_STONE, CollectionUtil.setOf((String[])new String[]{"minecraft:end_stone"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.GLASS, CollectionUtil.setOf((String[])new String[]{"minecraft:black_stained_glass", "minecraft:blue_stained_glass", "minecraft:brown_stained_glass", "minecraft:cyan_stained_glass", "minecraft:glass", "minecraft:gray_stained_glass", "minecraft:green_stained_glass", "minecraft:light_blue_stained_glass", "minecraft:light_gray_stained_glass", "minecraft:lime_stained_glass", "minecraft:magenta_stained_glass", "minecraft:orange_stained_glass", "minecraft:pink_stained_glass", "minecraft:purple_stained_glass", "minecraft:red_stained_glass", "minecraft:tinted_glass", "minecraft:white_stained_glass", "minecraft:yellow_stained_glass"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.GLASS_PANE, CollectionUtil.setOf((String[])new String[]{"minecraft:black_stained_glass_pane", "minecraft:blue_stained_glass_pane", "minecraft:brown_stained_glass_pane", "minecraft:cyan_stained_glass_pane", "minecraft:glass_pane", "minecraft:gray_stained_glass_pane", "minecraft:green_stained_glass_pane", "minecraft:light_blue_stained_glass_pane", "minecraft:light_gray_stained_glass_pane", "minecraft:lime_stained_glass_pane", "minecraft:magenta_stained_glass_pane", "minecraft:orange_stained_glass_pane", "minecraft:pink_stained_glass_pane", "minecraft:purple_stained_glass_pane", "minecraft:red_stained_glass_pane", "minecraft:white_stained_glass_pane", "minecraft:yellow_stained_glass_pane"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.GLOWSTONE, CollectionUtil.setOf((String[])new String[]{"minecraft:glowstone", "minecraft:ochre_froglight", "minecraft:pearlescent_froglight", "minecraft:shroomlight", "minecraft:verdant_froglight"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.HOPPER, CollectionUtil.setOf((String[])new String[]{"minecraft:hopper"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.ICE, CollectionUtil.setOf((String[])new String[]{"minecraft:blue_ice", "minecraft:frosted_ice", "minecraft:ice", "minecraft:packed_ice"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.IRON_BARS, CollectionUtil.setOf((String[])new String[]{"minecraft:iron_bars"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.LAMP, CollectionUtil.setOf((String[])new String[]{"minecraft:redstone_lamp", "minecraft:sea_lantern"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.LANTERN, CollectionUtil.setOf((String[])new String[]{"minecraft:lantern", "minecraft:soul_lantern"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.LEAVES, CollectionUtil.setOf((String[])new String[]{"minecraft:acacia_leaves", "minecraft:azalea_leaves", "minecraft:birch_leaves", "minecraft:dark_oak_leaves", "minecraft:flowering_azalea_leaves", "minecraft:jungle_leaves", "minecraft:mangrove_leaves", "minecraft:nether_wart_block", "minecraft:oak_leaves", "minecraft:spruce_leaves"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.MISCELLANEOUS, CollectionUtil.setOf((String[])new String[]{"minecraft:bell", "minecraft:conduit", "minecraft:creeper_head", "minecraft:dragon_head", "minecraft:end_rod", "minecraft:flower_pot", "minecraft:ladder", "minecraft:lightning_rod", "minecraft:player_head", "minecraft:skeleton_skull", "minecraft:turtle_egg", "minecraft:wither_skeleton_skull", "minecraft:zombie_head"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.MUD_CONSTRUCTION, CollectionUtil.setOf((String[])new String[]{"minecraft:mud_bricks"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.MUD_CONSTRUCTION_SLAB, CollectionUtil.setOf((String[])new String[]{"minecraft:mud_brick_slab"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.MUD_CONSTRUCTION_STAIRS, CollectionUtil.setOf((String[])new String[]{"minecraft:mud_brick_stairs"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.MUD_CONSTRUCTION_WALL, CollectionUtil.setOf((String[])new String[]{"minecraft:mud_brick_wall"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.MUSHROOM, CollectionUtil.setOf((String[])new String[]{"minecraft:brown_mushroom_block", "minecraft:mushroom_stem", "minecraft:red_mushroom_block"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.NETHERRACK, CollectionUtil.setOf((String[])new String[]{"minecraft:ancient_debris", "minecraft:basalt", "minecraft:gilded_blackstone", "minecraft:smooth_basalt", "minecraft:magma_block", "minecraft:netherrack", "minecraft:nether_gold_ore", "minecraft:nether_quartz_ore"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.OBSIDIAN, CollectionUtil.setOf((String[])new String[]{"minecraft:crying_obsidian", "minecraft:obsidian"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.PISTON, CollectionUtil.setOf((String[])new String[]{"minecraft:moving_piston", "minecraft:piston", "minecraft:sticky_piston", "minecraft:piston_head"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.POINTED_DRIPSTONE, CollectionUtil.setOf((String[])new String[]{"minecraft:pointed_dripstone"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.POWDER_SNOW, CollectionUtil.setOf((String[])new String[]{"minecraft:powder_snow"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.PRODUCE, CollectionUtil.setOf((String[])new String[]{"minecraft:carved_pumpkin", "minecraft:dried_kelp_block", "minecraft:hay_block", "minecraft:honeycomb_block", "minecraft:jack_o_lantern", "minecraft:melon", "minecraft:pumpkin", "minecraft:target", "minecraft:warped_wart_block"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.REFINED_ORE, CollectionUtil.setOf((String[])new String[]{"minecraft:coal_block", "minecraft:copper_block", "minecraft:diamond_block", "minecraft:emerald_block", "minecraft:gold_block", "minecraft:iron_block", "minecraft:lapis_block", "minecraft:netherite_block", "minecraft:redstone_block", "minecraft:waxed_copper_block", "minecraft:waxed_cut_copper", "minecraft:waxed_cut_copper_slab", "minecraft:waxed_cut_copper_stairs", "minecraft:waxed_exposed_copper", "minecraft:waxed_exposed_cut_copper", "minecraft:waxed_exposed_cut_copper_slab", "minecraft:waxed_exposed_cut_copper_stairs", "minecraft:waxed_oxidized_copper", "minecraft:waxed_oxidized_cut_copper", "minecraft:waxed_oxidized_cut_copper_slab", "minecraft:waxed_oxidized_cut_copper_stairs", "minecraft:waxed_weathered_copper", "minecraft:waxed_weathered_cut_copper", "minecraft:waxed_weathered_cut_copper_slab", "minecraft:waxed_weathered_cut_copper_stairs", "minecraft:weathered_copper", "minecraft:weathered_cut_copper", "minecraft:weathered_cut_copper_slab", "minecraft:weathered_cut_copper_stairs"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.SAND, CollectionUtil.setOf((String[])new String[]{"#minecraft:sand", "minecraft:black_concrete_powder", "minecraft:blue_concrete_powder", "minecraft:brown_concrete_powder", "minecraft:cyan_concrete_powder", "minecraft:gravel", "minecraft:gray_concrete_powder", "minecraft:green_concrete_powder", "minecraft:light_blue_concrete_powder", "minecraft:light_gray_concrete_powder", "minecraft:lime_concrete_powder", "minecraft:magenta_concrete_powder", "minecraft:orange_concrete_powder", "minecraft:pink_concrete_powder", "minecraft:purple_concrete_powder", "minecraft:red_concrete_powder", "minecraft:white_concrete_powder", "minecraft:yellow_concrete_powder"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.SHULKER_BOX, CollectionUtil.setOf((String[])new String[]{"minecraft:black_shulker_box", "minecraft:blue_shulker_box", "minecraft:brown_shulker_box", "minecraft:cyan_shulker_box", "minecraft:gray_shulker_box", "minecraft:green_shulker_box", "minecraft:light_blue_shulker_box", "minecraft:lime_shulker_box", "minecraft:magenta_shulker_box", "minecraft:orange_shulker_box", "minecraft:pink_shulker_box", "minecraft:purple_shulker_box", "minecraft:red_shulker_box", "minecraft:white_shulker_box", "minecraft:yellow_shulker_box"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.SLIME, CollectionUtil.setOf((String[])new String[]{"minecraft:honey_block", "minecraft:slime_block"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.SNOW, CollectionUtil.setOf((String[])new String[]{"minecraft:snow_block"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.SPONGE, CollectionUtil.setOf((String[])new String[]{"minecraft:sponge", "minecraft:wet_sponge"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.STONE, CollectionUtil.setOf((String[])new String[]{"#forge:stone", "#forge:ores", "minecraft:amethyst_block", "minecraft:budding_amethyst", "minecraft:calcite", "minecraft:dripstone_block", "minecraft:polished_andesite", "minecraft:polished_diorite", "minecraft:polished_granite", "minecraft:raw_copper_block", "minecraft:raw_gold_block", "minecraft:raw_iron_block"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.STRONG_CONSTRUCTION, CollectionUtil.setOf((String[])new String[]{"#minecraft:stone_bricks", "minecraft:bricks", "minecraft:chiseled_nether_bricks", "minecraft:cracked_deepslate_bricks", "minecraft:cracked_nether_bricks", "minecraft:cracked_polished_blackstone_bricks", "minecraft:deepslate_bricks", "minecraft:end_stone_bricks", "minecraft:infested_chiseled_stone_bricks", "minecraft:infested_cracked_stone_bricks", "minecraft:infested_mossy_stone_bricks", "minecraft:infested_stone_bricks", "minecraft:nether_bricks", "minecraft:polished_blackstone_bricks", "minecraft:prismarine_bricks", "minecraft:red_nether_brick_wall", "minecraft:reinforced_deepslate", "minecraft:quartz_bricks", "minecraft:red_nether_bricks"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.STRONG_CONSTRUCTION_SLAB, CollectionUtil.setOf((String[])new String[]{"minecraft:brick_slab", "minecraft:deepslate_brick_slab", "minecraft:end_stone_brick_slab", "minecraft:mossy_stone_brick_slab", "minecraft:nether_brick_slab", "minecraft:polished_blackstone_brick_slab", "minecraft:prismarine_brick_slab", "minecraft:red_nether_brick_slab", "minecraft:stone_brick_slab"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.STRONG_CONSTRUCTION_STAIRS, CollectionUtil.setOf((String[])new String[]{"minecraft:brick_stairs", "minecraft:deepslate_brick_stairs", "minecraft:end_stone_brick_stairs", "minecraft:mossy_stone_brick_stairs", "minecraft:nether_brick_stairs", "minecraft:polished_blackstone_brick_stairs", "minecraft:prismarine_brick_stairs", "minecraft:red_nether_brick_stairs", "minecraft:stone_brick_stairs"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.STRONG_CONSTRUCTION_WALL, CollectionUtil.setOf((String[])new String[]{"minecraft:brick_wall", "minecraft:deepslate_brick_wall", "minecraft:end_stone_brick_wall", "minecraft:mossy_stone_brick_wall", "minecraft:nether_brick_fence", "minecraft:nether_brick_wall", "minecraft:polished_blackstone_brick_wall", "minecraft:red_nether_brick_wall", "minecraft:stone_brick_wall"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.TERRACOTTA, CollectionUtil.setOf((String[])new String[]{"minecraft:black_glazed_terracotta", "minecraft:black_terracotta", "minecraft:blue_glazed_terracotta", "minecraft:blue_terracotta", "minecraft:brown_glazed_terracotta", "minecraft:brown_terracotta", "minecraft:cyan_glazed_terracotta", "minecraft:cyan_terracotta", "minecraft:gray_glazed_terracotta", "minecraft:gray_terracotta", "minecraft:green_glazed_terracotta", "minecraft:green_terracotta", "minecraft:light_blue_glazed_terracotta", "minecraft:light_blue_terracotta", "minecraft:light_gray_glazed_terracotta", "minecraft:light_gray_terracotta", "minecraft:lime_glazed_terracotta", "minecraft:lime_terracotta", "minecraft:magenta_glazed_terracotta", "minecraft:magenta_terracotta", "minecraft:orange_glazed_terracotta", "minecraft:orange_terracotta", "minecraft:purple_glazed_terracotta", "minecraft:purple_terracotta", "minecraft:pink_glazed_terracotta", "minecraft:pink_terracotta", "minecraft:red_glazed_terracotta", "minecraft:red_terracotta", "minecraft:terracotta", "minecraft:white_glazed_terracotta", "minecraft:white_terracotta", "minecraft:yellow_glazed_terracotta", "minecraft:yellow_terracotta"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.TNT, CollectionUtil.setOf((String[])new String[]{"minecraft:tnt"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.TRAPDOOR, CollectionUtil.setOf((String[])new String[]{"minecraft:acacia_trapdoor", "minecraft:birch_trapdoor", "minecraft:crimson_trapdoor", "minecraft:dark_oak_trapdoor", "minecraft:iron_trapdoor", "minecraft:jungle_trapdoor", "minecraft:mangrove_trapdoor", "minecraft:oak_trapdoor", "minecraft:spruce_trapdoor", "minecraft:warped_trapdoor"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.TRIPWIRE, CollectionUtil.setOf((String[])new String[]{"minecraft:tripwire"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.UTILITY, CollectionUtil.setOf((String[])new String[]{"minecraft:cauldron", "minecraft:lodestone", "minecraft:respawn_anchor", "minecraft:smoker", "minecraft:spawner"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.UTILITY_HEAVY, CollectionUtil.setOf((String[])new String[]{"minecraft:anvil", "minecraft:blast_furnace", "minecraft:chipped_anvil", "minecraft:damaged_anvil", "minecraft:dispenser", "minecraft:dropper", "minecraft:enchanting_table", "minecraft:furnace", "minecraft:observer"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.UTILITY_LIGHT, CollectionUtil.setOf((String[])new String[]{"minecraft:beacon", "minecraft:brewing_stand", "minecraft:campfire", "minecraft:cartography_table", "minecraft:composter", "minecraft:crafting_table", "minecraft:daylight_detector", "minecraft:fletching_table", "minecraft:grindstone", "minecraft:jukebox", "minecraft:lava_cauldron", "minecraft:lectern", "minecraft:loom", "minecraft:note_block", "minecraft:powder_snow_cauldron", "minecraft:smithing_table", "minecraft:soul_campfire", "minecraft:stonecutter", "minecraft:water_cauldron"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.WEB, CollectionUtil.setOf((String[])new String[]{"minecraft:cobweb"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.WOOD, CollectionUtil.setOf((String[])new String[]{"#minecraft:planks", "minecraft:acacia_log", "minecraft:acacia_wood", "minecraft:birch_log", "minecraft:birch_wood", "minecraft:crimson_hyphae", "minecraft:crimson_stem", "minecraft:dark_oak_log", "minecraft:dark_oak_wood", "minecraft:jungle_log", "minecraft:jungle_wood", "minecraft:mangrove_log", "minecraft:mangrove_wood", "minecraft:oak_log", "minecraft:oak_wood", "minecraft:spruce_log", "minecraft:spruce_wood", "minecraft:stripped_acacia_log", "minecraft:stripped_acacia_wood", "minecraft:stripped_birch_log", "minecraft:stripped_birch_wood", "minecraft:stripped_crimson_hyphae", "minecraft:stripped_crimson_stem", "minecraft:stripped_dark_oak_log", "minecraft:stripped_dark_oak_wood", "minecraft:stripped_jungle_log", "minecraft:stripped_jungle_wood", "minecraft:stripped_mangrove_log", "minecraft:stripped_mangrove_wood", "minecraft:stripped_oak_log", "minecraft:stripped_oak_wood", "minecraft:stripped_spruce_log", "minecraft:stripped_spruce_wood", "minecraft:stripped_warped_hyphae", "minecraft:stripped_warped_stem", "minecraft:warped_hyphae", "minecraft:warped_stem"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.WOODEN_FENCE, CollectionUtil.setOf((String[])new String[]{"minecraft:acacia_fence", "minecraft:acacia_fence_gate", "minecraft:birch_fence", "minecraft:birch_fence_gate", "minecraft:crimson_fence", "minecraft:crimson_fence_gate", "minecraft:dark_oak_fence", "minecraft:dark_oak_fence_gate", "minecraft:jungle_fence", "minecraft:jungle_fence_gate", "minecraft:mangrove_fence", "minecraft:mangrove_fence_gate", "minecraft:oak_fence", "minecraft:oak_fence_gate", "minecraft:spruce_fence", "minecraft:spruce_fence_gate", "minecraft:warped_fence", "minecraft:warped_fence_gate"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.WOODEN_SLAB, CollectionUtil.setOf((String[])new String[]{"minecraft:acacia_slab", "minecraft:birch_slab", "minecraft:crimson_slab", "minecraft:dark_oak_slab", "minecraft:jungle_slab", "minecraft:mangrove_slab", "minecraft:oak_slab", "minecraft:petrified_oak_slab", "minecraft:spruce_slab", "minecraft:warped_slab"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.WOODEN_STAIRS, CollectionUtil.setOf((String[])new String[]{"minecraft:acacia_stairs", "minecraft:birch_stairs", "minecraft:crimson_stairs", "minecraft:dark_oak_stairs", "minecraft:jungle_stairs", "minecraft:mangrove_stairs", "minecraft:oak_stairs", "minecraft:spruce_stairs", "minecraft:warped_stairs"}));
        this.createDefaultBlockDefinition(DefaultBlockDefinitions.WOOL, CollectionUtil.setOf((String[])new String[]{"#minecraft:wool"}));
    }

    public ModConfiguration getConfig() {
        return this.modConfig;
    }
}

