/*
 * Decompiled with CFR 0.152.
 */
package xbigellx.rbp.internal.config;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import xbigellx.rbp.internal.config.BlockDefinitionConfig;
import xbigellx.rbp.internal.level.block.RBPBlockDefinition;
import xbigellx.realisticphysics.internal.config.ForgeConfig;
import xbigellx.realisticphysics.internal.level.block.BlockDefinition;
import xbigellx.realisticphysics.internal.util.CollectionUtil;
import xbigellx.realisticphysics.internal.util.FileUtil;

public class ForgeBlockDefinitionConfig
extends ForgeConfig<BlockDefinitionConfig.Model>
implements BlockDefinitionConfig {
    private final ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
    private BlockDefinitionConfig.Model defaultValue;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> blocks;
    private final ForgeConfigSpec.IntValue supportStrength;
    private final ForgeConfigSpec.DoubleValue beamStrength;
    private final ForgeConfigSpec.DoubleValue mass;
    private final ForgeConfigSpec.BooleanValue canHang;
    private final ForgeConfigSpec.BooleanValue canAttach;
    private final ForgeConfigSpec.BooleanValue canAttachDiagonally;
    private final ForgeConfigSpec.DoubleValue slideChance;
    private final ForgeConfigSpec.DoubleValue placementSlideModifier;
    private final ForgeConfigSpec.DoubleValue entityDamageScale;
    private final ForgeConfigSpec.BooleanValue breaksOnFalling;
    private final ForgeConfigSpec.IntValue strength;
    private final ForgeConfigSpec.BooleanValue floatsOnLiquid;
    private final ForgeConfigSpec.BooleanValue extendBoundsUp;
    private final ForgeConfigSpec.BooleanValue extendBoundsDown;
    private final ForgeConfigSpec.BooleanValue extendBoundsNorth;
    private final ForgeConfigSpec.BooleanValue extendBoundsEast;
    private final ForgeConfigSpec.BooleanValue extendBoundsSouth;
    private final ForgeConfigSpec.BooleanValue extendBoundsWest;
    private final ForgeConfigSpec.BooleanValue chunkAnalysisEnabled;
    private final ForgeConfigSpec spec;

    protected ForgeBlockDefinitionConfig(File file, BlockDefinitionConfig.Model defaultValue) {
        super(file);
        this.defaultValue = defaultValue;
        if (!this.getDefinitionName().equals(this.defaultValue.blockDefinition().getName())) {
            throw new IllegalArgumentException("The provided file name does not match the name of the provided default value.");
        }
        this.blocks = this.builder.comment("A list of block IDs and tags that should be affected by this definition.\nEntries can be supplied in the below formats:\n\tNamespaces:   '<minecraft>'\n\tTags:         '#forge:stone'\n\tIDs:          'minecraft:stone'").defineListAllowEmpty(CollectionUtil.listOf((String[])new String[]{this.createPath("Blocks")}), () -> defaultValue.blocks().stream().sorted().toList(), val -> true);
        this.builder.push("Physics");
        this.supportStrength = this.builder.comment("The maximum weight the block(s) can support both horizontally and vertically.").defineInRange("SupportStrength", defaultValue.blockDefinition().physics().supportStrength(), 0, Integer.MAX_VALUE);
        this.beamStrength = this.builder.comment("Additional support strength to apply to the amount of weight the block(s) can support above when acting as a beam.\nA value of 1.0 will allow the block(s) to support an infinite amount of weight, whereas a value of 0.0 will not apply any additional strengthening.").defineInRange("BeamStrength", defaultValue.blockDefinition().physics().beamStrength(), 0.0, 1.0);
        this.mass = this.builder.comment("The mass of the block(s), in kilograms.").defineInRange("Mass", defaultValue.blockDefinition().physics().mass(), 1.0, 50000.0);
        this.canHang = this.builder.comment("Whether the block(s) can hang from other blocks for support.").define("CanHang", defaultValue.blockDefinition().physics().canHang());
        this.canAttach = this.builder.comment("Whether the block(s) can attach to the sides of other blocks for support.").define("CanAttach", defaultValue.blockDefinition().physics().canAttach());
        this.canAttachDiagonally = this.builder.comment("Whether the block(s) can diagonally attach to other blocks for support.").define("CanAttachDiagonally", defaultValue.blockDefinition().physics().canAttachDiagonally());
        this.slideChance = this.builder.comment("The chance the block(s) will slide after falling and landing.").defineInRange("SlideChance", defaultValue.blockDefinition().physics().slideChance(), 0.0, 1.0);
        this.placementSlideModifier = this.builder.comment("An additional \"dice roll\" to apply to the base slide chance of the block(s), when being placed by an entity.\nSetting a value of 1.0 means the slide chance will remain unaffected.").defineInRange("PlacementSlideModifier", defaultValue.blockDefinition().physics().placementSlideModifier(), 0.0, 1.0);
        this.entityDamageScale = this.builder.comment("A multiplier to apply to the damage caused by the block(s) when falling on entities.").defineInRange("EntityDamageScale", defaultValue.blockDefinition().physics().entityDamageScale(), 0.0, 10.0);
        this.breaksOnFalling = this.builder.comment("Whether the block(s) should break instead of falling.").define("BreaksOnFalling", defaultValue.blockDefinition().physics().breaksOnFalling());
        this.strength = this.builder.comment("The maximum force the block(s) can withstand before being broken.").defineInRange("Strength", defaultValue.blockDefinition().physics().strength(), 0, Integer.MAX_VALUE);
        this.floatsOnLiquid = this.builder.comment("Whether the block(s) can be supported by liquids that are below.").define("FloatsOnLiquid", defaultValue.blockDefinition().physics().floatsOnLiquid());
        this.builder.comment("This section allows you to extend the collision bounds for each specific face of the block(s).\nNote: Directions are relative to the orientation of the block(s) (excluding vertical axis), not the world itself.");
        this.builder.push("ExtendedCollisionBounds");
        this.extendBoundsUp = this.builder.comment("Fully extends the collision bounds of the block(s) in the UP direction.").define(this.createPath("Up"), defaultValue.blockDefinition().physics().extendedCollisionBounds().up());
        this.extendBoundsDown = this.builder.comment("Fully extends the collision bounds of the block(s) in the DOWN direction.").define(this.createPath("Down"), defaultValue.blockDefinition().physics().extendedCollisionBounds().down());
        this.extendBoundsNorth = this.builder.comment("Fully extends the collision bounds of the block(s) in the NORTH direction.").define(this.createPath("North"), defaultValue.blockDefinition().physics().extendedCollisionBounds().north());
        this.extendBoundsEast = this.builder.comment("Fully extends the collision bounds of the block(s) in the EAST direction.").define(this.createPath("East"), defaultValue.blockDefinition().physics().extendedCollisionBounds().east());
        this.extendBoundsSouth = this.builder.comment("Fully extends the collision bounds of the block(s) in the SOUTH direction.").define(this.createPath("South"), defaultValue.blockDefinition().physics().extendedCollisionBounds().south());
        this.extendBoundsWest = this.builder.comment("Fully extends the collision bounds of the block(s) in the WEST direction.").define(this.createPath("West"), defaultValue.blockDefinition().physics().extendedCollisionBounds().west());
        this.builder.pop();
        this.builder.pop();
        this.chunkAnalysisEnabled = this.builder.comment("Whether the block(s) should be processed during chunk analysis updates.").define(this.createPath("ChunkAnalysis.Enabled"), defaultValue.blockDefinition().chunkAnalysis().enabled());
        this.spec = this.builder.build();
    }

    private String createPath(String value) {
        return value;
    }

    private String getDefinitionName() {
        return FileUtil.stripExtension((String)this.file.getName());
    }

    protected ForgeConfigSpec getConfigSpec() {
        return this.spec;
    }

    protected BlockDefinitionConfig.Model readValue() {
        HashSet<String> blocks = new HashSet<String>((Collection)this.blocks.get());
        return new BlockDefinitionConfig.Model(blocks, new RBPBlockDefinition(this.getDefinitionName(), new RBPBlockDefinition.BlockPhysics((Double)this.mass.get(), (Integer)this.supportStrength.get(), (Double)this.beamStrength.get(), (Boolean)this.canAttach.get(), (Boolean)this.canAttachDiagonally.get(), (Boolean)this.canHang.get(), (Double)this.slideChance.get(), (Double)this.placementSlideModifier.get(), (Double)this.entityDamageScale.get(), (Boolean)this.breaksOnFalling.get(), (Integer)this.strength.get(), (Boolean)this.floatsOnLiquid.get(), new BlockDefinition.ExtendedCollisionBounds(((Boolean)this.extendBoundsUp.get()).booleanValue(), ((Boolean)this.extendBoundsDown.get()).booleanValue(), ((Boolean)this.extendBoundsNorth.get()).booleanValue(), ((Boolean)this.extendBoundsEast.get()).booleanValue(), ((Boolean)this.extendBoundsSouth.get()).booleanValue(), ((Boolean)this.extendBoundsWest.get()).booleanValue())), new RBPBlockDefinition.ChunkAnalysis((Boolean)this.chunkAnalysisEnabled.get())));
    }
}

