/*
 * Decompiled with CFR 0.152.
 */
package xbigellx.rbp.internal.config;

import java.io.File;
import net.minecraftforge.common.ForgeConfigSpec;
import xbigellx.rbp.internal.config.MainConfig;
import xbigellx.realisticphysics.internal.config.ForgeConfig;

public class ForgeMainConfig
extends ForgeConfig<MainConfig.Model>
implements MainConfig {
    private final ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
    private final ForgeConfigSpec.BooleanValue chunkAnalysisEnabled;
    private final ForgeConfigSpec.IntValue chunkAnalysisRange;
    private final ForgeConfigSpec.IntValue fallingBlockRate;
    private final ForgeConfigSpec.BooleanValue blockIntegrityScans;
    private final ForgeConfigSpec.DoubleValue blockImpactVolume;
    private final ForgeConfigSpec.DoubleValue brokenBlockItemDropChance;
    private final ForgeConfigSpec.BooleanValue fallingBlockRelocation;
    private final ForgeConfigSpec.BooleanValue diagonalBlockConnections;
    private final ForgeConfigSpec.BooleanValue blocksCanBeCrushed;
    private final ForgeConfigSpec.IntValue fallingBlockDamageDampening;
    private final ForgeConfigSpec.ConfigValue<String> defaultWorldDefinition;
    private final ForgeConfigSpec spec;

    protected ForgeMainConfig(File file, MainConfig.Model defaultValue) {
        super(file);
        this.chunkAnalysisEnabled = this.builder.comment("Whether chunk analysis should be enabled (full physics scans on the blocks of a chunk).\nDisabling chunk analysis can help to improve performance.").define("ChunkAnalysis.Enabled", defaultValue.chunkAnalysis().enabled());
        this.chunkAnalysisRange = this.builder.comment("The range at which chunk analysis updates will be scheduled, based on nearby players.\nReducing this value can help improve performance.").defineInRange("ChunkAnalysis.ActiveRange", defaultValue.chunkAnalysis().activeRange(), 0, 32);
        this.brokenBlockItemDropChance = this.builder.comment("The chance of blocks dropping their items when breaking due to physics.").defineInRange("Physics.BrokenBlockItemDropChance", defaultValue.physics().brokenBlockItemDropChance(), 0.0, 1.0);
        this.fallingBlockRelocation = this.builder.comment("Whether falling blocks that fall into the same position should be relocated instead of broken.").define("Physics.FallingBlockRelocation", defaultValue.physics().fallingBlockRelocation());
        this.diagonalBlockConnections = this.builder.comment("Whether blocks should be able to connect to each other diagonally. Only blocks with 'CanAttachDiagonally' enabled will be affected.").define("Physics.DiagonalBlockConnections", defaultValue.physics().diagonalBlockConnections());
        this.blocksCanBeCrushed = this.builder.comment("Whether blocks should be able to be crushed if the weight above them exceeds their strength.").define("Physics.BlocksCanBeCrushed", defaultValue.physics().blocksCanBeCrushed());
        this.fallingBlockDamageDampening = this.builder.comment("A global dampening factor to apply to the base damage of entities when struck by falling blocks.\n\t+ Increase this value to reduce the damage applied to entities when struck by falling blocks.\n\t- Lower this value to increase the damage applied to entities when struck by falling blocks.").defineInRange("Physics.FallingBlockDamageDampening", defaultValue.physics().fallingBlockDamageDampening(), 1, 5000);
        this.fallingBlockRate = this.builder.comment("The maximum number of falling blocks that can be added to a level within a single tick.").defineInRange("Performance.FallingBlockRate", defaultValue.performance().fallingBlockRate(), 1, 50);
        this.blockIntegrityScans = this.builder.comment("Whether to perform more detailed integrity scans on blocks.\nWhen the support of a block is removed, but is not touching the block it was supporting, a scan can be performed on all potentially affected nearby blocks to recalculate physics.").define("Performance.DetailedIntegrityScans", defaultValue.performance().detailedIntegrityScans());
        this.blockImpactVolume = this.builder.comment("The volume at which to sound falling blocks that have impacted with the ground.").defineInRange("Audio.BlockImpactVolume", 1.0, 0.0, 1.0);
        this.defaultWorldDefinition = this.builder.comment("Specifies the default world definition to give to dimensions that do not have one specified.\nLeave this empty if you do not wish to apply physics to dimensions that do not have a specified world definition.").define("Defaults.DefaultWorldDefinition", (Object)defaultValue.defaults().defaultWorldDefinition());
        this.spec = this.builder.build();
    }

    protected ForgeConfigSpec getConfigSpec() {
        return this.spec;
    }

    protected MainConfig.Model readValue() {
        return new MainConfig.Model(new MainConfig.Model.Performance((Integer)this.fallingBlockRate.get(), (Boolean)this.blockIntegrityScans.get()), new MainConfig.Model.Physics((Double)this.brokenBlockItemDropChance.get(), (Boolean)this.fallingBlockRelocation.get(), (Boolean)this.diagonalBlockConnections.get(), (Boolean)this.blocksCanBeCrushed.get(), (Integer)this.fallingBlockDamageDampening.get()), new MainConfig.Model.Audio((Double)this.blockImpactVolume.get()), new MainConfig.Model.ChunkAnalysis((Boolean)this.chunkAnalysisEnabled.get(), (Integer)this.chunkAnalysisRange.get()), new MainConfig.Model.Defaults((String)this.defaultWorldDefinition.get()));
    }
}

