/*
 * Decompiled with CFR 0.152.
 */
package xbigellx.rbp.internal.config;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import xbigellx.rbp.internal.config.WorldDefinitionConfig;
import xbigellx.rbp.internal.level.RBPWorldDefinition;
import xbigellx.realisticphysics.internal.config.ForgeConfig;
import xbigellx.realisticphysics.internal.util.CollectionUtil;
import xbigellx.realisticphysics.internal.util.FileUtil;

public class ForgeWorldDefinitionConfig
extends ForgeConfig<WorldDefinitionConfig.Model>
implements WorldDefinitionConfig {
    private final ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> dimensions = this.builder.comment("A list of dimension IDs that should be affected by this definition.").defineListAllowEmpty(CollectionUtil.listOf((String[])new String[]{"Dimensions"}), () -> defaultValue.dimensionIds().stream().toList(), val -> true);
    private final ForgeConfigSpec.BooleanValue physicsEnabled;
    private final ForgeConfigSpec.ConfigValue<String> physicsEngine;
    private final ForgeConfigSpec.IntValue caveStrengthenFactor;
    private final ForgeConfigSpec.BooleanValue ignoreLiquidPockets;
    private final ForgeConfigSpec.BooleanValue chunkAnalysisEnabled;
    private final ForgeConfigSpec.IntValue minChunkAnalysisAltitude;
    private final ForgeConfigSpec.IntValue maxChunkAnalysisAltitude;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> blockDefinitionBlacklist;
    private final ForgeConfigSpec.ConfigValue<String> defaultBlockDefinition;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> defaultBlocksBlacklist;
    private final ForgeConfigSpec spec;

    protected ForgeWorldDefinitionConfig(File file, WorldDefinitionConfig.Model defaultValue) {
        super(file);
        this.physicsEnabled = this.builder.comment("Whether block physics should be enabled for the dimension(s).").define("PhysicsEnabled", defaultValue.worldDefinition().physicsEnabled());
        this.chunkAnalysisEnabled = this.builder.comment("Whether chunk analysis should be enabled (full physics scans on the blocks of a chunk).\nDisabling chunk analysis can help to improve performance.").define("ChunkAnalysis.Enabled", defaultValue.worldDefinition().chunkAnalysis().enabled());
        this.minChunkAnalysisAltitude = this.builder.comment("The minimum altitude that chunk analysis updates will occur on blocks.").defineInRange("ChunkAnalysis.MinAltitude", defaultValue.worldDefinition().chunkAnalysis().minAltitude(), Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.maxChunkAnalysisAltitude = this.builder.comment("The maximum altitude that chunk analysis updates will occur on blocks.").defineInRange("ChunkAnalysis.MaxAltitude", defaultValue.worldDefinition().chunkAnalysis().maxAltitude(), Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.physicsEngine = this.builder.comment("Specifies which physics engine to use for block physics calculations.\nPlease take care when changing physics engines on existing worlds.\n\t realistic: The most realistic experience.\n\t legacy: The old physics engine used in versions prior to 1.12.2-2.0.0.\n\t simple: A more casual experience. Blocks will only fall if they are not connected to anything.").define("Physics.PhysicsEngine", (Object)defaultValue.worldDefinition().physics().physicsEngine());
        this.blockDefinitionBlacklist = this.builder.comment("A list of block definition names that should not be enabled for the dimension(s).").defineListAllowEmpty(CollectionUtil.listOf((String[])new String[]{"Physics", "BlockDefinitionBlacklist"}), () -> defaultValue.worldDefinition().blockDefinitionBlacklist().stream().toList(), val -> true);
        this.caveStrengthenFactor = this.builder.comment("A factor of additional strengthening to apply to caves.").defineInRange("Physics.CaveStrengthening.StrengthenFactor", defaultValue.worldDefinition().physics().caveStrengthening().strengthenFactor(), 0, 5);
        this.ignoreLiquidPockets = this.builder.comment("Whether cave strengthen calculations should accept liquid pockets as stable areas.").define("Physics.CaveStrengthening.IgnoreLiquidPockets", defaultValue.worldDefinition().physics().caveStrengthening().ignoreLiquidPockets());
        this.defaultBlockDefinition = this.builder.comment("Specifies the default block definition to give to blocks that do not have one specified.\nLeave this empty if you do not wish to apply physics to blocks that do not have a specified block definition.\nNote: Setting this to a block definition that has been blacklisted will only allow it to be applied to blocks that are not within that original block definition.").define("Defaults.DefaultBlockDefinition", (Object)defaultValue.worldDefinition().defaults().defaultBlockDefinition());
        this.defaultBlocksBlacklist = this.builder.comment("A list of block IDs and tags that should not be given default block definitions.\nEntries can be supplied in the below formats:\n\tNamespaces:   '<minecraft>'\n\tTags:         '#forge:stone'\n\tIDs:          'minecraft:stone'").defineListAllowEmpty(CollectionUtil.listOf((String[])new String[]{"Defaults", "DefaultBlocksBlacklist"}), () -> defaultValue.worldDefinition().defaults().defaultBlocksBlacklist().stream().toList(), val -> true);
        this.spec = this.builder.build();
    }

    protected ForgeConfigSpec getConfigSpec() {
        return this.spec;
    }

    private String getDefinitionName() {
        return FileUtil.stripExtension((String)this.file.getName());
    }

    protected WorldDefinitionConfig.Model readValue() {
        HashSet<String> dimensions = new HashSet<String>((Collection)this.dimensions.get());
        return new WorldDefinitionConfig.Model(new RBPWorldDefinition(this.getDefinitionName(), (Boolean)this.physicsEnabled.get(), new RBPWorldDefinition.Physics((String)this.physicsEngine.get(), new RBPWorldDefinition.CaveStrengthening((Integer)this.caveStrengthenFactor.get(), (Boolean)this.ignoreLiquidPockets.get())), new RBPWorldDefinition.ChunkAnalysis((Boolean)this.chunkAnalysisEnabled.get(), (Integer)this.minChunkAnalysisAltitude.get(), (Integer)this.maxChunkAnalysisAltitude.get()), new RBPWorldDefinition.Defaults((String)this.defaultBlockDefinition.get(), new HashSet<String>((Collection)this.defaultBlocksBlacklist.get())), new HashSet<String>((Collection)this.blockDefinitionBlacklist.get())), dimensions);
    }
}

