/*
 * Decompiled with CFR 0.152.
 */
package xbigellx.rbp.internal.entity;

import com.mojang.logging.LogUtils;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.fluids.IFluidBlock;
import org.slf4j.Logger;
import xbigellx.rbp.RealisticBlockPhysics;
import xbigellx.rbp.internal.config.ModConfiguration;
import xbigellx.rbp.internal.level.RBPLevel;
import xbigellx.rbp.internal.level.block.RBPBlockDefinition;
import xbigellx.realisticphysics.internal.level.block.BlockDefinition;
import xbigellx.realisticphysics.internal.level.block.RPBlockContext;

public class RealisticFallingBlockEntity
extends Entity
implements IEntityAdditionalSpawnData {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected static final EntityDataAccessor<BlockPos> DATA_START_POS = SynchedEntityData.m_135353_(RealisticFallingBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    protected static final EntityDataAccessor<BlockPos> DATA_MOVE_POS = SynchedEntityData.m_135353_(RealisticFallingBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private BlockDefinition blockPhysics;
    private BlockState blockState = Blocks.f_49992_.m_49966_();
    private RBPLevel rpLevel;
    private boolean breakOnLand = false;
    private CompoundTag blockEntityData;
    @Nullable
    private BlockPos movePos;
    private double entityDamageMax = 40.0;
    private double baseEntityDamage = 2.0;
    private double prevMotionY = 0.0;
    private boolean relocationEnabled = true;
    private boolean setBlock = true;
    private int fallTime = 0;
    private double impactVolume;

    public RealisticFallingBlockEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public RealisticFallingBlockEntity(Level level, RBPLevel rpLevel, double x, double y, double z, BlockState blockState, RBPBlockDefinition blockPhysics) {
        this((EntityType)RealisticBlockPhysics.EntityTypes.FALLING_BLOCK.get(), level);
        this.rpLevel = rpLevel;
        this.blockState = blockState;
        this.blockPhysics = blockPhysics;
        this.m_6034_(x, (int)y, z);
        this.m_20256_(Vec3.f_82478_);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
        this.setStartPos(this.m_20183_());
        BlockEntity blockEntity = level.m_7702_(this.m_20183_());
        if (blockEntity != null) {
            this.blockEntityData = blockEntity.m_187482_();
        }
        RPBlockContext context = new RPBlockContext(this.m_20183_(), blockState, (BlockDefinition)blockPhysics);
        ModConfiguration modConfig = RealisticBlockPhysics.configManager().getConfig();
        this.baseEntityDamage = blockPhysics.physics().entityDamageScale() * (blockPhysics.physics().mass() / (double)modConfig.main().physics().fallingBlockDamageDampening());
        this.impactVolume = modConfig.main().audio().blockImpactVolume();
        this.relocationEnabled = modConfig.main().physics().fallingBlockRelocation();
        this.breakOnLand = !rpLevel.physicsHelper().isBlockFaceAtEdge(context, Direction.DOWN);
    }

    public static RealisticFallingBlockEntity summon(Level level, RBPLevel rpLevel, BlockPos pos, BlockState state, RBPBlockDefinition blockPhysics) {
        double x = (double)pos.m_123341_() + 0.5;
        double y = pos.m_123342_();
        double z = (double)pos.m_123343_() + 0.5;
        BlockState fallingState = state.m_61138_((Property)BlockStateProperties.f_61362_) ? (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.FALSE) : state;
        RealisticFallingBlockEntity entity = new RealisticFallingBlockEntity(level, rpLevel, x, y, z, fallingState, blockPhysics);
        level.m_46747_(pos);
        level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        level.m_7967_((Entity)entity);
        return entity;
    }

    private void setSyncedData() {
        if (this.movePos != null) {
            this.f_19804_.m_135381_(DATA_MOVE_POS, (Object)this.movePos);
        }
    }

    private void getSyncedData() {
        this.movePos = (BlockPos)this.f_19804_.m_135370_(DATA_MOVE_POS);
    }

    private void syncData() {
        if (!this.f_19853_.f_46443_) {
            this.setSyncedData();
        } else {
            this.getSyncedData();
        }
    }

    private void moveTo(BlockPos pos) {
        this.movePos = pos;
        this.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
        this.syncData();
    }

    public void m_8119_() {
        if (this.blockState.m_60795_()) {
            this.m_146870_();
            return;
        }
        if (!this.f_19853_.f_46443_ && this.blockPhysics == null) {
            this.m_146870_();
            return;
        }
        ++this.fallTime;
        if (this.f_19853_.f_46443_) {
            this.syncData();
            if (!this.movePos.equals((Object)BlockPos.f_121853_)) {
                this.m_6034_((double)this.movePos.m_123341_() + 0.5, this.movePos.m_123342_(), (double)this.movePos.m_123343_() + 0.5);
                this.movePos = BlockPos.f_121853_;
                this.f_19804_.m_135381_(DATA_MOVE_POS, (Object)this.movePos);
            }
        }
        if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        if (!this.f_19853_.f_46443_) {
            BlockPos pos = new BlockPos((Vec3i)this.m_20183_());
            if (!this.f_19861_) {
                if (this.fallTime > 100 && (pos.m_123342_() <= this.f_19853_.m_141937_() || pos.m_123342_() > this.f_19853_.m_151558_()) || this.fallTime > 600) {
                    this.m_146870_();
                }
            } else {
                BlockState existingState = this.f_19853_.m_8055_(pos);
                this.m_20256_(this.m_20184_().m_82542_(0.7, -0.5, 0.7));
                if (existingState.m_60734_() != Blocks.f_50110_) {
                    if (this.setBlock) {
                        Direction slideDirection;
                        double impactForce = this.rpLevel.physicsHelper().calculateImpactForce(this.blockPhysics.physics().mass(), this.prevMotionY * 20.0, 0.9);
                        if (RealisticFallingBlockEntity.evaluateFragility(impactForce, this.blockPhysics.physics().strength())) {
                            this.breakBlock();
                            return;
                        }
                        BlockPos placePos = new BlockPos(this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_);
                        boolean passable = this.rpLevel.physicsHelper().isPassableBlock(placePos);
                        boolean crushed = this.doCrush(placePos, passable, impactForce);
                        if (crushed) {
                            existingState = this.rpLevel.getBlockState(placePos);
                        }
                        if ((slideDirection = this.rpLevel.physicsHelper().getRandomBlockSlideDirection(pos, this.blockPhysics.physics().slideChance(), passable || crushed)) != null) {
                            this.onBlockImpact(placePos);
                            this.moveTo(placePos.m_121945_(slideDirection));
                            return;
                        }
                        boolean canPlace = this.isPlaceableAt(placePos, existingState);
                        if (!canPlace && this.shouldRelocate(placePos)) {
                            BlockPos relocatePos = this.calculateBlockRelocation(placePos);
                            if (relocatePos.m_123341_() != placePos.m_123341_() || relocatePos.m_123343_() != placePos.m_123343_()) {
                                this.moveTo(relocatePos);
                                return;
                            }
                            if (!relocatePos.equals((Object)placePos)) {
                                placePos = relocatePos;
                                canPlace = true;
                            }
                        }
                        if (this.breakOnLand || !canPlace) {
                            this.breakBlock();
                            return;
                        }
                        this.placeBlock(placePos);
                        return;
                    }
                    this.m_146870_();
                }
            }
        }
        this.prevMotionY = this.m_20184_().f_82480_;
        this.m_20256_(this.m_20184_().m_82490_(0.98));
    }

    private static boolean isReplaceableBlockDestroyable(BlockState blockState) {
        return !LiquidBlock.class.isAssignableFrom(blockState.m_60734_().getClass()) && !IFluidBlock.class.isAssignableFrom(blockState.m_60734_().getClass());
    }

    private boolean isPlaceableAt(BlockPos pos, BlockState blockState) {
        RPBlockContext blockContext = new RPBlockContext(pos, blockState, this.rpLevel.physics().blockDefinitions().get(blockState));
        return blockState.m_60710_((LevelReader)this.f_19853_, pos) && (blockState.m_60767_().m_76336_() || this.rpLevel.physicsHelper().getBlockCollisionBounds(blockContext).isEmpty());
    }

    private boolean shouldRelocate(BlockPos pos) {
        if (!this.relocationEnabled) {
            return false;
        }
        RPBlockContext blockContext = this.rpLevel.getBlockContext(pos);
        return this.rpLevel.physicsHelper().isBlockFaceAtEdge(blockContext, Direction.NORTH) && this.rpLevel.physicsHelper().isBlockFaceAtEdge(blockContext, Direction.EAST) && this.rpLevel.physicsHelper().isBlockFaceAtEdge(blockContext, Direction.SOUTH) && this.rpLevel.physicsHelper().isBlockFaceAtEdge(blockContext, Direction.WEST);
    }

    private boolean doCrush(BlockPos targetPos, boolean passable, double impactForce) {
        targetPos = passable ? targetPos.m_7495_() : targetPos;
        RPBlockContext toCrushContext = this.rpLevel.getBlockContext(targetPos);
        BlockDefinition toCrushBlockDef = toCrushContext.blockDefinition();
        if (toCrushBlockDef != null && RealisticFallingBlockEntity.evaluateFragility(impactForce, toCrushBlockDef.physics().strength())) {
            boolean dropResources = this.rpLevel.physicsHelper().shouldBrokenBlockDropResources(targetPos);
            this.f_19853_.m_46961_(targetPos, dropResources);
            return true;
        }
        return false;
    }

    private static boolean evaluateFragility(double force, int strength) {
        double min = (double)strength * 0.85;
        if (force > min) {
            double progress = Mth.m_14008_((double)((force - min) / ((double)strength - min)), (double)0.0, (double)1.0);
            return progress >= 1.0 || Math.random() < progress;
        }
        return false;
    }

    private boolean hasBlockEntity() {
        return this.blockEntityData != null && this.blockState.m_155947_();
    }

    private void breakBlock() {
        BlockPos pos = this.m_20183_();
        this.f_19853_.m_46796_(2001, pos, Block.m_49956_((BlockState)this.blockState));
        this.f_19853_.m_142346_((Entity)this, GameEvent.f_157794_, pos);
        if (this.hasBlockEntity()) {
            BlockEntity blockEntity = BlockEntity.m_155241_((BlockPos)pos, (BlockState)this.blockState, (CompoundTag)this.blockEntityData);
            Block.m_49892_((BlockState)this.blockState, (LevelAccessor)this.f_19853_, (BlockPos)pos, (BlockEntity)blockEntity);
        } else if (this.rpLevel.physicsHelper().shouldBrokenBlockDropResources(pos)) {
            Block.m_49892_((BlockState)this.blockState, (LevelAccessor)this.f_19853_, (BlockPos)pos, null);
        }
        this.m_146870_();
    }

    private void onBlockImpact(BlockPos pos) {
        BlockState replacingState = this.f_19853_.m_8055_(pos);
        if (this.isPlaceableAt(pos, replacingState) && RealisticFallingBlockEntity.isReplaceableBlockDestroyable(replacingState)) {
            boolean dropItem = this.rpLevel.physicsHelper().shouldBrokenBlockDropResources(pos);
            this.f_19853_.m_46961_(pos, dropItem);
        }
        if (this.impactVolume > 0.0) {
            SoundEvent soundType = this.blockState.m_60734_().getSoundType(this.blockState, (LevelReader)this.f_19853_, pos, null).m_56777_();
            this.f_19853_.m_5594_(null, pos, soundType, SoundSource.BLOCKS, (float)this.impactVolume, 1.0f);
        }
    }

    private void onBlockLanded(BlockPos pos) {
        this.onBlockImpact(pos);
    }

    private void placeBlock(BlockPos pos) {
        this.onBlockLanded(pos);
        this.f_19853_.m_7731_(pos, this.blockState, 3);
        this.writeBlockEntityDataTo(pos);
        this.m_146870_();
    }

    private BlockPos calculateBlockRelocation(BlockPos placePos) {
        BlockPos result = placePos;
        int attempts = 0;
        boolean valid = this.rpLevel.physicsHelper().canBlockBeFallenInto(result);
        while (!valid && attempts < 10) {
            Direction randSlide;
            if (++attempts > 1 && (randSlide = this.rpLevel.physicsHelper().getRandomBlockSlideDirection(placePos, 1.0)) != null) {
                result = result.m_121945_(randSlide);
                valid = true;
                break;
            }
            result = result.m_7494_();
            BlockState blockState = this.f_19853_.m_8055_(result);
            valid = this.isPlaceableAt(result, blockState);
        }
        if (!valid) {
            return placePos;
        }
        return result;
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource damageSource) {
        int i;
        if (this.baseEntityDamage > 0.0 && (i = Mth.m_14167_((float)(distance - 1.0f))) > 0) {
            DamageSource damageSource1;
            Predicate predicate;
            if (this.blockState.m_60734_() instanceof Fallable) {
                Fallable fallable = (Fallable)this.blockState.m_60734_();
                predicate = fallable.m_142398_();
                damageSource1 = fallable.m_142088_();
            } else {
                predicate = EntitySelector.f_20408_;
                damageSource1 = DamageSource.f_19322_;
            }
            this.f_19853_.m_6249_((Entity)this, this.m_20191_(), predicate).forEach(entity -> {
                if (entity instanceof LivingEntity) {
                    entity.m_6469_(damageSource1, (float)Math.min(Math.floor((double)i * this.baseEntityDamage), this.entityDamageMax));
                }
            });
            boolean isAnvil = this.blockState.m_204336_(BlockTags.f_13033_);
            if (isAnvil && (double)this.f_19796_.m_188501_() < (double)0.05f + (double)i * 0.05) {
                BlockState blockstate = AnvilBlock.m_48824_((BlockState)this.blockState);
                if (blockstate == null) {
                    this.setBlock = false;
                } else {
                    this.blockState = blockstate;
                }
            }
        }
        return false;
    }

    private void writeBlockEntityDataTo(BlockPos pos) {
        BlockEntity tileEntity;
        if (this.hasBlockEntity() && (tileEntity = this.f_19853_.m_7702_(pos)) != null) {
            CompoundTag compoundTag = tileEntity.m_187482_();
            for (String key : this.blockEntityData.m_128431_()) {
                Tag tag = this.blockEntityData.m_128423_(key);
                if ("x".equals(key) || "y".equals(key) || "z".equals(key)) continue;
                compoundTag.m_128365_(key, tag.m_6426_());
            }
            tileEntity.m_142466_(compoundTag);
            tileEntity.m_6596_();
        }
    }

    protected void m_8097_() {
        this.f_19850_ = true;
        this.f_19804_.m_135372_(DATA_START_POS, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135372_(DATA_MOVE_POS, (Object)BlockPos.f_121853_);
    }

    protected void m_7378_(CompoundTag compound) {
        this.blockState = NbtUtils.m_129241_((CompoundTag)compound.m_128469_("BlockState"));
        this.fallTime = compound.m_128451_("FallTime");
        this.baseEntityDamage = compound.m_128457_("EntityDamage");
        this.entityDamageMax = compound.m_128451_("EntityDamageMax");
        this.breakOnLand = compound.m_128471_("BreakOnLand");
        this.relocationEnabled = compound.m_128471_("RelocationEnabled");
        if (compound.m_128425_("BlockEntityData", 10)) {
            this.blockEntityData = compound.m_128469_("BlockEntityData");
        }
        if (this.blockState.m_60795_()) {
            this.blockState = Blocks.f_49992_.m_49966_();
        }
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128365_("BlockState", (Tag)NbtUtils.m_129202_((BlockState)this.blockState));
        compound.m_128405_("FallTime", this.fallTime);
        compound.m_128347_("EntityDamage", this.baseEntityDamage);
        compound.m_128347_("EntityDamageMax", this.entityDamageMax);
        compound.m_128359_("BlockDefinition", this.blockPhysics.getName());
        compound.m_128379_("BreakOnLand", this.breakOnLand);
        compound.m_128379_("RelocationEnabled", this.relocationEnabled);
        if (this.blockEntityData != null) {
            compound.m_128365_("BlockEntityData", (Tag)this.blockEntityData);
        }
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        CompoundTag compound = new CompoundTag();
        this.m_7380_(compound);
        buffer.m_130079_(compound);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.m_7378_(additionalData.m_130260_());
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this, Block.m_49956_((BlockState)this.blockState()));
    }

    public void m_141965_(ClientboundAddEntityPacket packet) {
        super.m_141965_(packet);
        this.blockState = Block.m_49803_((int)packet.m_131509_());
        this.f_19850_ = true;
        double d0 = packet.m_131500_();
        double d1 = packet.m_131501_();
        double d2 = packet.m_131502_();
        this.m_6034_(d0, d1, d2);
        this.setStartPos(this.m_20183_());
    }

    private void setStartPos(BlockPos p_31960_) {
        this.f_19804_.m_135381_(DATA_START_POS, (Object)p_31960_);
    }

    public BlockPos getStartPos() {
        return (BlockPos)this.f_19804_.m_135370_(DATA_START_POS);
    }

    public BlockState blockState() {
        return this.blockState;
    }

    public BlockDefinition blockDefinition() {
        return this.blockPhysics;
    }
}

