/*
 * Decompiled with CFR 0.152.
 */
package xbigellx.rbp.internal.level;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import xbigellx.rbp.internal.level.RBPLevelPhysics;
import xbigellx.rbp.internal.level.chunk.ChunkDataManager;
import xbigellx.rbp.internal.physics.BlockOperationScheduler;
import xbigellx.rbp.internal.physics.BlockStabilityManager;
import xbigellx.rbp.internal.physics.PhysicsHelper;
import xbigellx.realisticphysics.internal.level.RPDimensionType;
import xbigellx.realisticphysics.internal.level.RPLevelAccessor;
import xbigellx.realisticphysics.internal.level.block.RPBlockContext;
import xbigellx.realisticphysics.internal.level.chunk.RPChunkAccessor;
import xbigellx.realisticphysics.internal.level.chunk.RPChunkReader;
import xbigellx.realisticphysics.internal.physics.task.TaskManagerAccessor;

public class RBPLevel
implements RPLevelAccessor,
RPChunkReader<RPChunkAccessor> {
    private final RPLevelAccessor impl;
    private final RBPLevelPhysics levelPhysics;
    private final ChunkDataManager chunkDataManager;
    private final BlockOperationScheduler blockOperationScheduler;
    private final PhysicsHelper physicsHelper;
    private final BlockStabilityManager blockStabilityManager;

    public RBPLevel(Level mcLevel, RPLevelAccessor impl, RBPLevelPhysics levelPhysics) {
        this.impl = impl;
        this.levelPhysics = levelPhysics;
        this.chunkDataManager = new ChunkDataManager();
        this.blockOperationScheduler = new BlockOperationScheduler(mcLevel, this);
        this.physicsHelper = new PhysicsHelper(mcLevel, this);
        this.blockStabilityManager = new BlockStabilityManager(this);
    }

    public BlockStabilityManager blockStabilityManager() {
        return this.blockStabilityManager;
    }

    public RBPLevelPhysics physics() {
        return this.levelPhysics;
    }

    public FluidState getFluidState(BlockPos blockPos) {
        return this.impl.getFluidState(blockPos);
    }

    public BlockState getBlockState(BlockPos blockPos) {
        return this.impl.getBlockState(blockPos);
    }

    public BlockEntity getBlockEntity(BlockPos blockPos) {
        return this.impl.getBlockEntity(blockPos);
    }

    public RPBlockContext getBlockContext(BlockPos blockPos) {
        return this.impl.getBlockContext(blockPos);
    }

    public boolean chunkExists(ChunkPos chunkPos) {
        return this.impl.chunkExists(chunkPos);
    }

    public RPChunkAccessor getChunk(ChunkPos chunkPos) {
        return this.impl.getChunk(chunkPos);
    }

    public RPChunkAccessor getChunk(BlockPos blockPos) {
        return this.impl.getChunk(blockPos);
    }

    public TaskManagerAccessor taskManager() {
        return this.impl.taskManager();
    }

    public RPDimensionType dimensionType() {
        return this.impl.dimensionType();
    }

    public long getGameTime() {
        return this.impl.getGameTime();
    }

    public int getMinSection() {
        return this.impl.getMinSection();
    }

    public int getMaxSection() {
        return this.impl.getMaxSection();
    }

    public int getSectionsCount() {
        return this.impl.getSectionsCount();
    }

    public boolean isUnloaded() {
        return this.impl.isUnloaded();
    }

    public List<? extends Player> players() {
        return this.impl.players();
    }

    public RandomSource getRandom() {
        return this.impl.getRandom();
    }

    public ChunkDataManager chunkDataManager() {
        return this.chunkDataManager;
    }

    public BlockOperationScheduler blockOperationScheduler() {
        return this.blockOperationScheduler;
    }

    public PhysicsHelper physicsHelper() {
        return this.physicsHelper;
    }
}

