/*
 * Decompiled with CFR 0.152.
 */
package xbigellx.rbp.internal.level.block;

import xbigellx.realisticphysics.internal.level.block.BlockDefinition;

public class RBPBlockDefinition
implements BlockDefinition {
    private final String name;
    private final BlockPhysics physics;
    private final ChunkAnalysis chunkAnalysis;

    public RBPBlockDefinition(String name, BlockPhysics physics, ChunkAnalysis behaviour) {
        this.name = name;
        this.physics = physics;
        this.chunkAnalysis = behaviour;
    }

    public String getName() {
        return this.name;
    }

    public BlockPhysics physics() {
        return this.physics;
    }

    public ChunkAnalysis chunkAnalysis() {
        return this.chunkAnalysis;
    }

    public record BlockPhysics(double mass, int supportStrength, double beamStrength, boolean canAttach, boolean canAttachDiagonally, boolean canHang, double slideChance, double placementSlideModifier, double entityDamageScale, boolean breaksOnFalling, int strength, boolean floatsOnLiquid, BlockDefinition.ExtendedCollisionBounds extendedCollisionBounds) implements BlockDefinition.Physics
    {
        public static final BlockPhysics DEFAULT = new BlockPhysics(650.0, 3000, 0.0, true, false, true, 0.5, 0.1, 1.0, false, 8500, false, new BlockDefinition.ExtendedCollisionBounds());

        public boolean causesEntityDamage() {
            return this.entityDamageScale > 0.0;
        }

        public double hardness() {
            return 0.8;
        }

        public static class Builder {
            private final double mass;
            private int supportStrength = 0;
            private double beamStrength = 0.0;
            private boolean canAttach = true;
            private boolean canAttachDiagonally = false;
            private boolean canHang = true;
            private double slideChance = 0.5;
            private double placementSlideModifier = 0.0;
            private double entityDamageScale = 1.0;
            private boolean breaksOnFalling = false;
            private int strength = 0;
            private double hardness = 0.9;
            private boolean floatsOnLiquid = false;
            private BlockDefinition.ExtendedCollisionBounds extendedCollisionBounds = new BlockDefinition.ExtendedCollisionBounds();

            public Builder(double mass) {
                this.mass = mass;
            }

            public Builder(BlockPhysics physics) {
                this.mass = physics.mass();
                this.setSupportStrength(physics.supportStrength());
                this.setBeamStrength(physics.beamStrength());
                this.setCanAttach(physics.canAttach());
                this.setCanAttachDiagonally(physics.canAttachDiagonally());
                this.setCanHang(physics.canHang());
                this.setSlideChance(physics.slideChance());
                this.setPlacementSlideModifier(physics.placementSlideModifier());
                this.setEntityDamageScale(physics.entityDamageScale());
                this.setBreaksOnFalling(physics.breaksOnFalling());
                this.setHardness(physics.hardness());
                this.setStrength(physics.strength());
                this.setFloatsOnLiquid(physics.floatsOnLiquid());
                this.setExtendedCollisionBounds(physics.extendedCollisionBounds());
            }

            public Builder setSupportStrength(int supportStrength) {
                this.supportStrength = supportStrength;
                return this;
            }

            public Builder setBeamStrength(double beamStrength) {
                this.beamStrength = beamStrength;
                return this;
            }

            public Builder setCanAttach(boolean canAttach) {
                this.canAttach = canAttach;
                return this;
            }

            public Builder setCanAttachDiagonally(boolean canAttachDiagonally) {
                this.canAttachDiagonally = canAttachDiagonally;
                return this;
            }

            public Builder setCanHang(boolean canHang) {
                this.canHang = canHang;
                return this;
            }

            public Builder setSlideChance(double slideChance) {
                this.slideChance = slideChance;
                return this;
            }

            public Builder setPlacementSlideModifier(double placementSlideModifier) {
                this.placementSlideModifier = placementSlideModifier;
                return this;
            }

            public Builder setEntityDamageScale(double entityDamageScale) {
                this.entityDamageScale = entityDamageScale;
                return this;
            }

            public Builder setBreaksOnFalling(boolean breaksOnFalling) {
                this.breaksOnFalling = breaksOnFalling;
                return this;
            }

            public Builder setHardness(double hardness) {
                this.hardness = hardness;
                return this;
            }

            public Builder setStrength(int strength) {
                this.strength = strength;
                return this;
            }

            public Builder setFloatsOnLiquid(boolean floatsOnLiquid) {
                this.floatsOnLiquid = floatsOnLiquid;
                return this;
            }

            public Builder setExtendedCollisionBounds(BlockDefinition.ExtendedCollisionBounds extendedCollisionBounds) {
                this.extendedCollisionBounds = extendedCollisionBounds;
                return this;
            }

            public BlockPhysics build() {
                return new BlockPhysics(this.mass, this.supportStrength, this.beamStrength, this.canAttach, this.canAttachDiagonally, this.canHang, this.slideChance, this.placementSlideModifier, this.entityDamageScale, this.breaksOnFalling, this.strength, this.floatsOnLiquid, this.extendedCollisionBounds);
            }
        }
    }

    public record ChunkAnalysis(boolean enabled) {
        public static final ChunkAnalysis DEFAULT = new ChunkAnalysis(true);

        public static class Builder {
            private boolean receivesAnalysisChecks = true;

            public Builder setReceivesAnalysisChecks(boolean receivesAnalysisChecks) {
                this.receivesAnalysisChecks = receivesAnalysisChecks;
                return this;
            }

            public ChunkAnalysis build() {
                return new ChunkAnalysis(this.receivesAnalysisChecks);
            }
        }
    }
}

