/*
 * Decompiled with CFR 0.152.
 */
package xbigellx.rbp.internal.level.block;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import xbigellx.rbp.RealisticBlockPhysics;
import xbigellx.rbp.internal.config.BlockDefinitionConfig;
import xbigellx.rbp.internal.config.ModConfiguration;
import xbigellx.rbp.internal.config.WorldDefinitionConfig;
import xbigellx.rbp.internal.level.block.RBPBlockDefinition;
import xbigellx.realisticphysics.internal.level.block.BlockDefinitionCatalog;
import xbigellx.realisticphysics.internal.level.block.BlockDefinitionCatalogFactory;
import xbigellx.realisticphysics.internal.util.BlockResolver;
import xbigellx.realisticphysics.internal.util.logging.ModLogger;

public class RBPBlockDefinitionCatalogFactory
implements BlockDefinitionCatalogFactory {
    public BlockDefinitionCatalog create(Level level) {
        String dimensionId = level.m_46472_().m_135782_().toString();
        ModConfiguration modConfig = RealisticBlockPhysics.configManager().getConfig();
        return this.constructBlockDefinitions(modConfig, dimensionId);
    }

    private BlockDefinitionCatalog constructBlockDefinitions(ModConfiguration modConfig, String dimensionId) {
        ModLogger logger = RealisticBlockPhysics.getLogger();
        logger.info("Constructing block definition catalog for dimension '" + dimensionId + "'.");
        Optional<WorldDefinitionConfig.Model> worldConfig = modConfig.worldBlockDefinitions().keySet().stream().filter(w -> w.dimensionIds().contains(dimensionId)).findFirst();
        if (!worldConfig.isPresent()) {
            return BlockDefinitionCatalog.EMPTY;
        }
        HashMap<String, BlockDefinitionConfig.Model> blockDefinitions = new HashMap<String, BlockDefinitionConfig.Model>();
        for (BlockDefinitionConfig.Model config : modConfig.globalBlockDefinitions()) {
            blockDefinitions.put(config.blockDefinition().getName(), config);
        }
        for (BlockDefinitionConfig.Model config : Objects.requireNonNull((ImmutableList)modConfig.worldBlockDefinitions().get((Object)worldConfig.get()))) {
            blockDefinitions.put(config.blockDefinition().getName(), config);
        }
        Set<String> blockDefinitionNames = modConfig.globalBlockDefinitions().stream().map(b -> b.blockDefinition().getName()).collect(Collectors.toSet());
        return this.constructBlockDefinitions(worldConfig.get(), blockDefinitions, blockDefinitionNames);
    }

    private BlockDefinitionCatalog constructBlockDefinitions(WorldDefinitionConfig.Model worldConfig, HashMap<String, BlockDefinitionConfig.Model> blocks, Set<String> blockDefinitionNames) {
        HashMap<String, RBPBlockDefinition> blockDefinitions = new HashMap<String, RBPBlockDefinition>();
        HashMap<BlockState, String> blockMap = new HashMap<BlockState, String>();
        Set<String> blockDefinitionBlacklist = worldConfig.worldDefinition().blockDefinitionBlacklist();
        this.applyDefaultBlocks(worldConfig, blockMap, blockDefinitionNames);
        ModLogger logger = RealisticBlockPhysics.getLogger();
        for (BlockDefinitionConfig.Model blockConfig : blocks.values()) {
            RBPBlockDefinition blockDefinition = blockConfig.blockDefinition();
            blockDefinitions.put(blockDefinition.getName(), blockDefinition);
            boolean remove = blockDefinitionBlacklist.contains(blockConfig.blockDefinition().getName());
            Set blockStates = BlockResolver.resolveStates(blockConfig.blocks());
            for (BlockState blockState : blockStates) {
                if (remove) {
                    blockMap.remove(blockState);
                    continue;
                }
                if (this.isBlockStateSupported(blockState)) {
                    blockMap.put(blockState, blockDefinition.getName());
                    continue;
                }
                logger.warn("Unable to assign physics to unsupported block {} within definition '{}'.", new Object[]{blockState, blockDefinition.getName()});
            }
        }
        return new BlockDefinitionCatalog(blockDefinitions, blockMap);
    }

    private void applyDefaultBlocks(WorldDefinitionConfig.Model worldConfig, HashMap<BlockState, String> blockMap, Set<String> blockDefinitionNames) {
        if (!worldConfig.worldDefinition().defaults().hasDefaultBlockDefinition()) {
            return;
        }
        String defaultDefinition = worldConfig.worldDefinition().defaults().defaultBlockDefinition();
        Set blockStateBlacklist = BlockResolver.resolveStates(worldConfig.worldDefinition().defaults().defaultBlocksBlacklist());
        Set registeredBlocks = ForgeRegistries.BLOCKS.getKeys();
        if (!blockDefinitionNames.contains(defaultDefinition)) {
            throw new IllegalStateException("The configured default block definition '" + defaultDefinition + "' for the world definition '" + worldConfig.worldDefinition().name() + "' does not exist.");
        }
        for (ResourceLocation location : registeredBlocks) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(location);
            assert (block != null);
            for (BlockState blockState : block.m_49965_().m_61056_()) {
                if (blockStateBlacklist.contains(blockState) || blockMap.containsKey(blockState) || !this.isBlockStateSupported(blockState)) continue;
                blockMap.put(blockState, defaultDefinition);
            }
        }
    }

    private boolean isBlockStateSupported(BlockState blockState) {
        return !blockState.m_60734_().equals(Blocks.f_50016_) && !blockState.m_60767_().m_76332_() && !blockState.m_60767_().m_76336_() && !BushBlock.class.isAssignableFrom(blockState.m_60734_().getClass()) && !FlowerBlock.class.isAssignableFrom(blockState.m_60734_().getClass());
    }
}

