/*
 * Decompiled with CFR 0.152.
 */
package xbigellx.rbp.internal.level.chunk;

import com.mojang.logging.LogUtils;
import org.slf4j.Logger;
import xbigellx.realisticphysics.internal.level.chunk.RPChunkAccessor;

public class ChunkCache {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final RPChunkAccessor chunk;
    private Value[][] supportingBlocks;
    private Value[][] passableBlocks;

    public ChunkCache(RPChunkAccessor chunk, int sections) {
        this.chunk = chunk;
        this.supportingBlocks = new Value[sections][4096];
        this.passableBlocks = new Value[sections][4096];
    }

    public void set(int x, int y, int z, Flag flag, Value value) {
        int section = y << 4;
        switch (flag) {
            case FULL_SUPPORT: {
                Value[] cache = this.supportingBlocks[section];
                break;
            }
            case PASSABLE: {
                Value[] cache = this.passableBlocks[section];
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        int index = (z << 8) + (y << 4) + x;
        cache[index] = value;
    }

    public Value get(int x, int y, int z, Flag flag) {
        int section = y >> 4;
        int index = (z << 8) + (y << 4) + x;
        return switch (flag) {
            default -> throw new IncompatibleClassChangeError();
            case Flag.FULL_SUPPORT -> this.supportingBlocks[section][index];
            case Flag.PASSABLE -> this.passableBlocks[section][index];
        };
    }

    public void clear(int x, int y, int z) {
        int section = y >> 4;
        int index = (z << 8) + (y << 4) + x;
        LOGGER.debug("Clearing block cache at index {}", (Object)index);
        this.supportingBlocks[section][index] = Value.NONE;
        this.passableBlocks[section][index] = Value.NONE;
    }

    public static enum Value {
        NONE,
        TRUE,
        FALSE;

    }

    public static enum Flag {
        PASSABLE,
        FULL_SUPPORT;

    }
}

