/*
 * Decompiled with CFR 0.152.
 */
package xbigellx.rbp.internal.level.chunk;

import com.mojang.logging.LogUtils;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.slf4j.Logger;
import xbigellx.rbp.internal.level.chunk.ChunkCache;
import xbigellx.rbp.internal.level.chunk.ChunkCacheManager;
import xbigellx.realisticphysics.internal.level.RPLevelAccessor;
import xbigellx.realisticphysics.internal.level.chunk.RPChunkAccessor;
import xbigellx.realisticphysics.internal.util.LevelUtil;

public class DefaultChunkCacheManager
implements ChunkCacheManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final HashMap<ChunkPos, ChunkCache> cache = new HashMap();
    private final RPLevelAccessor level;

    public DefaultChunkCacheManager(RPLevelAccessor level) {
        this.level = level;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private boolean evaluateLevel(LevelAccessor level) {
        return true;
    }

    private void clearBlockCache(BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos.m_123341_() >> 4, pos.m_123343_() >> 4);
        ChunkCache cache = this.cache.get(chunkPos);
        if (cache == null) {
            return;
        }
        LOGGER.debug("Clearing block cache at position: {}", (Object)pos);
        cache.clear(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    @SubscribeEvent
    public void onBlockNeighbourNotify(BlockEvent.NeighborNotifyEvent event) {
        if (!this.evaluateLevel(event.getLevel())) {
            return;
        }
        for (BlockPos pos : LevelUtil.getSurroundingBlocks((BlockPos)event.getPos(), (int)1)) {
            this.clearBlockCache(pos);
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        if (!this.evaluateLevel(event.getLevel())) {
            return;
        }
        this.clearBlockCache(event.getPos());
    }

    @SubscribeEvent
    public void onBlockPlaced(BlockEvent.EntityPlaceEvent event) {
        if (!this.evaluateLevel(event.getLevel())) {
            return;
        }
        this.clearBlockCache(event.getPos());
    }

    @SubscribeEvent
    public void onBlockMultiPlaced(BlockEvent.EntityMultiPlaceEvent event) {
        if (!this.evaluateLevel(event.getLevel())) {
            return;
        }
        this.clearBlockCache(event.getPos());
    }

    @Override
    public final ChunkCache get(RPChunkAccessor chunk) {
        ChunkCache result = this.cache.get(chunk.pos());
        if (result == null) {
            result = new ChunkCache(chunk, chunk.getSectionsCount());
            this.cache.put(chunk.pos(), result);
        }
        return result;
    }

    @Override
    public final void remove(RPChunkAccessor chunk) {
        this.cache.remove(chunk.pos());
    }
}

