/*
 * Decompiled with CFR 0.152.
 */
package xbigellx.rbp.internal.level.chunk;

import xbigellx.rbp.internal.level.chunk.ChunkAnalysisStatus;
import xbigellx.realisticphysics.internal.level.chunk.RPChunkAccessor;

public class RBPChunkData {
    private final RPChunkAccessor chunk;
    private final ChunkSectionData[] sections;

    public RBPChunkData(RPChunkAccessor chunk) {
        this.chunk = chunk;
        this.sections = new ChunkSectionData[this.chunk.getSectionsCount()];
        for (int i = 0; i < this.sections.length; ++i) {
            this.sections[i] = new ChunkSectionData();
        }
    }

    public ChunkAnalysisStatus getAnalysisStatus() {
        int maxStatus = 0;
        boolean partial = false;
        for (int i = 0; i < this.sections.length; ++i) {
            ChunkSectionData data = this.sections[i];
            int status = data.getAnalysisStatus().ordinal();
            if (data.getAnalysisStatus().ordinal() > maxStatus) {
                maxStatus = status;
            }
            if (status >= ChunkAnalysisStatus.ANALYSED.ordinal()) continue;
            partial = true;
        }
        if (maxStatus == ChunkAnalysisStatus.ANALYSED.ordinal() && !partial) {
            return ChunkAnalysisStatus.ANALYSED;
        }
        return ChunkAnalysisStatus.values()[maxStatus];
    }

    public void setAnalysisRequired() {
        for (int i = 0; i < this.sections.length; ++i) {
            ChunkSectionData data = this.sections[i];
            if (data.getAnalysisStatus().equals((Object)ChunkAnalysisStatus.ANALYSING)) continue;
            data.setAnalysisStatus(ChunkAnalysisStatus.REQUIRED);
        }
    }

    public boolean isAnalysisRequired() {
        for (int i = 0; i < this.sections.length; ++i) {
            ChunkSectionData data = this.sections[i];
            if (!data.getAnalysisStatus().equals((Object)ChunkAnalysisStatus.REQUIRED)) continue;
            return true;
        }
        return false;
    }

    public ChunkSectionData getSectionData(int section) {
        return this.sections[section];
    }

    private void setAnalysisStatus(ChunkAnalysisStatus status, int section) {
        this.getSectionData(section).setAnalysisStatus(status);
    }

    public static class ChunkSectionData {
        private ChunkAnalysisStatus analysisStatus = ChunkAnalysisStatus.NONE;

        public void setAnalysisStatus(ChunkAnalysisStatus status) {
            this.analysisStatus = status;
        }

        public ChunkAnalysisStatus getAnalysisStatus() {
            return this.analysisStatus;
        }
    }
}

