/*
 * Decompiled with CFR 0.152.
 */
package xbigellx.rbp.internal.level.scan;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import xbigellx.rbp.internal.level.RBPLevel;
import xbigellx.rbp.internal.level.scan.BlockScanOptions;
import xbigellx.rbp.internal.level.scan.BlockScanResult;
import xbigellx.rbp.internal.level.scan.BlockTraversalResult;
import xbigellx.rbp.internal.level.scan.ScanAction;
import xbigellx.rbp.internal.level.scan.ScanContext;
import xbigellx.rbp.internal.level.scan.ScanResultType;
import xbigellx.rbp.internal.level.scan.TraversalAction;
import xbigellx.rbp.internal.level.scan.TraversedBlock;
import xbigellx.rbp.internal.level.scan.algorithm.BlockTraverseAlgorithm;

public abstract class BlockScanner<T extends TraversedBlock<T>> {
    private final BlockTraverseAlgorithm scanAlgorithm;
    private final Predicate<T> filter;

    public BlockScanner(BlockTraverseAlgorithm scanAlgorithm) {
        this(scanAlgorithm, node -> true);
    }

    public BlockScanner(BlockTraverseAlgorithm scanAlgorithm, Predicate<T> filter) {
        this.scanAlgorithm = scanAlgorithm;
        this.filter = filter;
    }

    protected abstract Consumer<ScanContext<T>> beginScan(RBPLevel var1, BlockPos var2);

    public BlockScanResult<T> scan(RBPLevel level, BlockPos origin, Function<T, ScanAction> processor) {
        return this.scan(level, origin, BlockScanOptions.DEFAULT, processor);
    }

    public BlockScanResult<T> scan(RBPLevel level, BlockPos origin, BlockScanOptions options, Function<T, ScanAction> processor) {
        Consumer<ScanContext<T>> scanner = this.beginScan(level, origin);
        ScanContext scanContext = new ScanContext(level, origin);
        AtomicInteger scanned = new AtomicInteger();
        AtomicReference<ScanResultType> consumerResultType = new AtomicReference<ScanResultType>(ScanResultType.DONE);
        AtomicReference<ScanResultType> implResultType = new AtomicReference<ScanResultType>(ScanResultType.DONE);
        this.scanAlgorithm.traverse(scanContext.getOrigin(), traversalContext -> {
            scanContext.prepare(traversalContext);
            if (level.isUnloaded()) {
                scanContext.abort();
            } else if (!level.chunkExists(new ChunkPos(traversalContext.getNodePos()))) {
                scanContext.rejectBlock();
            } else {
                scanner.accept(scanContext);
                BlockTraversalResult traversalResult = scanContext.getTraversal().getResult();
                if (traversalResult.getAction().equals((Object)TraversalAction.ACCEPT_BLOCK)) {
                    scanned.getAndIncrement();
                }
                if (scanned.get() >= options.maxAcceptedNodes()) {
                    implResultType.set(ScanResultType.PARTIAL);
                    scanContext.getTraversal().getResult().reset();
                    scanContext.getTraversal().abort();
                } else if (scanContext.shouldConsume() && this.filter.test(traversalResult.getNode())) {
                    ScanAction action = (ScanAction)((Object)((Object)processor.apply(traversalResult.getNode())));
                    if (!action.equals((Object)ScanAction.ACCEPT_BLOCK)) {
                        consumerResultType.set(ScanResultType.PARTIAL);
                    }
                    if (action.equals((Object)ScanAction.REJECT_BLOCK)) {
                        scanContext.getTraversal().getResult().reset();
                        scanContext.getTraversal().rejectBlock();
                    } else if (action.equals((Object)ScanAction.ABORT)) {
                        scanContext.getTraversal().getResult().reset();
                        scanContext.getTraversal().abort();
                    }
                }
            }
            return scanContext.getTraversal().getResult();
        });
        return new BlockScanResult(origin, implResultType.get(), consumerResultType.get(), scanned.get());
    }
}

