/*
 * Decompiled with CFR 0.152.
 */
package xbigellx.rbp.internal.level.scan;

import xbigellx.rbp.internal.level.scan.TraversalAction;
import xbigellx.rbp.internal.level.scan.TraversedBlock;

public class BlockTraversalResult<T extends TraversedBlock> {
    private T scannedBlock;
    private TraversalAction action;
    private boolean resultSet = false;

    private void assertNoResult() {
        if (this.resultSet) {
            throw new IllegalStateException("A result for the scan context has already been set.");
        }
    }

    private void assertResult() {
        if (!this.resultSet) {
            throw new IllegalStateException("A result for the scan context has not been set.");
        }
    }

    public void reset() {
        this.action = null;
        this.scannedBlock = null;
        this.resultSet = false;
    }

    public void setAccept(T scannedBlock) {
        this.assertNoResult();
        this.action = TraversalAction.ACCEPT_BLOCK;
        this.scannedBlock = scannedBlock;
        this.resultSet = true;
    }

    public void setReject() {
        this.assertNoResult();
        this.action = TraversalAction.REJECT_BLOCK;
        this.scannedBlock = null;
        this.resultSet = true;
    }

    public void setRejectOnce() {
        this.assertNoResult();
        this.action = TraversalAction.REJECT_BLOCK_ONCE;
        this.scannedBlock = null;
        this.resultSet = true;
    }

    public void setAbort() {
        this.assertNoResult();
        this.action = TraversalAction.ABORT;
        this.scannedBlock = null;
        this.resultSet = true;
    }

    public T getNode() {
        this.assertResult();
        return this.scannedBlock;
    }

    public TraversalAction getAction() {
        this.assertResult();
        return this.action;
    }
}

