/*
 * Decompiled with CFR 0.152.
 */
package xbigellx.rbp.internal.level.scan;

import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import xbigellx.rbp.internal.level.RBPLevel;
import xbigellx.rbp.internal.level.scan.BlockScanner;
import xbigellx.rbp.internal.level.scan.ScanContext;
import xbigellx.rbp.internal.level.scan.TraversalContext;
import xbigellx.rbp.internal.level.scan.TraversedIntegrityBlock;
import xbigellx.rbp.internal.level.scan.algorithm.BreadthFirstTraverseAlgorithm;
import xbigellx.rbp.internal.physics.rule.BlockPhysicsRules;
import xbigellx.rbp.internal.physics.rule.BlockPhysicsRulesProvider;
import xbigellx.realisticphysics.internal.level.block.RPBlockContext;
import xbigellx.realisticphysics.internal.util.ExtendedDirection;
import xbigellx.realisticphysics.internal.util.VecUtil;

public class RuleBasedIntegrityBlockScanner
extends BlockScanner<TraversedIntegrityBlock> {
    private final BlockPhysicsRulesProvider rulesProvider;

    public RuleBasedIntegrityBlockScanner(BlockPhysicsRulesProvider rulesProvider) {
        super(new BreadthFirstTraverseAlgorithm(8, 2));
        this.rulesProvider = rulesProvider;
    }

    @Override
    protected Consumer<ScanContext<TraversedIntegrityBlock>> beginScan(RBPLevel level, BlockPos origin) {
        RPBlockContext originContext = level.getBlockContext(origin);
        if (originContext.blockDefinition() == null) {
            return ScanContext::abort;
        }
        boolean strengthenCaves = level.physics().settings().physics().caveStrengthening().enabled();
        BlockPhysicsRules blockRules = this.rulesProvider.get(level, originContext);
        return scanContext -> {
            TraversalContext<TraversedIntegrityBlock> traversalContext = scanContext.getTraversal();
            RPBlockContext scanBlockContext = level.getBlockContext(traversalContext.getNodePos());
            BlockPos scanPos = scanBlockContext.pos();
            TraversedIntegrityBlock parent = (TraversedIntegrityBlock)scanContext.getTraversal().getParentNode();
            if (scanPos.m_123342_() - origin.m_123342_() > 8 || scanBlockContext.blockDefinition() == null) {
                scanContext.rejectBlock();
                return;
            }
            if (!traversalContext.isRoot()) {
                int rootDist = VecUtil.getChessboardDistance((Vec3i)origin, (Vec3i)scanPos);
                ExtendedDirection parentDir = traversalContext.directionToParent();
                if (parentDir.getAxis().isDiagonal() && rootDist > 8) {
                    scanContext.rejectBlockOnce();
                    return;
                }
                if (!RuleBasedIntegrityBlockScanner.isNodeConnectedToParent(level, traversalContext) || !scanBlockContext.hasBlockDefinition()) {
                    scanContext.rejectBlockOnce();
                    return;
                }
            }
            boolean isCave = false;
            if (strengthenCaves && (traversalContext.isRoot() || scanBlockContext.pos().m_123342_() <= origin.m_123342_())) {
                isCave = blockRules.isCaveCeiling().evaluate(level, scanBlockContext);
            }
            boolean supportCheck = traversalContext.isRoot() || !traversalContext.directionToParent().equals((Object)ExtendedDirection.UP);
            boolean supported = isCave;
            if (!supported && supportCheck && blockRules.isSupportPillar().evaluate(level, scanBlockContext, parent != null ? (int)parent.cumulativeWeight() : 0)) {
                supported = true;
            }
            TraversedIntegrityBlock traversedNode = RuleBasedIntegrityBlockScanner.createNode(level, scanBlockContext, scanContext.getTraversal(), supported);
            scanContext.acceptBlock(traversedNode, true);
        };
    }

    private static boolean isNodeConnectedToParent(RBPLevel level, TraversalContext<TraversedIntegrityBlock> scanned) {
        RPBlockContext parentContext = scanned.getParentNode().blockContext();
        ExtendedDirection directionToParent = scanned.directionToParent();
        return level.physics().physicsEngine().isBlockConnectableToNeighbour(level, parentContext, directionToParent.getOpposite());
    }

    private static TraversedIntegrityBlock createNode(RBPLevel level, RPBlockContext blockContext, TraversalContext<TraversedIntegrityBlock> context, boolean supported) {
        double cumulativeWeight;
        double nextBeamSupportCost;
        double nextSupportCost;
        TraversedIntegrityBlock parent = context.getParentNode();
        double blockWeight = level.physics().getBlockWeight(blockContext);
        double baseSupportCost = RuleBasedIntegrityBlockScanner.calculateSupportCost(context, blockWeight);
        if (context.isRoot()) {
            nextSupportCost = baseSupportCost;
            nextBeamSupportCost = 0.0;
            cumulativeWeight = blockWeight;
        } else if (context.directionToParent().equals((Object)ExtendedDirection.UP) && level.physicsHelper().isBlockFaceTouchingNeighbour(blockContext, ExtendedDirection.DOWN)) {
            assert (parent != null);
            nextSupportCost = parent.baseSupportCost();
            nextBeamSupportCost = parent.beamSupportCost() + Math.max(0.0, baseSupportCost - parent.baseSupportCost());
            cumulativeWeight = parent.cumulativeWeight() + blockWeight;
        } else {
            double beamStrength = Objects.requireNonNull(blockContext.blockDefinition()).physics().beamStrength();
            assert (parent != null);
            double beamCost = parent.beamSupportCost() * (1.0 - beamStrength);
            if (context.directionToParent().equals((Object)ExtendedDirection.UP) && beamStrength == 1.0) {
                baseSupportCost = 0.0;
            }
            nextSupportCost = baseSupportCost + beamCost;
            nextBeamSupportCost = 0.0;
            cumulativeWeight = parent.cumulativeWeight() + blockWeight;
        }
        boolean crushed = false;
        if (!context.isRoot() && context.directionToParent().getNormal().m_123342_() > 0) {
            crushed = level.physics().physicsEngine().shouldForceBreakBlock(level, blockContext, (int)cumulativeWeight);
        }
        return new TraversedIntegrityBlock(blockContext, nextSupportCost, nextBeamSupportCost, cumulativeWeight, supported, crushed, parent);
    }

    private static double calculateSupportCost(TraversalContext<TraversedIntegrityBlock> scanned, double weight) {
        if (scanned.getParentNode() != null) {
            double weakness = 1.0;
            if (scanned.directionToParent().getAxis().isDiagonal()) {
                weakness = 2.0;
            }
            return weight + weakness * scanned.getParentNode().baseSupportCost();
        }
        return weight;
    }
}

