/*
 * Decompiled with CFR 0.152.
 */
package xbigellx.rbp.internal.level.scan;

import net.minecraft.core.BlockPos;
import xbigellx.rbp.internal.level.RBPLevel;
import xbigellx.rbp.internal.level.scan.ScanContextAccessor;
import xbigellx.rbp.internal.level.scan.TraversalContext;
import xbigellx.rbp.internal.level.scan.TraversedBlock;

public class ScanContext<T extends TraversedBlock<T>>
implements ScanContextAccessor<T> {
    private final RBPLevel level;
    private final BlockPos origin;
    private TraversalContext<T> traversalContext;
    private boolean resultSet = false;
    private boolean consume;

    public ScanContext(RBPLevel level, BlockPos origin) {
        this.level = level;
        this.origin = origin;
    }

    public void prepare(TraversalContext<T> traversalContext) {
        this.traversalContext = traversalContext;
        this.reset();
    }

    private void assertNoResult() {
        if (this.resultSet) {
            throw new IllegalStateException("A result for the scan context has already been set.");
        }
    }

    private void assertResult() {
        if (!this.resultSet) {
            throw new IllegalStateException("A result for the scan context has not been set.");
        }
    }

    @Override
    public BlockPos getOrigin() {
        return this.origin;
    }

    @Override
    public RBPLevel getLevel() {
        return this.level;
    }

    @Override
    public void acceptBlock(T node, boolean consume) {
        this.assertNoResult();
        this.traversalContext.acceptBlock(node);
        this.consume = consume;
        this.resultSet = true;
    }

    @Override
    public void rejectBlock() {
        this.assertNoResult();
        this.traversalContext.rejectBlock();
        this.resultSet = true;
    }

    @Override
    public void rejectBlockOnce() {
        this.assertNoResult();
        this.traversalContext.rejectBlockOnce();
        this.resultSet = true;
    }

    @Override
    public void abort() {
        this.assertNoResult();
        this.traversalContext.abort();
        this.resultSet = true;
    }

    private void reset() {
        this.consume = false;
        this.resultSet = false;
    }

    public boolean isResultSet() {
        return this.resultSet;
    }

    public TraversalContext<T> getTraversal() {
        if (this.traversalContext == null) {
            throw new IllegalStateException();
        }
        return this.traversalContext;
    }

    public boolean shouldConsume() {
        this.assertResult();
        return this.consume;
    }
}

