/*
 * Decompiled with CFR 0.152.
 */
package xbigellx.rbp.internal.level.scan;

import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import xbigellx.rbp.internal.level.RBPLevel;
import xbigellx.rbp.internal.level.scan.BlockScanner;
import xbigellx.rbp.internal.level.scan.ScanContext;
import xbigellx.rbp.internal.level.scan.TraversalContext;
import xbigellx.rbp.internal.level.scan.TraversedIntegrityBlock;
import xbigellx.rbp.internal.level.scan.algorithm.BlockTraverseAlgorithm;
import xbigellx.rbp.internal.physics.rule.SimpleSupportPillarRule;
import xbigellx.rbp.internal.physics.rule.SupportPillarRule;
import xbigellx.rbp.internal.physics.rule.WeightBasedSupportPillarRule;
import xbigellx.realisticphysics.internal.level.block.BlockDefinition;
import xbigellx.realisticphysics.internal.level.block.RPBlockContext;
import xbigellx.realisticphysics.internal.util.ExtendedDirection;

public class SimpleIntegrityBlockScanner
extends BlockScanner<TraversedIntegrityBlock> {
    private static final SupportPillarRule PILLAR_RULE_1 = new WeightBasedSupportPillarRule();
    private static final SupportPillarRule PILLAR_RULE_2 = new SimpleSupportPillarRule();
    private static final ExtendedDirection[] DIRECTIONS = new ExtendedDirection[]{ExtendedDirection.UP, ExtendedDirection.WEST, ExtendedDirection.EAST, ExtendedDirection.NORTH, ExtendedDirection.SOUTH};
    private final int vSearch;
    private final int hSearch;
    private final boolean weightPillars;

    public SimpleIntegrityBlockScanner(BlockTraverseAlgorithm algorithm, int vSearch, int hSearch, boolean weightPillars) {
        super(algorithm);
        this.vSearch = vSearch;
        this.hSearch = hSearch;
        this.weightPillars = weightPillars;
    }

    public SimpleIntegrityBlockScanner(BlockTraverseAlgorithm algorithm, boolean weightPillars) {
        this(algorithm, Short.MAX_VALUE, Short.MAX_VALUE, weightPillars);
    }

    @Override
    protected Consumer<ScanContext<TraversedIntegrityBlock>> beginScan(RBPLevel level, BlockPos origin) {
        RPBlockContext blockContext = level.getBlockContext(origin);
        if (blockContext.blockDefinition() == null) {
            return ScanContext::abort;
        }
        return scanContext -> {
            boolean supportCheck;
            TraversalContext traversalContext = scanContext.getTraversal();
            RPBlockContext scanBlockContext = level.getBlockContext(traversalContext.getNodePos());
            BlockPos scanPos = scanBlockContext.pos();
            if (scanBlockContext.blockDefinition() == null) {
                scanContext.rejectBlock();
                return;
            }
            if (Math.abs(scanPos.m_123342_() - origin.m_123342_()) > this.vSearch || Math.abs(scanPos.m_123341_() - origin.m_123341_()) > this.hSearch || Math.abs(scanPos.m_123343_() - origin.m_123343_()) > this.hSearch) {
                scanContext.rejectBlock();
                return;
            }
            BlockDefinition blockDefinition = scanBlockContext.blockDefinition();
            TraversedIntegrityBlock parent = (TraversedIntegrityBlock)traversalContext.getParentNode();
            if (!traversalContext.isRoot()) {
                ExtendedDirection parentDir = traversalContext.directionToParent();
                if (parentDir.getAxis().isDiagonal() && level.physicsHelper().isBlockEncased(scanBlockContext)) {
                    scanContext.rejectBlockOnce();
                    return;
                }
                if (!level.physics().physicsEngine().isBlockConnectableToNeighbour(level, parent.blockContext(), parentDir.getOpposite()) || blockDefinition == null) {
                    scanContext.rejectBlockOnce();
                    return;
                }
            }
            boolean supported = false;
            boolean bl = supportCheck = traversalContext.isRoot() || !traversalContext.directionToParent().equals((Object)ExtendedDirection.UP) && (scanPos.m_123342_() <= origin.m_123342_() || !traversalContext.directionToParent().equals((Object)ExtendedDirection.DOWN));
            if (supportCheck) {
                supported = this.weightPillars && scanPos.m_123342_() <= origin.m_123342_() ? PILLAR_RULE_1.evaluate(level, scanBlockContext, 0) : PILLAR_RULE_2.evaluate(level, scanBlockContext, 0);
            }
            TraversedIntegrityBlock traversed = new TraversedIntegrityBlock(scanBlockContext, 0.0, 0.0, 0.0, supported, false, parent);
            scanContext.acceptBlock(traversed, true);
        };
    }
}

