/*
 * Decompiled with CFR 0.152.
 */
package xbigellx.rbp.internal.level.scan;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import xbigellx.rbp.internal.level.scan.BlockTraversalResult;
import xbigellx.rbp.internal.level.scan.TraversedBlock;
import xbigellx.realisticphysics.internal.util.ExtendedDirection;

public class TraversalContext<T extends TraversedBlock<T>> {
    private final BlockPos origin;
    private BlockPos nodePos;
    private T parent;
    private int cost = 0;
    private BlockTraversalResult<T> result;

    public TraversalContext(BlockPos origin) {
        this.origin = origin;
        this.nodePos = origin;
        this.result = new BlockTraversalResult();
    }

    public int getTraversalCost() {
        return this.cost;
    }

    public T getParentNode() {
        return this.parent;
    }

    public BlockPos getOrigin() {
        return this.origin;
    }

    public BlockPos getNodePos() {
        return this.nodePos;
    }

    public void prepare(BlockPos nodePos, T parent, int cost) {
        this.nodePos = nodePos;
        this.parent = parent;
        this.cost = cost;
        this.result.reset();
    }

    public void acceptBlock(T node) {
        if (!((TraversedBlock)node).blockPos().equals((Object)this.nodePos)) {
            throw new IllegalArgumentException("The provided node does not match the position of the traversal.");
        }
        this.result.setAccept(node);
    }

    public void rejectBlock() {
        this.result.setReject();
    }

    public void rejectBlockOnce() {
        this.result.setRejectOnce();
    }

    public void abort() {
        this.result.setAbort();
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public ExtendedDirection directionToParent() {
        T parent = this.getParentNode();
        if (parent == null) {
            throw new IllegalStateException("There is no parent to determine the direction to.");
        }
        return ExtendedDirection.fromDelta((Vec3i)((TraversedBlock)parent).blockPos().m_121996_((Vec3i)this.nodePos));
    }

    public BlockTraversalResult<T> getResult() {
        return this.result;
    }
}

